/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtil;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestData;
import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level0-datasource.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public abstract class EmbeddedCrowdUpgradeTestBase {
    @Autowired
    private DataSource dataSource;
    protected DefaultDBControl dbControl;
    protected Connection connection;
    protected EmbeddedCrowdUpgradeTestData db;
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule(Level.DEBUG);

    @Before
    public void setup() throws Exception {
        DatabaseConfig dbConfig = UpgradeTestUtil.createDbConfig(this.dataSource);
        this.dbControl = UpgradeTestUtil.createDbControl(dbConfig, this.dataSource);
        this.connection = this.dataSource.getConnection();
        this.db = new EmbeddedCrowdUpgradeTestData(this.dbControl, this.connection);
    }

    @After
    public void tearDown() throws Exception {
        JDBCHelper.closeQuietly((Connection)this.connection);
        UpgradeTestUtil.dropTables(this.dataSource);
    }

    protected void preUpgrade() throws CruDBException {
        this.dbControl.createTables(92);
        this.dbControl.addConstraints(92);
        this.dbControl.addInitData(92);
    }
}

