/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTaskWarningMessageSource;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.web.filters.SystemMessage;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public class EmbeddedCrowdUpgradeTaskWarningMessageSourceTest {
    private static final String ISO_8859_2 = "ISO8859_2";
    private static final String INFO_LINE = "2015-10-21 07:28:00,000 INFO  - We did it, doc!";
    private static final String WARN_LINE = "1955-11-05 07:28:00,000 WARN - I like the 50s, though that's unexpected.";
    private static final String ERROR_LINE = "1885-01-01 12:00:00,000 ERROR - Damn, I'm in Wild West!";
    private static final String ISO_8859_2_LINE = "1885-01-01 12:00:00,000 INFO - Successfully migrated user 'Si\u0119\u017cyr Niedo\u0142\u00f3\u017c-\u0106wi\u0105ka\u0142a'";
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();
    @Rule
    public final ClearDefaultCharset clearDefaultCharset = new ClearDefaultCharset();
    private Path logFileHasWarnings;
    private Path logFileHasErrors;
    private Path logFileHasOnlyInfo;
    private Path logFileDoesNotExist;
    private Path logFileHasOnlyInfo_ISO8859_2_Encoding;
    private Path logFileHasErrors_ISO8859_2_Encoding;
    private EffectiveUserProvider effectiveUserProvider;
    private RepositoryPropertyManager propertyManager;

    @Before
    public void setUp() throws Exception {
        this.logFileHasOnlyInfo = Files.createTempFile(null, null, new FileAttribute[0]);
        this.logFileHasWarnings = Files.createTempFile(null, null, new FileAttribute[0]);
        this.logFileHasErrors = Files.createTempFile(null, null, new FileAttribute[0]);
        this.logFileHasOnlyInfo_ISO8859_2_Encoding = Files.createTempFile(null, null, new FileAttribute[0]);
        this.logFileHasErrors_ISO8859_2_Encoding = Files.createTempFile(null, null, new FileAttribute[0]);
        this.logFileDoesNotExist = Files.createTempDirectory(null, new FileAttribute[0]).resolve("thisFileDoesNotExist");
        Files.write(this.logFileHasOnlyInfo, (Iterable<? extends CharSequence>)ImmutableList.of((Object)INFO_LINE, (Object)INFO_LINE, (Object)INFO_LINE), new OpenOption[0]);
        Files.write(this.logFileHasWarnings, (Iterable<? extends CharSequence>)ImmutableList.of((Object)INFO_LINE, (Object)WARN_LINE, (Object)INFO_LINE), new OpenOption[0]);
        Files.write(this.logFileHasErrors, (Iterable<? extends CharSequence>)ImmutableList.of((Object)INFO_LINE, (Object)ERROR_LINE, (Object)INFO_LINE), new OpenOption[0]);
        Files.write(this.logFileHasOnlyInfo_ISO8859_2_Encoding, (Iterable<? extends CharSequence>)ImmutableList.of((Object)INFO_LINE, (Object)ISO_8859_2_LINE, (Object)INFO_LINE), Charset.forName(ISO_8859_2), new OpenOption[0]);
        Files.write(this.logFileHasErrors_ISO8859_2_Encoding, (Iterable<? extends CharSequence>)ImmutableList.of((Object)INFO_LINE, (Object)ISO_8859_2_LINE, (Object)ERROR_LINE), Charset.forName(ISO_8859_2), new OpenOption[0]);
        this.effectiveUserProvider = (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class);
        this.propertyManager = (RepositoryPropertyManager)Mockito.mock(RepositoryPropertyManager.class);
    }

    @Test
    public void testFileDoesNotExist() throws Exception {
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileDoesNotExist);
        Assert.assertThat(messageList, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.effectiveUserProvider, this.propertyManager});
    }

    @Test
    public void testLogsHaveOnlyInfoFileHasISO8859_2_Encoding() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        System.setProperty("file.encoding", ISO_8859_2);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasOnlyInfo_ISO8859_2_Encoding);
        EmbeddedCrowdUpgradeTaskWarningMessageSourceTest.assertMessage(messageList, this.logFileHasOnlyInfo_ISO8859_2_Encoding, ExpectedMessage.SUCCESS);
    }

    @Test
    public void testLogsHaveErrorFileHasISO8859_2_Encoding() throws Exception {
        System.setProperty("file.encoding", ISO_8859_2);
        this.doTestLogsHaveErrorFileHasISO8859_2_Encoding();
    }

    @Test
    public void testLogsHaveErrorFileHasISO8859_2_EncodingButWeThinkUTF_8() throws Exception {
        System.setProperty("file.encoding", "UTF8");
        this.doTestLogsHaveErrorFileHasISO8859_2_Encoding();
    }

    private void doTestLogsHaveErrorFileHasISO8859_2_Encoding() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasErrors_ISO8859_2_Encoding);
        EmbeddedCrowdUpgradeTaskWarningMessageSourceTest.assertMessage(messageList, this.logFileHasErrors_ISO8859_2_Encoding, ExpectedMessage.PROBLEM);
    }

    @Test
    public void testLogsHaveOnlyInfo() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasOnlyInfo);
        EmbeddedCrowdUpgradeTaskWarningMessageSourceTest.assertMessage(messageList, this.logFileHasOnlyInfo, ExpectedMessage.SUCCESS);
    }

    @Test
    public void testUserNotAdmin() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)false);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasWarnings);
        Assert.assertThat(messageList, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.propertyManager});
    }

    @Test
    public void testLogsHaveWarnings() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasWarnings);
        EmbeddedCrowdUpgradeTaskWarningMessageSourceTest.assertMessage(messageList, this.logFileHasWarnings, ExpectedMessage.PROBLEM);
    }

    @Test
    public void testLogsHaveErrors() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasErrors);
        EmbeddedCrowdUpgradeTaskWarningMessageSourceTest.assertMessage(messageList, this.logFileHasErrors, ExpectedMessage.PROBLEM);
    }

    @Test
    public void testMessageIsDismissed() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyManager.loadGlobalProperty("com.atlassian.fecru.properties.dialogDismissed.embeddedCrowd4.0UpgradeTaskWarning")).thenReturn((Object)"true");
        List<SystemMessage> messageList = this.getMessagesWhen(this.logFileHasErrors);
        Assert.assertThat(messageList, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        ((RepositoryPropertyManager)Mockito.verify((Object)this.propertyManager)).loadGlobalProperty(org.mockito.Matchers.anyString());
    }

    private List<SystemMessage> getMessagesWhen(Path logFilePath) throws Exception {
        EmbeddedCrowdUpgradeTaskWarningMessageSource messageSource = new EmbeddedCrowdUpgradeTaskWarningMessageSource(this.effectiveUserProvider, this.propertyManager, logFilePath);
        messageSource.grepLogForWarnings();
        return messageSource.getMessages(null);
    }

    private static void assertMessage(List<SystemMessage> messageList, Path file, ExpectedMessage expected) {
        Assert.assertEquals((long)1L, (long)messageList.size());
        SystemMessage systemMessage = messageList.get(0);
        Assert.assertThat((Object)systemMessage.getText(), (Matcher)Matchers.is((Object)(expected.message + file + ".")));
        Assert.assertThat((Object)systemMessage.getUrl(), (Matcher)Matchers.is((Object)HelpUtil.getFishEyeHelpPath((String)"fisheye.upgrade.notes.4.0")));
        Assert.assertTrue((boolean)systemMessage.isAdminOnly());
        Assert.assertThat(systemMessage.getMessageDismissedProperty().get(), (Matcher)Matchers.is((Object)"com.atlassian.fecru.properties.dialogDismissed.embeddedCrowd4.0UpgradeTaskWarning"));
    }

    private class ClearDefaultCharset
    extends ExternalResource {
        private ClearDefaultCharset() {
        }

        protected void before() throws Throwable {
            this.clearDefaultCharset();
        }

        protected void after() {
            this.clearDefaultCharset();
        }

        private void clearDefaultCharset() {
            try {
                FieldUtils.writeDeclaredStaticField(Charset.class, (String)"defaultCharset", null, (boolean)true);
            }
            catch (IllegalAccessException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private static enum ExpectedMessage {
        PROBLEM("User data upgrade experienced problems. Please review WARN/ERROR logs in "),
        SUCCESS("User data has been successfully upgraded. Please review details in ");

        private final String message;

        private ExpectedMessage(String message) {
            this.message = message;
        }
    }
}

