/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestBase;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestData;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.config1.SystemAdmins;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.AnyOf;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class EmbeddedCrowdUpgradeTaskTest
extends EmbeddedCrowdUpgradeTestBase {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private SystemAdmins systemAdmins;
    private SecurityType security;

    @Before
    public void mockConfigXml() throws Exception {
        ConfigDocument.Config config = ConfigDocument.Factory.newInstance().addNewConfig();
        this.security = config.addNewSecurity();
        this.systemAdmins = this.security.addNewAdmins().addNewSystemAdmins();
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getConfig()).thenReturn((Object)config);
    }

    @Test
    public void testCreate() throws Exception {
        this.dbControl.createTables(93);
        this.dbControl.addConstraints(93);
        this.dbControl.addInitData(93);
        this.verifyCrowdInitialData();
        this.verifyDefaultGroupsData();
    }

    @Test
    public void shouldCreateBasicSchema() throws Exception {
        this.preUpgrade();
        this.doUpgrade();
        this.verifyCrowdInitialData();
    }

    @Test
    public void userMigrationShouldMoveUsersToInternalDirectory() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "User1", "User User", "user1@Userland.com", "{PKCS5S2}hash", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "User2", "User User", "user1@Userland.com", "{PKCS5S2}hash", LegacyAuthType.CROWD);
        this.db.addLegacyUser(3, "USER3", "USER User", "USER@Userland.com", "md5something", LegacyAuthType.CUSTOM);
        this.db.addLegacyUser(4, "User4", LegacyAuthType.AJP);
        this.db.addLegacyUser(5, "USer5", null, null, "{PKCS5S2}hash", LegacyAuthType.HOST);
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdUser(1, "User1", "User User", "user1@Userland.com", "{PKCS5S2}hash", 1), EmbeddedCrowdUpgradeTestData.matchCwdUser(3, "USER3", "USER User", "USER@Userland.com", PasswordCredential.NONE.getCredential(), 1), EmbeddedCrowdUpgradeTestData.matchCwdUser(4, "User4", null, null, PasswordCredential.NONE.getCredential(), 1), EmbeddedCrowdUpgradeTestData.matchCwdUser(5, "USer5", null, null, PasswordCredential.NONE.getCredential(), 1)}));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("Done migrating properties for 5 users")));
    }

    @Test
    public void userMigrationShouldNormalizeUsernames() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "User1", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "User2", LegacyAuthType.AJP);
        this.db.addLegacyUser(3, "User3", LegacyAuthType.CUSTOM);
        this.db.addLegacyUser(4, "User4", LegacyAuthType.HOST);
        this.db.addLegacyUser(5, "User5", LegacyAuthType.CROWD);
        this.db.addLegacyUser(6, "User6", LegacyAuthType.LDAP);
        this.addStar(1, "foo", "bar", "User1");
        this.addStar(2, StarType.USER.getName(), "User2", "User3");
        this.addStar(3, "fake", "bar", "user4");
        this.addStar(4, StarType.USER.getName(), "user4", "User1");
        this.addStar(5, StarType.USER.getName(), "User1", "user4");
        this.addRecentlyVisited("User4", "atlassian-project", "CAV", 1L);
        this.addRecentlyVisited("User5", RecentlyVisitedItem.Type.USER.getType(), "User6", 2L);
        this.addRecentlyVisited("user4", "atlassian-project", "FAKE", 3L);
        this.addRecentlyVisited("User5", RecentlyVisitedItem.Type.USER.getType(), "user6", 4L);
        this.addRecentlyVisited("user5", RecentlyVisitedItem.Type.USER.getType(), "User6", 5L);
        this.addCommitterMapping("committer1", "repo1", "User3");
        this.addCommitterMapping("committer2", "repo1", "user1");
        this.addUserPermission("action:1", "User5", 1);
        this.addUserPermission("action:2", "user1", 1);
        this.systemAdmins.addUser("User4");
        this.systemAdmins.addUser("user1");
        this.doUpgrade();
        MatcherAssert.assertThat((String)"Users should be normalized in cru_user", this.db.getRows("cru_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCruUser(1, "user1"), EmbeddedCrowdUpgradeTestData.matchCruUser(2, "user2"), EmbeddedCrowdUpgradeTestData.matchCruUser(3, "user3"), EmbeddedCrowdUpgradeTestData.matchCruUser(4, "user4"), EmbeddedCrowdUpgradeTestData.matchCruUser(5, "user5"), EmbeddedCrowdUpgradeTestData.matchCruUser(6, "user6")}));
        MatcherAssert.assertThat((String)"Should normalize stars", this.db.getRows("cru_base_star_model"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_star_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_star_id", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user3"), (Matcher)Matchers.hasEntry((Object)"cru_string_key1", (Object)"user2"))}));
        MatcherAssert.assertThat((String)"Should normalize recently visited", this.db.getRows("cru_recently_visited"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_last_viewed", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user4")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_last_viewed", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user5"), (Matcher)Matchers.hasEntry((Object)"cru_entity_id", (Object)"user6"))}));
        MatcherAssert.assertThat((String)"Should normalize committer mappings", this.db.getRows("cru_committer_user_mapping"), (Matcher)Matchers.containsInAnyOrder((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_committer_name", (Object)"committer1"), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user3"))));
        MatcherAssert.assertThat((String)"Should normalize permission schemes", this.db.getRows("cru_ps_user"), (Matcher)Matchers.containsInAnyOrder(this.matchPermission("action:1", "user5")));
        MatcherAssert.assertThat((String)"Should normalize sysadmins", (Object)ImmutableList.copyOf((Object[])this.systemAdmins.getUserArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"user4"}));
    }

    @Test
    public void userMigrationShouldRenameDuplicateUsers() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "user1", "1", null, null, LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "User1", "2", null, null, LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(3, "USER1_Migration1", "3", null, null, LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(4, "USER1", "4", null, null, LegacyAuthType.AJP);
        this.db.addLegacyUser(5, "UsER1", "5", null, null, LegacyAuthType.HOST);
        this.addStar(1, "foo", "bar", "USER1");
        this.addStar(2, StarType.USER.getName(), "USER1", "user1");
        this.addRecentlyVisited("User1", "atlassian-project", "CAV", 1L);
        this.addRecentlyVisited("user1", RecentlyVisitedItem.Type.USER.getType(), "User1", 2L);
        this.addCommitterMapping("committer1", "repo1", "USER1");
        this.addCommitterMapping("committer2", "repo1", "UsER1");
        this.addUserPermission("action:1", "user1", 1);
        this.addUserPermission("action:2", "USER1", 1);
        this.addLoginCookie(1, 2);
        this.addLoginCookie(2, 1);
        this.systemAdmins.addUser("user1");
        this.systemAdmins.addUser("User1");
        this.doUpgrade();
        MatcherAssert.assertThat((String)"Users should be migrated to internal directory", this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdUser(1, "user1"), EmbeddedCrowdUpgradeTestData.matchCwdUser(3, "USER1_Migration1"), EmbeddedCrowdUpgradeTestData.matchCwdUser(2, "User1_migration2"), EmbeddedCrowdUpgradeTestData.matchCwdUser(4, "USER1_migration3"), EmbeddedCrowdUpgradeTestData.matchCwdUser(5, "UsER1_migration4")}));
        MatcherAssert.assertThat((String)"All users should be renamed in cru_user", this.db.getRows("cru_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCruUser(1, "user1"), EmbeddedCrowdUpgradeTestData.matchCruUser(2, "user1_migration2"), EmbeddedCrowdUpgradeTestData.matchCruUser(3, "user1_migration1"), EmbeddedCrowdUpgradeTestData.matchCruUser(4, "user1_migration3"), EmbeddedCrowdUpgradeTestData.matchCruUser(5, "user1_migration4")}));
        MatcherAssert.assertThat((String)"Should remove renamed users' cookie, but keep others", this.db.getRows("cru_login_cookie"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"cru_user_id", (Object)1)})));
        MatcherAssert.assertThat((String)"Should rename stars", this.db.getRows("cru_base_star_model"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_star_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1_migration3")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_star_id", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1"), (Matcher)Matchers.hasEntry((Object)"cru_string_key1", (Object)"user1_migration3"))}));
        MatcherAssert.assertThat((String)"Should rename recently visited", this.db.getRows("cru_recently_visited"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_last_viewed", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1_migration2")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_last_viewed", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1"), (Matcher)Matchers.hasEntry((Object)"cru_entity_id", (Object)"user1_migration2"))}));
        MatcherAssert.assertThat((String)"Should rename committer mappings", this.db.getRows("cru_committer_user_mapping"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_committer_name", (Object)"committer1"), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1_migration3")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_committer_name", (Object)"committer2"), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)"user1_migration4"))}));
        MatcherAssert.assertThat((String)"Should rename sysadmins", (Object)ImmutableList.copyOf((Object[])this.systemAdmins.getUserArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"user1", "user1_migration2"}));
        MatcherAssert.assertThat((String)"Should rename user permission schemes", this.db.getRows("cru_ps_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchPermission("action:1", "user1"), this.matchPermission("action:2", "user1_migration3")}));
    }

    @Test
    public void shouldMigrateCruUserFields() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "user1", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "user2", LegacyAuthType.BUILTIN);
        try (Statement statement = this.connection.createStatement();){
            statement.execute("UPDATE cru_user SET cru_timezone = 'Australia/NSW', cru_failedlogincount = 2, cru_passwordresettimestamp = 15, cru_passwordreset_srnd = 'srnd' WHERE cru_user_id = 1");
        }
        this.doUpgrade();
        MatcherAssert.assertThat((String)"Should move timezone to user profile", this.db.getRows("cru_user_profile"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_user_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_timezone", (Object)"Australia/NSW")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_user_id", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_timezone", null))}));
        MatcherAssert.assertThat((String)"Should keep login properties", this.db.getRows("cru_user"), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_failedlogincount", (Object)2), (Matcher)Matchers.hasEntry((Object)"cru_passwordresettimestamp", (Object)15), (Matcher)Matchers.hasEntry((Object)"cru_passwordreset_srnd", (Object)"srnd"), (Matcher)Matchers.hasEntry((Object)"cru_user_id", (Object)1))));
    }

    @Test
    public void groupMigrationShouldMoveGroupsToInternalDirectory() throws Exception {
        this.preUpgrade();
        this.db.addGroup(1, "team-1");
        this.db.addGroup(2, "team-2");
        this.db.addGroup(3, "team-3");
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup(1, "team-1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(2, "team-2"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(3, "team-3"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(4, "fisheye-users"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(5, "crucible-users")}));
    }

    @Test
    public void groupMigrationShouldNormalizeGroupNames() throws Exception {
        this.preUpgrade();
        this.db.addGroup(1, "TEAM-1");
        this.db.addGroup(2, "Team-2");
        this.systemAdmins.addGroup("TEAM-1");
        this.addGroupPermission("action", "Team-2", 1);
        this.addGroupPermission("action", "team-1", 1);
        try (Statement st = this.connection.createStatement();){
            st.executeUpdate("INSERT INTO cru_proj_allowed_grp (cru_project_id, cru_group_name) VALUES (1, 'TEAM-1')");
            st.executeUpdate("INSERT INTO cru_proj_allowed_grp (cru_project_id, cru_group_name) VALUES (1, 'team-2')");
            st.executeUpdate("INSERT INTO cru_proj_default_grp (cru_project_id, cru_group_name) VALUES (1, 'Team-2')");
            st.executeUpdate("INSERT INTO cru_proj_default_grp (cru_project_id, cru_group_name) VALUES (1, 'team-1')");
        }
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup(1, "TEAM-1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(2, "Team-2"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(3, "fisheye-users"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(4, "crucible-users")}));
        MatcherAssert.assertThat((String)"Should normalize sysadmin groups", (Object)ImmutableList.copyOf((Object[])this.systemAdmins.getGroupArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"team-1"}));
        MatcherAssert.assertThat((String)"Should normalize permissions", this.db.getRows("cru_ps_group"), (Matcher)Matchers.containsInAnyOrder(this.matchPermission("action", "team-2")));
        MatcherAssert.assertThat((String)"Should normalize default reviewers", this.db.getRows("cru_proj_default_grp"), (Matcher)Matchers.containsInAnyOrder((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_project_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_group_name", (Object)"team-2"))));
        MatcherAssert.assertThat((String)"Should normalize allowed reviewers", this.db.getRows("cru_proj_allowed_grp"), (Matcher)Matchers.containsInAnyOrder((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_project_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_group_name", (Object)"team-1"))));
    }

    @Test
    public void groupMigrationShouldRenameDuplicateGroups() throws Exception {
        this.preUpgrade();
        this.db.addGroup(1, "TEAM-1");
        this.db.addGroup(2, "team-1");
        this.db.addGroup(3, "team-1_migration1");
        this.db.addGroup(4, "Team-1");
        this.db.addGroup(5, "TEam-1");
        this.systemAdmins.addGroup("TEAM-1");
        this.systemAdmins.addGroup("team-1_migration1");
        this.addGroupPermission("action1", "Team-1", 1);
        this.addGroupPermission("action2", "TEam-1", 1);
        try (Statement st = this.connection.createStatement();){
            st.executeUpdate("INSERT INTO cru_proj_allowed_grp (cru_project_id, cru_group_name) VALUES (1, 'team-1')");
            st.executeUpdate("INSERT INTO cru_proj_allowed_grp (cru_project_id, cru_group_name) VALUES (1, 'Team-1')");
            st.executeUpdate("INSERT INTO cru_proj_default_grp (cru_project_id, cru_group_name) VALUES (1, 'TEAM-1')");
        }
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup(1, "TEAM-1_migration2"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(2, "team-1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(3, "team-1_migration1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(4, "Team-1_migration3"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(5, "TEam-1_migration4"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(6, "fisheye-users"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(7, "crucible-users")}));
        MatcherAssert.assertThat((String)"Should rename sysadmin groups", (Object)ImmutableList.copyOf((Object[])this.systemAdmins.getGroupArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"team-1_migration1", "team-1_migration2"}));
        MatcherAssert.assertThat((String)"Should rename permissions", this.db.getRows("cru_ps_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchPermission("action1", "team-1_migration3"), this.matchPermission("action2", "team-1_migration4")}));
        MatcherAssert.assertThat((String)"Should rename default reviewers", this.db.getRows("cru_proj_default_grp"), (Matcher)Matchers.containsInAnyOrder((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_project_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_group_name", (Object)"team-1_migration2"))));
        MatcherAssert.assertThat((String)"Should normalize allowed reviewers", this.db.getRows("cru_proj_allowed_grp"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_project_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_group_name", (Object)"team-1")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_project_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"cru_group_name", (Object)"team-1_migration3"))}));
    }

    @Test
    public void userMigrationShouldPreferActiveNormalizedUsers() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "Inactive", LegacyAuthType.BUILTIN, false, true);
        this.db.addLegacyUser(2, "INACTIVE", LegacyAuthType.BUILTIN, false, true);
        this.db.addLegacyUser(3, "inactive", LegacyAuthType.BUILTIN, false, true);
        this.db.addLegacyUser(4, "inactive_migration1", LegacyAuthType.BUILTIN, false, true);
        this.db.addLegacyUser(5, "Active", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(6, "ACTIVE", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(7, "active", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(8, "active_migration1", LegacyAuthType.BUILTIN, true, true);
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdUser(5, "Active_migration2"), EmbeddedCrowdUpgradeTestData.matchCwdUser(6, "ACTIVE_migration3"), EmbeddedCrowdUpgradeTestData.matchCwdUser(7, "active"), EmbeddedCrowdUpgradeTestData.matchCwdUser(8, "active_migration1")}));
        MatcherAssert.assertThat(this.db.getRows("cru_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCruUser(1, "inactive_migration2"), EmbeddedCrowdUpgradeTestData.matchCruUser(2, "inactive_migration3"), EmbeddedCrowdUpgradeTestData.matchCruUser(3, "inactive_migration4"), EmbeddedCrowdUpgradeTestData.matchCruUser(4, "inactive_migration1"), EmbeddedCrowdUpgradeTestData.matchCruUser(5, "active_migration2"), EmbeddedCrowdUpgradeTestData.matchCruUser(6, "active_migration3"), EmbeddedCrowdUpgradeTestData.matchCruUser(7, "active"), EmbeddedCrowdUpgradeTestData.matchCruUser(8, "active_migration1")}));
    }

    @Test
    public void userMigrationShouldPreferActiveUsers() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "user", LegacyAuthType.BUILTIN, false, true);
        this.db.addLegacyUser(2, "USER", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(3, "User", LegacyAuthType.BUILTIN, true, true);
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdUser(2, "USER"), EmbeddedCrowdUpgradeTestData.matchCwdUser(3, "User_migration2")}));
        MatcherAssert.assertThat(this.db.getRows("cru_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCruUser(1, "user_migration1"), EmbeddedCrowdUpgradeTestData.matchCruUser(2, "user"), EmbeddedCrowdUpgradeTestData.matchCruUser(3, "user_migration2")}));
    }

    @Test
    public void groupMigrationShouldPreferNormalizedGroups() throws Exception {
        this.preUpgrade();
        this.db.addGroup(1, "TEAM-1");
        this.db.addGroup(2, "TEAM-2");
        this.db.addGroup(3, "team-2");
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup(1, "TEAM-1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(2, "TEAM-2_migration1"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(3, "team-2"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(4, "fisheye-users"), EmbeddedCrowdUpgradeTestData.matchCwdGroup(5, "crucible-users")}));
    }

    @Test
    public void shouldMigrateMemberships() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "builtin", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "ajp", LegacyAuthType.AJP);
        this.db.addLegacyUser(3, "builtin2", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(4, "host", LegacyAuthType.HOST);
        this.db.addLegacyUser(5, "custom", LegacyAuthType.CUSTOM);
        this.db.addGroup(1, "team-1");
        this.db.addGroup(2, "team-2");
        this.db.addGroup(3, "team-3");
        this.db.addGroup(4, "team-4");
        this.db.addGroupMembership(1, 1);
        this.db.addGroupMembership(3, 1);
        this.db.addGroupMembership(4, 1);
        this.db.addGroupMembership(2, 2);
        this.db.addGroupMembership(3, 2);
        this.db.addGroupMembership(4, 3);
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership(1, "builtin", 1, "team-1", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(3, "builtin2", 1, "team-1", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(4, "host", 1, "team-1", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(2, "ajp", 2, "team-2", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(3, "builtin2", 2, "team-2", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(4, "host", 3, "team-3", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin2", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ajp", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("host", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("custom", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin2", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ajp", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("host", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("custom", "crucible-users", 1)}));
    }

    @Test
    public void shouldMigrateMembershipsWithRenames() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "USER", LegacyAuthType.CUSTOM);
        this.db.addLegacyUser(2, "user", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(3, "User", LegacyAuthType.AJP);
        this.db.addGroup(1, "GROUP");
        this.db.addGroup(2, "Group");
        this.db.addGroup(3, "group");
        this.db.addGroupMembership(1, 1);
        this.db.addGroupMembership(2, 2);
        this.db.addGroupMembership(3, 3);
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership(1, "USER_migration1", 1, "GROUP_migration1", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(2, "user", 2, "Group_migration2", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(3, "User_migration2", 3, "group", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("USER_migration1", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("user", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("User_migration2", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("USER_migration1", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("user", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("User_migration2", "crucible-users", 1)}));
    }

    @Test
    public void shouldAddDefaultGroupsWithPermissions() throws Exception {
        this.preUpgrade();
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1)}));
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true)}));
    }

    @Test
    public void shouldntOverrideExistingGroupsWithDefaultGroups() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "yes", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(2, "no", LegacyAuthType.BUILTIN, true, false);
        this.db.addLegacyUser(3, "maybe", LegacyAuthType.BUILTIN, true, false);
        this.db.addLegacyUser(4, "inactive", LegacyAuthType.BUILTIN, false, false);
        this.db.addGroup(1, "fisheye-users");
        this.db.addGroup(2, "FISHEYE-USERS_MIGRATION1");
        this.db.addGroup(3, "crucible-users");
        this.db.addGroupMembership(1, 1);
        this.db.addGroupMembership(1, 3);
        this.db.addGroupMembership(3, 3);
        this.db.addGroupMembership(4, 3);
        this.doUpgrade();
        String defaultFishEyeGroup = "fisheye-users_migration2";
        String defaultCrucibleGroup = "crucible-users_migration1";
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("FISHEYE-USERS_MIGRATION1", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users_migration2", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users_migration1", 1)}));
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users_migration2", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users_migration1", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership("yes", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("yes", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("maybe", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("yes", "fisheye-users_migration2", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("yes", "crucible-users_migration1", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("no", "fisheye-users_migration2", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("maybe", "fisheye-users_migration2", 1)}));
    }

    @Test
    public void shouldAddLdapUsersToDefaultGroups() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "ldap-cru", LegacyAuthType.LDAP, true, true);
        this.db.addLegacyUser(2, "ldap", LegacyAuthType.LDAP, true, false);
        this.db.addLegacyUser(3, "builtin-cru", LegacyAuthType.AJP, true, true);
        this.db.addLegacyUser(4, "builtin", LegacyAuthType.HOST, true, false);
        this.db.addGroup(1, "alltheusers");
        this.db.addGroupMembership(1, 1);
        this.db.addGroupMembership(2, 1);
        this.db.addGroupMembership(3, 1);
        this.db.addGroupMembership(4, 1);
        int ldapDirId = 2;
        this.security.addNewLdap();
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 2), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 2), EmbeddedCrowdUpgradeTestData.matchCwdGroup("alltheusers", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("alltheusers", 2)}));
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership("ldap-cru", "fisheye-users", 2), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ldap", "fisheye-users", 2), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin-cru", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ldap-cru", "crucible-users", 2), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin-cru", "crucible-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ldap-cru", "alltheusers", 2), EmbeddedCrowdUpgradeTestData.matchGroupMembership("ldap", "alltheusers", 2), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin-cru", "alltheusers", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("builtin", "alltheusers", 1)}));
    }

    @Test
    public void shouldAddCrowdGroupsToPermittedGroups() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "cru", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(2, "fe", LegacyAuthType.BUILTIN, true, false);
        CrowdAuthConfigType crowdConfig = this.security.addNewCrowd();
        crowdConfig.setCrowdProperties("");
        GroupListType crowdGroups = crowdConfig.addNewResyncGroupsList();
        crowdGroups.addNewGroup().setName("atlassian-staff");
        crowdGroups.addNewGroup().setName("atlassian-dev");
        crowdGroups.addNewGroup().setName("atlassian-dev");
        SystemAdmins systemAdmins = this.security.getAdmins().getSystemAdmins();
        systemAdmins.addGroup("admins1");
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("atlassian-staff", true, true), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("atlassian-dev", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership("cru", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("fe", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("cru", "crucible-users", 1)}));
    }

    @Test
    public void shouldAddAdminGroupsToPermittedGroupsIfNoCrowdGroups() throws Exception {
        this.preUpgrade();
        CrowdAuthConfigType crowdConfig = this.security.addNewCrowd();
        crowdConfig.setCrowdProperties("");
        crowdConfig.addNewResyncGroupsList();
        this.systemAdmins.addGroup("ADMINS1");
        this.systemAdmins.addGroup("admins2");
        this.systemAdmins.addGroup("admins2");
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("admins1", true, true), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("admins2", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1)}));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"No groups were selected to synchronise from Crowd.")))));
    }

    @Test
    public void shouldNotFailIfNoResyncGroupsAndNoSystemAdmins() throws Exception {
        this.preUpgrade();
        CrowdAuthConfigType crowdConfig = this.security.addNewCrowd();
        crowdConfig.setCrowdProperties("");
        crowdConfig.addNewResyncGroupsList();
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, false), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1)}));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"No groups were selected to synchronise from Crowd."))), AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("No admin groups are present. Use admin password to log in to the administration panel."))}));
    }

    @Test
    public void testShouldAddCruciblePermissionToAllResyncGroup() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "cru", LegacyAuthType.BUILTIN, true, true);
        this.db.addLegacyUser(2, "fe", LegacyAuthType.BUILTIN, true, false);
        CrowdAuthConfigType crowdConfig = this.security.addNewCrowd();
        crowdConfig.setCrowdProperties("");
        GroupListType crowdGroups = crowdConfig.addNewResyncGroupsList();
        crowdGroups.addNewGroup().setName("fisheye-users");
        crowdGroups.addNewGroup().setName("crucible-users");
        crowdGroups.addNewGroup().setName("crucible-users".toUpperCase());
        this.doUpgrade();
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGlobalPermission("fisheye-users", true, true), EmbeddedCrowdUpgradeTestData.matchGlobalPermission("crucible-users", true, true)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup("fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchCwdGroup("crucible-users", 1)}));
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership("cru", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("fe", "fisheye-users", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership("cru", "crucible-users", 1)}));
    }

    @Test
    public void shouldCleanupConfigXml() throws Exception {
        this.preUpgrade();
        this.security.addNewUsernames().setForceLowercase(true);
        this.doUpgrade();
        MatcherAssert.assertThat((Object)this.security.isSetUsernames(), (Matcher)Matchers.is((Object)false));
    }

    private Matcher<Map<String, Object>> matchPermission(String action, String pid) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_action_name", (Object)action), (Matcher)Matchers.hasEntry((Object)"cru_pid", (Object)pid));
    }

    private void addStar(int id, String type, String key1, String userName) throws SQLException {
        try (PreparedStatement star = this.connection.prepareStatement("INSERT INTO cru_base_star_model (cru_star_id, cru_item_type, cru_string_key1, cru_user_name) VALUES (?, ?, ?, ?)");){
            star.setInt(1, id);
            star.setString(2, type);
            star.setString(3, key1);
            star.setString(4, userName);
            star.execute();
        }
    }

    private void addRecentlyVisited(String userName, String type, String entityId, long lastVisited) throws SQLException {
        try (PreparedStatement recent = this.connection.prepareStatement("INSERT INTO cru_recently_visited (cru_user_name, cru_item_type, cru_entity_id, cru_last_viewed) VALUES (?, ?, ?, ?)");){
            recent.setString(1, userName);
            recent.setString(2, type);
            recent.setString(3, entityId);
            recent.setLong(4, lastVisited);
            recent.execute();
        }
    }

    private void addCommitterMapping(String committer, String repository, String userName) throws SQLException {
        try (PreparedStatement mapping = this.connection.prepareStatement("INSERT INTO cru_committer_user_mapping (cru_committer_name, cru_repository_name, cru_user_name) VALUES (?, ?, ?)");){
            mapping.setString(1, committer);
            mapping.setString(2, repository);
            mapping.setString(3, userName);
            mapping.execute();
        }
    }

    private void addUserPermission(String action, String userName, int permissionSchemeId) throws SQLException {
        this.addPermission("cru_ps_user", action, userName, permissionSchemeId);
    }

    private void addGroupPermission(String action, String groupName, int permissionSchemeId) throws SQLException {
        this.addPermission("cru_ps_group", action, groupName, permissionSchemeId);
    }

    private void addPermission(String table, String action, String pid, int permissionSchemeId) throws SQLException {
        try (PreparedStatement scheme = this.connection.prepareStatement("INSERT INTO " + table + " (cru_action_name, cru_pid, cru_ps) VALUES (?, ?, ?)");){
            scheme.setString(1, action);
            scheme.setString(2, pid);
            scheme.setInt(3, permissionSchemeId);
            scheme.execute();
        }
    }

    private void addLoginCookie(int id, int userId) throws SQLException {
        try (PreparedStatement cookie = this.connection.prepareStatement("INSERT INTO cru_login_cookie (cru_login_cookie_id, cru_user_id) VALUES (?, ?)");){
            cookie.setInt(1, id);
            cookie.setInt(2, userId);
            cookie.execute();
        }
    }

    private void doUpgrade() throws CruDBException {
        this.dbControl.upgrade(93);
    }

    private void verifyCrowdInitialData() throws Exception {
        Map applicationRow = (Map)Iterables.getOnlyElement(this.db.getRows("cwd_application"));
        MatcherAssert.assertThat((Object)applicationRow, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"id", (Object)1), (Matcher)Matchers.hasEntry((Object)"application_name", (Object)"crowd-embedded"), (Matcher)Matchers.hasEntry((Object)"active", (Object)"T"), (Matcher)Matchers.hasEntry((Object)"application_type", (Object)"CROWD"), (Matcher)Matchers.hasEntry((Object)"credential", (Object)PasswordCredential.NONE.getCredential())));
        MatcherAssert.assertThat(this.db.getRows("cwd_application_attribute"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"application_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"attribute_value", (Object)"true"), (Matcher)Matchers.hasEntry((Object)"attribute_name", (Object)"aggregateMemberships")), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"application_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"attribute_value", (Object)"true"), (Matcher)Matchers.hasEntry((Object)"attribute_name", (Object)"atlassian_sha1_applied"))}));
        Map directoryRow = (Map)Iterables.getOnlyElement(this.db.getRows("cwd_directory"));
        MatcherAssert.assertThat((Object)directoryRow, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"id", (Object)1), (Matcher)Matchers.hasEntry((Object)"directory_name", (Object)"Internal Directory"), (Matcher)Matchers.hasEntry((Object)"active", (Object)"T"), (Matcher)Matchers.hasEntry((Object)"impl_class", (Object)"com.atlassian.crowd.directory.InternalDirectory"), (Matcher)Matchers.hasEntry((Object)"directory_type", (Object)"INTERNAL")));
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_attribute"), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"directory_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"attribute_value", (Object)"atlassian-security"), (Matcher)Matchers.hasEntry((Object)"attribute_name", (Object)"user_encryption_method"))));
    }

    private void verifyDefaultGroupsData() throws Exception {
        MatcherAssert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"group_name", (Object)"fisheye-users"), (Matcher)Matchers.hasEntry((Object)"lower_group_name", (Object)"fisheye-users"), (Matcher)Matchers.hasEntry((Object)"active", (Object)"T"), (Matcher)Matchers.hasEntry((Object)"is_local", (Object)"F"), (Matcher)Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), (Matcher)Matchers.hasEntry((Object)"directory_id", (Object)1)), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"group_name", (Object)"crucible-users"), (Matcher)Matchers.hasEntry((Object)"lower_group_name", (Object)"crucible-users"), (Matcher)Matchers.hasEntry((Object)"active", (Object)"T"), (Matcher)Matchers.hasEntry((Object)"is_local", (Object)"F"), (Matcher)Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), (Matcher)Matchers.hasEntry((Object)"directory_id", (Object)1))}));
        MatcherAssert.assertThat(this.db.getRows("cru_global_permission"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_group", (Object)"fisheye-users"), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_fisheye_user"), this.matchesBoolean(true)), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_crucible_user"), this.matchesBoolean(false))), Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_group", (Object)"crucible-users"), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_fisheye_user"), this.matchesBoolean(true)), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_crucible_user"), this.matchesBoolean(true)))}));
    }

    @NotNull
    private AnyOf<Object> matchesBoolean(boolean b) {
        return Matchers.anyOf((Matcher)Matchers.equalTo((Object)b), (Matcher)Matchers.equalTo((Object)(b ? 1 : 0)));
    }
}

