/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtil;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level0-datasource.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class WrongSQLServerColumnTypesUpgradeTaskTest {
    @Autowired
    DataSource dataSource;
    private DefaultDBControl dbControl;

    @Before
    public void setup() throws Exception {
        DatabaseConfig dbConfig = UpgradeTestUtil.createDbConfig(this.dataSource);
        this.dbControl = UpgradeTestUtil.createDbControl(dbConfig, this.dataSource);
        Assume.assumeThat((String)"Skipping MSSQLServer only test", (Object)this.dbControl.getType(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)DBType.SQLSERVER2005), (Matcher)Matchers.equalTo((Object)DBType.SQLSERVER2008), (Matcher)Matchers.equalTo((Object)DBType.SQLSERVER2012)));
    }

    @After
    public void tearDown() throws Exception {
        UpgradeTestUtil.dropTables(this.dataSource);
    }

    @Test
    public void shouldChangeBitsToIntsInGlobalPermissions() throws Exception {
        UpgradeTestUtil.createSchema((DBControl)this.dbControl, 93);
        this.dbControl.upgrade(95);
        Assert.assertThat((Object)this.getColumnType("cru_global_permission", "cru_fisheye_user"), (Matcher)Matchers.equalTo((Object)-6));
        Assert.assertThat((Object)this.getColumnType("cru_global_permission", "cru_crucible_user"), (Matcher)Matchers.equalTo((Object)-6));
        Assert.assertThat(this.getIndexNames("cru_global_permission"), (Matcher)Matchers.hasItems((Object[])new String[]{"cru_idx_perm_fisheye_user", "cru_idx_perm_crucible_user"}));
    }

    private List<String> getIndexNames(String tableName) throws SQLException {
        ImmutableList.Builder indexNames = ImmutableList.builder();
        try (Connection connection = this.dataSource.getConnection();
             ResultSet columns = connection.getMetaData().getIndexInfo(null, null, tableName, false, false);){
            while (columns.next()) {
                String indexName = columns.getString("INDEX_NAME");
                if (indexName == null) continue;
                indexNames.add((Object)indexName);
            }
        }
        return indexNames.build();
    }

    /*
     * Exception decompiling
     */
    private int getColumnType(String tableName, String columnName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

