/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.ProxyDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtils;
import com.cenqua.crucible.hibernate.upgrade.WatchMigrationUpgradeTask;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.util.PropertiesUtil;
import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level1-session.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class WatchMigrationUpgradeTaskTest {
    private Resource data0binResource = new ClassPathResource("/com/cenqua/crucible/hibernate/upgrade/data/data0.bin");
    private Resource data0PropertiesResource = new ClassPathResource("/com/cenqua/crucible/hibernate/upgrade/data/data0.properties");
    private Properties data0Properties;
    private DB0Handle db0Handle;
    @Autowired
    private DataSource dataSource;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        Assert.assertThat((Object)this.dataSource, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.data0binResource.exists(), (Matcher)Matchers.equalTo((Object)true));
        this.db0Handle = new DB0Handle(this.data0binResource.getFile());
        Assert.assertThat((Object)this.db0Handle.isOpen(), (Matcher)Matchers.equalTo((Object)true));
        this.connection = this.dataSource.getConnection();
        this.data0Properties = PropertiesUtil.loadFromFile((File)this.data0PropertiesResource.getFile());
        Assert.assertThat((Object)this.data0Properties.getProperty("watch.all.count"), (Matcher)Matchers.notNullValue());
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.db0Handle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAfterUpgradeScript() throws Exception {
        Map<Integer, String> usernamesById = UpgradeTestUtils.initDBUsers(this.connection, this.data0Properties, "watch.users.csv");
        WatchMigrationUpgradeTask watchMigrationUpgradeTask = new WatchMigrationUpgradeTask((DB0HandleFactory)new ProxyDB0HandleFactory(this.db0Handle));
        watchMigrationUpgradeTask.afterUpgradeScript(this.connection, DBType.HSQL);
        int allWatchesCount = UpgradeTestUtils.getCount(this.connection, "select count(*) from cru_watch");
        int allWatchesCountExpected = this.getExpectedCountFor("all");
        Assert.assertThat((Object)allWatchesCount, (Matcher)Matchers.equalTo((Object)allWatchesCountExpected));
        for (Map.Entry<Integer, String> entry : usernamesById.entrySet()) {
            int userWatchesCount = UpgradeTestUtils.getCount(this.connection, "select count(*) from cru_watch where cru_user_id = " + entry.getKey());
            int userWatchesCountExpected = this.getExpectedCountFor(entry.getValue());
            Assert.assertThat((String)("wrong number of watches for user: " + entry), (Object)userWatchesCount, (Matcher)Matchers.equalTo((Object)userWatchesCountExpected));
        }
    }

    private int getExpectedCountFor(String name) {
        return Integer.parseInt(this.data0Properties.getProperty("watch." + name + ".count"));
    }
}

