/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.atlassian.fecru.user.UserProfile;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTaskTestDbHelper;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUser;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.util.JDBCHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UserMigrationUpgradeTaskTest {
    private final UserMigrationUpgradeTask task = new UserMigrationUpgradeTask(){

        protected DB0Handle getSourceDb() throws IOException {
            return new DB0Handle(UserMigrationUpgradeTaskTest.this.dbFile);
        }
    };
    private File dbFile;
    private UpgradeTaskTestDbHelper sqlDbHelper;
    private Map<FEUser, CrucibleUser> users;

    @Before
    public void setUp() throws Exception {
        this.dbFile = File.createTempFile("usermigration", ".db");
        Assert.assertTrue((boolean)this.dbFile.delete());
        InfinityDbHandle dbHandle = DB0EAV.open((File)this.dbFile);
        dbHandle.close();
        List<FEUser> feUsers = this.getNewFEUsers();
        FEUserEAV userEAV = new FEUserEAV(dbHandle);
        for (FEUser user : feUsers) {
            userEAV.update(user);
            userEAV.setCrucibleEnabled(user.getUsername(), user.isCrucibleEnabled());
        }
        dbHandle.close();
        this.sqlDbHelper = new UpgradeTaskTestDbHelper("usersMigrationTestDB");
        this.createUserTables();
        this.createConstraints();
        CrucibleUser crucibleUser = this.createCrucibleUser(feUsers.get(0));
        this.writeCrucibleUserToDB(crucibleUser, this.sqlDbHelper.getConnection());
        this.writeCrucibleUserProfileToDB(crucibleUser, this.sqlDbHelper.getConnection());
        this.users = this.merge(crucibleUser, feUsers);
    }

    @After
    public void tearDown() throws Exception {
        this.sqlDbHelper.closeQuietly();
        FileUtils.deleteQuietly((File)this.dbFile);
    }

    @Test
    public void testUserMigration() throws Exception {
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        this.assertIdenticalUsersAfterMigration(this.users, this.sqlDbHelper.getConnection());
    }

    private void createUserTables() throws IOException, SQLException {
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/tables_74.sql"), "create table cru_user ", "create table cru_user_profile ");
    }

    private void createConstraints() throws IOException, SQLException {
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/constraints_74.sql"), "alter table cru_user_profile");
    }

    private List<FEUser> getNewFEUsers() {
        FEUser user1 = new FEUser("test1");
        user1.setAuthType(LegacyUser.AuthType.BUILTIN);
        user1.setCrucibleEnabled(true);
        user1.setDisplayName("testdisplay1");
        user1.setEmail("test1@email");
        user1.setFailedLoginAttempts(0L);
        user1.setPasswordHash("31415926535897932384626433832795");
        user1.setPasswordResetSRnd("2.71");
        user1.setPasswordResetTimeStamp(System.currentTimeMillis());
        FEUser user2 = new FEUser("test2");
        user2.setAuthType(LegacyUser.AuthType.CROWD);
        user2.setCrucibleEnabled(false);
        user2.setDisplayName("testdisplay2");
        user2.setEmail("test2@email");
        user2.setFailedLoginAttempts(42L);
        user2.setPasswordHash("2C3C5C7C11C13C17C19C23C29C31C37C");
        user2.setPasswordResetSRnd("41p");
        user2.setPasswordResetTimeStamp(System.currentTimeMillis());
        FEUser userWithDefaults = new FEUser("test-defaults");
        return Arrays.asList(user1, user2, userWithDefaults);
    }

    private CrucibleUser createCrucibleUser(FEUser feUser) throws SQLException {
        CrucibleUser cuser = new CrucibleUser(Integer.valueOf(123), feUser.getUsername());
        cuser.setFEUser(feUser);
        cuser.setDontSendMeMyNotifications(true);
        cuser.setStateChangeEmailNotification(3);
        cuser.setCommentEmailNotification(5);
        cuser.setCompleteEmailNotification(8);
        cuser.setGeneralEmailNotification(13);
        cuser.setReplyEmailNotification(21);
        cuser.setUncompleteOnDefect(true);
        cuser.setUncompleteOnRevisionAdded(true);
        return cuser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCrucibleUserToDB(CrucibleUser user, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("INSERT INTO cru_user (cru_user_id, cru_user_name)  VALUES (?, ?)");
            statement.setInt(1, user.getId());
            statement.setString(2, user.getUsername());
            Assert.assertEquals((int)1, (int)statement.executeUpdate());
        }
        finally {
            JDBCHelper.closeQuietly((Statement)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCrucibleUserProfileToDB(CrucibleUser crucibleUser, Connection connection) throws SQLException {
        UserProfile profile = new UserProfile();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("INSERT INTO cru_user_profile (cru_user_id, cru_tabwidth, cru_cookieprefs, cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, crucibleUser.getId());
            statement.setInt(2, profile.getTabwidth());
            statement.setString(3, profile.getCookiePrefs());
            statement.setInt(4, profile.getWatchMode());
            statement.setInt(5, profile.getEmailFormat());
            statement.setInt(6, profile.getChangesetsPerPage());
            statement.setInt(7, profile.getMaxFilesPerChangeset());
            statement.setInt(8, profile.getIdeConnectorPort());
            statement.setBoolean(9, profile.isEnableIde());
            statement.setInt(10, profile.getContext());
            statement.setString(11, profile.getUploadType());
            statement.setString(12, profile.getUploadMethod());
            statement.setString(13, profile.getUploadCharset());
            statement.setBoolean(14, profile.isAutoMarkFilesRead());
            statement.setBoolean(15, profile.getDontSendMeMyNotifications());
            statement.setInt(16, profile.getStateChangeEmailNotification());
            statement.setInt(17, profile.getCommentEmailNotification());
            statement.setInt(18, profile.getReplyEmailNotification());
            statement.setInt(19, profile.getGeneralEmailNotification());
            statement.setInt(20, profile.getCompleteEmailNotification());
            statement.setInt(21, profile.getAutoUncompleteEmailNotification());
            statement.setBoolean(22, profile.getUncompleteOnDefect());
            statement.setBoolean(23, profile.getUncompleteOnRevisionAdded());
            Assert.assertEquals((int)1, (int)statement.executeUpdate());
        }
        finally {
            JDBCHelper.closeQuietly((Statement)statement);
        }
    }

    private Map<FEUser, CrucibleUser> merge(CrucibleUser crucibleUser, List<FEUser> feUsers) {
        HashMap<FEUser, CrucibleUser> users = new HashMap<FEUser, CrucibleUser>();
        for (FEUser feUser : feUsers) {
            if (feUser.getUsername().equals(crucibleUser.getUsername())) {
                users.put(feUser, crucibleUser);
                continue;
            }
            users.put(feUser, new CrucibleUser(feUser.getUsername()));
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIdenticalUsersAfterMigration(Map<FEUser, CrucibleUser> users, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            for (Map.Entry<FEUser, CrucibleUser> entry : users.entrySet()) {
                FEUser feUser = entry.getKey();
                CrucibleUser cruUser = entry.getValue();
                String username = feUser.getUsername();
                statement = connection.prepareStatement("select * from cru_user where cru_user_name = ?");
                statement.setString(1, username);
                resultSet = statement.executeQuery();
                Assert.assertTrue((String)("no user found for " + username), (boolean)resultSet.next());
                Assert.assertTrue((String)("user " + username + " is not FishEye-enabled"), (boolean)resultSet.getBoolean("cru_fisheye_enabled"));
                Assert.assertEquals((String)("for user " + username), (boolean)feUser.isCrucibleEnabled(), (boolean)resultSet.getBoolean("cru_crucible_enabled"));
                Assert.assertEquals((String)("for user " + username), (int)feUser.getAuthType().getKey(), (int)resultSet.getInt("cru_authtype"));
                Assert.assertEquals((String)("for user " + username), (int)feUser.getAuthType().getKey(), (int)resultSet.getInt("cru_authtype"));
                Assert.assertEquals((String)("for user " + username), (String)feUser.getDisplayName(), (String)resultSet.getString("cru_displayname"));
                Assert.assertEquals((String)("for user " + username), (String)feUser.getEmail(), (String)resultSet.getString("cru_email"));
                Assert.assertEquals((String)("for user " + username), (long)feUser.getFailedLoginAttempts(), (long)resultSet.getLong("cru_failedlogincount"));
                Assert.assertTrue((String)("user " + username + " has no valid ID"), (resultSet.getInt("cru_user_id") > 0 ? 1 : 0) != 0);
                Assert.assertEquals((String)("for user " + username), (String)feUser.getPasswordHash(), (String)resultSet.getString("cru_passwordhash"));
                Assert.assertEquals((String)("for user " + username), (String)feUser.getPasswordResetSRnd(), (String)resultSet.getString("cru_passwordreset_srnd"));
                Assert.assertEquals((String)("for user " + username), (long)feUser.getPasswordResetTimeStamp(), (long)resultSet.getLong("cru_passwordresettimestamp"));
                Assert.assertNull((String)("timezone exists for user " + username), (Object)resultSet.getString("cru_timezone"));
                Assert.assertFalse((String)("more than one user match the username " + username), (boolean)resultSet.next());
            }
        }
        finally {
            JDBCHelper.closeQuietly(resultSet, statement);
        }
    }
}

