/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationSetDefaultsTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class UserMigrationSetDefaultsTaskTest {
    private final Connection connection = (Connection)Mockito.mock(Connection.class);
    private final Pattern expected = Pattern.compile("update ([a-z_]+) set ([a-z_]+) = '?[a-z0-9_-]+'? where ([a-z_]+) is null");
    private final PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
    private final UserMigrationSetDefaultsTask task = new UserMigrationSetDefaultsTask();
    private List<String> statements;

    @Before
    public void setUp() throws Exception {
        this.statements = new LinkedList<String>();
        Mockito.when((Object)this.connection.prepareStatement(Matchers.anyString())).thenAnswer(invocation -> {
            this.statements.add((String)invocation.getArguments()[0]);
            return this.statement;
        });
    }

    @Test
    public void testAfterUpgrade() throws Exception {
        this.task.afterUpgradeScript(this.connection, DBType.HSQL);
        Assert.assertEquals((long)18L, (long)this.statements.size());
        for (String s : this.statements) {
            Matcher matcher = this.expected.matcher(s.trim().toLowerCase());
            if (matcher.matches()) {
                String table = matcher.group(1);
                String nullColumn = matcher.group(3);
                String updatedColumn = matcher.group(2);
                Assert.assertTrue((String)("Unknown table: " + table), (table.equals("cru_user") || table.equals("cru_user_profile") ? 1 : 0) != 0);
                Assert.assertEquals((Object)nullColumn, (Object)updatedColumn);
                continue;
            }
            junit.framework.Assert.fail((String)("Unrecognized statement: " + s));
        }
    }

    @Test
    public void testBooleanKeywordSupport() throws Exception {
        this.task.supportBooleanKeywords = true;
        this.task.afterUpgradeScript(this.connection, DBType.HSQL);
        Assert.assertThat(this.statements, (org.hamcrest.Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"update cru_user set cru_fisheye_enabled = false where cru_fisheye_enabled is null", "update cru_user_profile set cru_enableide = true where cru_enableide is null"}));
        this.statements.clear();
        this.task.supportBooleanKeywords = false;
        this.task.afterUpgradeScript(this.connection, DBType.HSQL);
        Assert.assertThat(this.statements, (org.hamcrest.Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"update cru_user set cru_fisheye_enabled = 0 where cru_fisheye_enabled is null", "update cru_user_profile set cru_enableide = 1 where cru_enableide is null"}));
    }
}

