/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class UpgradeTestUtils {
    public static int getCount(Connection connection, String countSQL) throws SQLException {
        try (Statement statement = connection.createStatement();){
            int result;
            ResultSet resultSet = statement.executeQuery(countSQL);
            resultSet.next();
            int n = result = resultSet.getInt(1);
            return n;
        }
    }

    public static Map<Integer, String> initDBUsers(Connection connection, Properties properties, String usersCsvPropertyName) throws SQLException {
        HashMap usernamesById = Maps.newHashMap();
        Iterable usernames = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)properties.getProperty(usersCsvPropertyName));
        int i = 0;
        for (String username : usernames) {
            UpgradeTestUtils.addUserToDB(connection, i, username);
            usernamesById.put(i, username);
            ++i;
        }
        return usernamesById;
    }

    private static boolean addUserToDB(Connection connection, int userId, String userName) throws SQLException {
        String insertUser = "insert into cru_user (cru_user_id, cru_user_name) values (?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into cru_user (cru_user_id, cru_user_name) values (?,?)");){
            preparedStatement.setInt(1, userId);
            preparedStatement.setString(2, userName);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }
}

