/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.atlassian.crucible.migration.item.SQLBackup;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlConnectionProvider;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.dbutils.comparison.DbComparator;
import com.cenqua.fisheye.AppConfig;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class UpgradeTestUtil {
    public static Map<String, TableData> collectTableData(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            Map<String, TableData> map = DbComparator.getTables(connection, true).stream().map(tableName -> {
                try {
                    return new TableData((String)tableName, connection);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toMap(tableData -> tableData.tableName, Function.identity()));
            return map;
        }
    }

    public static void assertTableDataMatches(Map<String, TableData> newlyCreated, Map<String, TableData> afterUpgrade, DBType dbType) {
        Assert.assertThat(newlyCreated.keySet(), (Matcher)Matchers.equalTo(afterUpgrade.keySet()));
        newlyCreated.keySet().forEach(tableName -> {
            try {
                boolean columnsMatch = DbComparator.compareColumnMetaData(((TableData)newlyCreated.get((Object)tableName)).columns, ((TableData)afterUpgrade.get((Object)tableName)).columns, tableName, false);
                boolean indexesMatch = DbComparator.compareIndexMetaData(((TableData)newlyCreated.get((Object)tableName)).indexes, ((TableData)afterUpgrade.get((Object)tableName)).indexes, dbType, dbType, tableName);
                boolean primaryKeysMatch = DbComparator.compareResultSets(((TableData)newlyCreated.get((Object)tableName)).primaryKeys, ((TableData)afterUpgrade.get((Object)tableName)).primaryKeys, tableName, "Primary key in ");
                boolean exportedKeysMatch = DbComparator.compareResultSets(((TableData)newlyCreated.get((Object)tableName)).exportedKeys, ((TableData)afterUpgrade.get((Object)tableName)).exportedKeys, tableName, "Exported key in ");
                boolean importedKeysMatch = DbComparator.compareResultSets(((TableData)newlyCreated.get((Object)tableName)).importedKeys, ((TableData)afterUpgrade.get((Object)tableName)).importedKeys, tableName, "Imported key in ");
                Assert.assertTrue((boolean)columnsMatch);
                Assert.assertTrue((boolean)indexesMatch);
                Assert.assertTrue((boolean)primaryKeysMatch);
                Assert.assertTrue((boolean)exportedKeysMatch);
                Assert.assertTrue((boolean)importedKeysMatch);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    public static DefaultDBControl createDbControl(DatabaseConfig dbConfig, final DataSource dataSource) throws Exception {
        UpgradeTestUtil.dropTables(dataSource);
        DefaultDBControl control = DefaultDBControl.newInstance((DatabaseConfig)dbConfig, (DBControlConnectionProvider)new DBControlConnectionProvider(){

            public Connection getConnection() throws SQLException, ClassNotFoundException {
                return dataSource.getConnection();
            }

            public Connection getMaintenanceConnection() throws SQLException, ClassNotFoundException {
                return dataSource.getConnection();
            }

            public void shutdown() {
            }
        }, (File)new File(AppConfig.getAppHome(), "etc/dist/sql"));
        return control;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dropTables(DataSource dataSource) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            int retries = 20;
            do {
                int tablesLeft = 0;
                try (ResultSet tables = connection.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});){
                    try (Statement st = connection.createStatement();){
                        while (tables.next()) {
                            try {
                                String tableName = tables.getString("TABLE_NAME").toLowerCase(Locale.US);
                                if (!SQLBackup.HAS_FECRU_TABLE_PREFIX.test(tableName)) continue;
                                try {
                                    st.execute("DROP TABLE " + tableName);
                                }
                                catch (Exception e) {
                                    String owner = tables.getString("TABLE_SCHEM").toLowerCase(Locale.US);
                                    st.execute("DROP TABLE " + owner + "." + tableName);
                                }
                            }
                            catch (Exception ignored) {
                                ++tablesLeft;
                            }
                        }
                    }
                    if (tablesLeft == 0) {
                        return;
                    }
                }
            } while (--retries > 0);
            return;
        }
    }

    public static DatabaseConfig createDbConfig(DataSource dataSource) throws SQLException, ClassNotFoundException {
        DatabaseConfig dbConfig = (DatabaseConfig)Mockito.mock(DatabaseConfig.class);
        Mockito.when((Object)dbConfig.getType()).thenReturn((Object)UpgradeTestUtil.determineDbType(dataSource));
        Mockito.when((Object)dbConfig.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)dbConfig.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)dbConfig.getMaxPoolSize()).thenReturn((Object)10);
        Mockito.when((Object)dbConfig.getParams()).thenReturn((Object)"");
        return dbConfig;
    }

    public static void createSchema(DBControl dbControl, int version) throws CruDBException {
        dbControl.createTables(version);
        dbControl.addConstraints(version);
        dbControl.addInitData(version);
    }

    private static DBType determineDbType(DataSource dataSource) throws SQLException, ClassNotFoundException {
        try (Connection connection = dataSource.getConnection();){
            DBType dBType = DBType.fromMetadata((DatabaseMetaData)connection.getMetaData());
            return dBType;
        }
    }

    public static class TableData {
        final String tableName;
        final RowSetFactory rowsetFactory = RowSetProvider.newFactory();
        final CachedRowSet columns = this.rowsetFactory.createCachedRowSet();
        final CachedRowSet indexes = this.rowsetFactory.createCachedRowSet();
        final CachedRowSet primaryKeys = this.rowsetFactory.createCachedRowSet();
        final CachedRowSet exportedKeys = this.rowsetFactory.createCachedRowSet();
        final CachedRowSet importedKeys = this.rowsetFactory.createCachedRowSet();

        TableData(String tableName, Connection connection) throws SQLException {
            this.tableName = tableName;
            DatabaseMetaData metaData = connection.getMetaData();
            this.populateCachedRowSet(this.columns, metaData.getColumns(null, null, tableName, "%"));
            this.populateCachedRowSet(this.indexes, metaData.getIndexInfo(null, null, tableName, false, false));
            this.populateCachedRowSet(this.primaryKeys, metaData.getPrimaryKeys(null, null, tableName));
            this.populateCachedRowSet(this.exportedKeys, metaData.getExportedKeys(null, null, tableName));
            this.populateCachedRowSet(this.importedKeys, metaData.getImportedKeys(null, null, tableName));
        }

        private void populateCachedRowSet(CachedRowSet output, ResultSet resultSet) throws SQLException {
            output.populate(resultSet);
            resultSet.close();
        }
    }
}

