/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.fisheye.util.JDBCHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class UpgradeTaskTestDbHelper {
    private final Connection connection;

    UpgradeTaskTestDbHelper(String dbName) throws ClassNotFoundException, SQLException {
        Class.forName("org.hsqldb.jdbcDriver");
        this.connection = DriverManager.getConnection("jdbc:hsqldb:mem:" + dbName + ";shutdown=true", "sa", "");
    }

    Connection getConnection() {
        return this.connection;
    }

    void runScripts(File scriptFile, String ... linesToRun) throws IOException, SQLException {
        LineIterator iterator = FileUtils.lineIterator((File)scriptFile);
        while (iterator.hasNext()) {
            String line = iterator.nextLine();
            if (!this.lineMatches(line, linesToRun)) continue;
            this.connection.prepareStatement(line).execute();
        }
        iterator.close();
    }

    private boolean lineMatches(String line, String[] linesToRun) {
        if (linesToRun.length == 0) {
            return true;
        }
        for (String lineToRun : linesToRun) {
            if (!line.contains(lineToRun)) continue;
            return true;
        }
        return false;
    }

    void closeQuietly() {
        JDBCHelper.closeQuietly((Connection)this.getConnection());
    }
}

