/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.StoredPathHashingTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTaskTestDbHelper;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StoredPathHashingTaskTest {
    public static final String SOME_PATH = "/some/path";
    public static final String AND_SOME_OTHER_PATH = "/and/some/other/path";
    public static final String AND_SOME_ANOTHER_PATH = "/and/some/another/path";
    private UpgradeTaskTestDbHelper sqlDbHelper;
    private long cruStoredPathSeq;
    private StoredPathHashingTask task;

    @Before
    public void setUp() throws Exception {
        this.sqlDbHelper = new UpgradeTaskTestDbHelper("usersMigrationTestDB");
        this.createCruStoredPathTableWithConstraints();
        this.cruStoredPathSeq = 1L;
        this.task = new StoredPathHashingTask();
    }

    @After
    public void tearDown() throws Exception {
        this.sqlDbHelper.closeQuietly();
    }

    private void createCruStoredPathTableWithConstraints() throws IOException, SQLException {
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/tables_81.sql"), "create table cru_stored_path", "create table cru_version", "create table cru_review");
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/constraints_81.sql"), "on cru_stored_path");
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/upgrade/upgrade_81.sql"), new String[0]);
        this.insertPath(SOME_PATH);
        this.insertPath(AND_SOME_OTHER_PATH);
        this.insertPath(AND_SOME_ANOTHER_PATH);
    }

    private void insertPath(String path) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_stored_path(cru_path_id, cru_path) VALUES (?, ?)");
            statement.setLong(1, this.cruStoredPathSeq++);
            statement.setString(2, path);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
    }

    @Test
    public void testAfterUpgrade() throws Exception {
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        Set<StoredPath> storedPaths = this.selectAllCruStoredPath();
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasSize((int)3));
        Matcher itemMatcher = Matchers.equalTo((Object)this.makeStoredPath(SOME_PATH));
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasItem((Matcher)itemMatcher));
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.makeStoredPath(SOME_PATH))));
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.makeStoredPath(AND_SOME_OTHER_PATH))));
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)this.makeStoredPath(AND_SOME_ANOTHER_PATH))));
    }

    @Test(expected=RuntimeException.class)
    public void testAfterUpgradeGotHashCollision() throws Exception {
        this.task = new StoredPathHashingTask(){

            String calculateHash(String path) {
                return super.calculateHash(path.substring(0, 4));
            }
        };
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        Assert.fail((String)"Expected error on hash collision!");
    }

    private StoredPath makeStoredPath(String path) {
        return new StoredPath(path, HashUtils.getDefaultDigestHexEncoded((String)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<StoredPath> selectAllCruStoredPath() throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        HashSet allRows = Sets.newHashSet();
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("SELECT cru_path, cru_hash FROM cru_stored_path");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String path = resultSet.getString(1);
                String hash = resultSet.getString(2);
                Assert.assertThat((String)"expecting unique rows only", (Object)allRows.add(new StoredPath(path, hash)), (Matcher)Is.is((Object)Boolean.TRUE));
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((ResultSet)resultSet, (Statement)statement);
        return allRows;
    }

    static class StoredPath {
        private final String path;
        private final String hash;

        StoredPath(String path, String hash) {
            this.path = path;
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredPath storedPath = (StoredPath)o;
            return Objects.equal((Object)this.path, (Object)storedPath.path) && Objects.equal((Object)this.hash, (Object)storedPath.hash);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.path, this.hash});
        }

        public String toString() {
            return "StoredPath{path='" + this.path + '\'' + ", hash='" + this.hash + '\'' + '}';
        }
    }
}

