/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.hibernate.upgrade.ProjectKeyUpperCaseUpgradeTask;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level1-session.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ProjectKeyUpperCaseUpgradeTaskTest {
    @Autowired
    private DataSource dataSource;
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = this.dataSource.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
    }

    private void initTestScenario1() throws SQLException {
        ProjectKeyUpperCaseUpgradeTaskTest.addPermissionSchemeToDB(this.connection, 0, "PermissionScheme0");
        ProjectKeyUpperCaseUpgradeTaskTest.addPermissionSchemeToDB(this.connection, 1, "PermissionScheme1");
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 1, "ProjA", "project ProjA", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 2, "ProjB", "project ProjB", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 3, "PROJA", "project PROJA", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 4, "projA", "project projA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 5, "PROJC", "project PROJC", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "projA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjB", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 2);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 3);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJB", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJC", 1);
    }

    @Test
    public void testAfterUpgradeScriptTestScenario1() throws Exception {
        this.initTestScenario1();
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"ProjA"), (Matcher)Matchers.hasEntry((Object)2, (Object)"ProjB"), (Matcher)Matchers.hasEntry((Object)3, (Object)"PROJA"), (Matcher)Matchers.hasEntry((Object)4, (Object)"projA"), (Matcher)Matchers.hasEntry((Object)5, (Object)"PROJC")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PROJA-1", "projA-1", "ProjB-1", "PROJA-2", "PROJA-3", "ProjA-1", "PROJB-1", "PROJC-1"}));
        new ProjectKeyUpperCaseUpgradeTask().afterUpgradeScript(this.connection, null);
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"PROJAUPGRADE1"), (Matcher)Matchers.hasEntry((Object)2, (Object)"PROJB"), (Matcher)Matchers.hasEntry((Object)3, (Object)"PROJA"), (Matcher)Matchers.hasEntry((Object)4, (Object)"PROJAUPGRADE2"), (Matcher)Matchers.hasEntry((Object)5, (Object)"PROJC")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PROJA-1", "PROJAUPGRADE2-1", "PROJB-1", "PROJA-2", "PROJA-3", "PROJAUPGRADE1-1", "PROJBUPGRADE3-1", "PROJC-1"}));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)CoreMatchers.allOf((Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Project key: ProjA will be renamed to: PROJAUPGRADE1")), (Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Project key: projA will be renamed to: PROJAUPGRADE2")), (Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Summary for project keys changed for cru_project: ProjA=PROJAUPGRADE1,ProjB=PROJB,projA=PROJAUPGRADE2"))));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)CoreMatchers.allOf((Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Project key: PROJB will be renamed to: PROJBUPGRADE3")), (Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Summary for project keys changed for cru_revpermaid: ProjA=PROJAUPGRADE1,PROJB=PROJBUPGRADE3,ProjB=PROJB,projA=PROJAUPGRADE2"))));
    }

    private void initTestScenario2() throws SQLException {
        ProjectKeyUpperCaseUpgradeTaskTest.addPermissionSchemeToDB(this.connection, 0, "PermissionScheme0");
        ProjectKeyUpperCaseUpgradeTaskTest.addPermissionSchemeToDB(this.connection, 1, "PermissionScheme1");
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 1, "ProjA", "project ProjA", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 2, "PROJA", "project ProjB", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 3, "ProjAUPGRADE1", "project ProjAUPGRADE1", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjA", 2);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 2);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjAUPGRADE1", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProjAUPGRADE1", 2);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProJA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "ProJA", 2);
    }

    @Test
    public void testAfterUpgradeScriptTestScenario2() throws Exception {
        this.initTestScenario2();
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"ProjA"), (Matcher)Matchers.hasEntry((Object)2, (Object)"PROJA"), (Matcher)Matchers.hasEntry((Object)3, (Object)"ProjAUPGRADE1")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"ProjA-1", "ProjA-2", "PROJA-1", "PROJA-2", "ProjAUPGRADE1-1", "ProjAUPGRADE1-2", "ProJA-1", "ProJA-2"}));
        new ProjectKeyUpperCaseUpgradeTask().afterUpgradeScript(this.connection, null);
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"PROJAUPGRADE2"), (Matcher)Matchers.hasEntry((Object)2, (Object)"PROJA"), (Matcher)Matchers.hasEntry((Object)3, (Object)"PROJAUPGRADE1")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PROJAUPGRADE2-1", "PROJAUPGRADE2-2", "PROJA-1", "PROJA-2", "PROJAUPGRADE1-1", "PROJAUPGRADE1-2", "PROJAUPGRADE3-1", "PROJAUPGRADE3-2"}));
    }

    private void initTestScenario3() throws SQLException {
        ProjectKeyUpperCaseUpgradeTaskTest.addPermissionSchemeToDB(this.connection, 0, "PermissionScheme0");
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 1, "projA", "project projA", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addProjectToDB(this.connection, 2, "projB", "project projB", 0);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "projA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "projB", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJA", 1);
        ProjectKeyUpperCaseUpgradeTaskTest.addReviewPermaidToDB(this.connection, "PROJB", 1);
    }

    @Test
    public void testAfterUpgradeScriptTestScenario3() throws Exception {
        this.initTestScenario3();
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"projA"), (Matcher)Matchers.hasEntry((Object)2, (Object)"projB")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"projA-1", "projB-1", "PROJA-1", "PROJB-1"}));
        new ProjectKeyUpperCaseUpgradeTask().afterUpgradeScript(this.connection, null);
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listProjectsKeysById(this.connection), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)"PROJA"), (Matcher)Matchers.hasEntry((Object)2, (Object)"PROJB")));
        MatcherAssert.assertThat(ProjectKeyUpperCaseUpgradeTaskTest.listPermaIds(this.connection), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PROJA-1", "PROJB-1", "PROJAUPGRADE1-1", "PROJBUPGRADE2-1"}));
    }

    private void initTestScenario1WithRecentlyVisited(String ... users) throws SQLException {
        this.initTestScenario1();
        for (String user : users) {
            this.initRecentlyVisitedHistoryForUser(user);
        }
    }

    private void initRecentlyVisitedHistoryForUser(String user) throws SQLException {
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.USER, "user1", 0L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.USER, "user2", 1L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.USER, "user3", 2L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "PROJA", 0L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "projA", 1L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "ProjB", 2L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "ProjA", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "PROJB", 4L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.PROJECT, "PROJC", 5L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "PROJA-1", 0L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "projA-1", 1L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "ProjB-1", 2L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "PROJA-2", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "PROJA-3", 4L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "ProjA-1", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "PROJB-1", 4L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REVIEW, "PROJC-1", 5L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "PROJA-1", 0L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "projA-1", 1L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "ProjB-1", 2L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "PROJA-2", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "PROJA-3", 4L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "ProjA-1", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "PROJB-1", 4L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.SNIPPET, "PROJC-1", 5L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REPOSITORY, "repo1", 0L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REPOSITORY, "repo2", 1L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REPOSITORY, "repo3", 2L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REPOSITORY, "repo4", 3L);
        ProjectKeyUpperCaseUpgradeTaskTest.addRecentlyVisitedToDB(this.connection, user, RecentlyVisitedItem.Type.REPOSITORY, "repo5", 4L);
    }

    @Test
    public void testRecentlyVisitedProjectsReviewsAndSnippetsDeleted() throws Exception {
        String[] usersWithRecentlyVisited = new String[]{"user1", "user2", "user3"};
        int noUsers = usersWithRecentlyVisited.length;
        this.initTestScenario1WithRecentlyVisited(usersWithRecentlyVisited);
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 30)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "user%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJA%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 7)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "projA%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "ProjB%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "ProjA%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJB%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJC%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "repo%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 5)));
        new ProjectKeyUpperCaseUpgradeTask().afterUpgradeScript(this.connection, null);
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 18)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "user%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJA%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 7)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "projA%"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "ProjB%"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "ProjA%"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJB%"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "PROJC%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 3)));
        MatcherAssert.assertThat((Object)ProjectKeyUpperCaseUpgradeTaskTest.countRecentlyVisitedWitEntityIdLike(this.connection, "repo%"), (Matcher)CoreMatchers.equalTo((Object)(noUsers * 5)));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)IsCollectionContaining.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage("[projectKey.uppercase] Number of deleted projects, reviews and snippets from cru_recently_visited : " + noUsers * 12)));
    }

    private static boolean addProjectToDB(Connection connection, int projectId, String projectKey, String projectName, int permissionSchemeId) throws SQLException {
        String insertProject = "insert into cru_project (cru_project_id, cru_name, cru_proj_key, cru_permission_scheme, cru_disable_moderator) values (?,?,?,?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into cru_project (cru_project_id, cru_name, cru_proj_key, cru_permission_scheme, cru_disable_moderator) values (?,?,?,?,?)");){
            preparedStatement.setInt(1, projectId);
            preparedStatement.setString(2, projectName);
            preparedStatement.setString(3, projectKey);
            preparedStatement.setInt(4, permissionSchemeId);
            preparedStatement.setBoolean(5, true);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }

    private static boolean addPermissionSchemeToDB(Connection connection, int permissionSchemeId, String permissionSchemeName) throws SQLException {
        String insertPermissionScheme = "insert into cru_perm_scheme (cru_ps_id, cru_name) values (?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into cru_perm_scheme (cru_ps_id, cru_name) values (?,?)");){
            preparedStatement.setInt(1, permissionSchemeId);
            preparedStatement.setString(2, permissionSchemeName);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }

    private static boolean addReviewPermaidToDB(Connection connection, String projectKey, int number) throws SQLException {
        String insertReviewPermaid = "insert into cru_revpermaid (cru_proj_key, cru_number) values (?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into cru_revpermaid (cru_proj_key, cru_number) values (?,?)");){
            preparedStatement.setString(1, projectKey);
            preparedStatement.setInt(2, number);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }

    private static Map<Integer, String> listProjectsKeysById(Connection connection) throws SQLException {
        HashMap projectKeys = Maps.newHashMap();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT cru_project_id, cru_proj_key FROM cru_project");
            while (resultSet.next()) {
                int projectId = resultSet.getInt(1);
                String projectKey = resultSet.getString(2);
                projectKeys.put(projectId, projectKey);
            }
        }
        return projectKeys;
    }

    private static Set<String> listPermaIds(Connection connection) throws SQLException {
        HashSet permaIds = Sets.newHashSet();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT cru_proj_key, cru_number FROM cru_revpermaid");
            while (resultSet.next()) {
                String projectKey = resultSet.getString(1);
                int number = resultSet.getInt(2);
                permaIds.add(projectKey + "-" + number);
            }
        }
        return permaIds;
    }

    private static boolean addRecentlyVisitedToDB(Connection connection, String userName, RecentlyVisitedItem.Type itemType, String entityId, long lastViewed) throws SQLException {
        String insertRecentlyVisited = "insert into cru_recently_visited (cru_user_name, cru_item_type, cru_entity_id, cru_last_viewed) values (?,?,?,?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into cru_recently_visited (cru_user_name, cru_item_type, cru_entity_id, cru_last_viewed) values (?,?,?,?)");){
            preparedStatement.setString(1, userName);
            preparedStatement.setString(2, itemType.getType());
            preparedStatement.setString(3, entityId);
            preparedStatement.setLong(4, lastViewed);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }

    private static int countRecentlyVisitedWitEntityIdLike(Connection connection, String entityIdLike) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT count(*) FROM cru_recently_visited WHERE cru_entity_id like ?");){
            preparedStatement.setString(1, entityIdLike);
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
    }
}

