/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtil;
import com.cenqua.crucible.hibernate.upgrade.UserMigrationDefaults;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level0-datasource.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class MissingUserProfilesUpgradeTaskTest {
    @Autowired
    DataSource dataSource;
    private DefaultDBControl dbControl;

    @Before
    public void setup() throws Exception {
        DatabaseConfig dbConfig = UpgradeTestUtil.createDbConfig(this.dataSource);
        this.dbControl = UpgradeTestUtil.createDbControl(dbConfig, this.dataSource);
    }

    @After
    public void tearDown() throws Exception {
        UpgradeTestUtil.dropTables(this.dataSource);
    }

    @Test
    public void shouldCreateMissingUserProfiles() throws Exception {
        UpgradeTestUtil.createSchema((DBControl)this.dbControl, 93);
        int contextSizeForUser2 = 100;
        int contextSizeForUser4 = 999;
        try (Connection connection = this.dataSource.getConnection();
             Statement st = connection.createStatement();){
            st.executeUpdate("INSERT INTO cru_user (cru_user_id, cru_user_name) VALUES (1, 'without_profile')");
            st.executeUpdate("INSERT INTO cru_user (cru_user_id, cru_user_name) VALUES (2, 'with_profile')");
            st.executeUpdate("INSERT INTO cru_user (cru_user_id, cru_user_name) VALUES (3, 'still_without_profile')");
            st.executeUpdate("INSERT INTO cru_user (cru_user_id, cru_user_name) VALUES (4, 'another_with_profile')");
            this.addUserProfile(connection, 2, 100);
            this.addUserProfile(connection, 4, 999);
        }
        this.dbControl.upgrade(94);
        this.assertUserProfile(1, 3);
        this.assertUserProfile(2, 100);
        this.assertUserProfile(3, 3);
        this.assertUserProfile(4, 999);
    }

    private void addUserProfile(Connection connection, int userId, int customContextSize) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO cru_user_profile (cru_user_id, cru_tabwidth, cru_cookieprefs, cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            statement.setInt(1, userId);
            statement.setInt(2, 8);
            statement.setString(3, "");
            statement.setInt(4, 0);
            statement.setInt(5, 1);
            statement.setInt(6, 30);
            statement.setInt(7, 5);
            statement.setInt(8, 51235);
            statement.setBoolean(9, true);
            statement.setInt(10, customContextSize);
            statement.setString(11, "patch");
            statement.setString(12, "file");
            statement.setString(13, UserMigrationDefaults.uploadCharset);
            statement.setBoolean(14, true);
            statement.setBoolean(15, true);
            statement.setInt(16, 1);
            statement.setInt(17, 1);
            statement.setInt(18, 1);
            statement.setInt(19, 1);
            statement.setInt(20, 1);
            statement.setInt(21, 2);
            statement.setBoolean(22, true);
            statement.setBoolean(23, true);
            statement.executeUpdate();
        }
    }

    private void assertUserProfile(int userId, int expectedContextSize) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement st = connection.prepareStatement("SELECT cru_user_id, cru_tabwidth, cru_cookieprefs, cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added FROM cru_user_profile WHERE cru_user_id = ?");){
            st.setInt(1, userId);
            ResultSet resultSet = st.executeQuery();
            Assert.assertTrue((String)("Didn't find expected user profile for userid = " + userId), (boolean)resultSet.next());
            Assert.assertThat((Object)resultSet.getInt("cru_user_id"), (Matcher)Matchers.equalTo((Object)userId));
            Assert.assertThat((Object)resultSet.getInt("cru_tabwidth"), (Matcher)Matchers.equalTo((Object)8));
            Assert.assertThat((Object)Strings.nullToEmpty((String)resultSet.getString("cru_cookieprefs")), (Matcher)Matchers.equalTo((Object)""));
            Assert.assertThat((Object)resultSet.getInt("cru_watchmode"), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)resultSet.getInt("cru_emailformat"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_changesetsperpage"), (Matcher)Matchers.equalTo((Object)30));
            Assert.assertThat((Object)resultSet.getInt("cru_maxfilesperchangeset"), (Matcher)Matchers.equalTo((Object)5));
            Assert.assertThat((Object)resultSet.getInt("cru_ideconnectorport"), (Matcher)Matchers.equalTo((Object)51235));
            Assert.assertThat((Object)resultSet.getBoolean("cru_enableide"), (Matcher)Matchers.equalTo((Object)true));
            Assert.assertThat((Object)resultSet.getInt("cru_context"), (Matcher)Matchers.equalTo((Object)expectedContextSize));
            Assert.assertThat((Object)resultSet.getString("cru_upload_type"), (Matcher)Matchers.equalTo((Object)"patch"));
            Assert.assertThat((Object)resultSet.getString("cru_upload_method"), (Matcher)Matchers.equalTo((Object)"file"));
            Assert.assertThat((Object)resultSet.getString("cru_upload_charset"), (Matcher)Matchers.equalTo((Object)UserMigrationDefaults.uploadCharset));
            Assert.assertThat((Object)resultSet.getBoolean("cru_auto_mark_files"), (Matcher)Matchers.equalTo((Object)true));
            Assert.assertThat((Object)resultSet.getBoolean("cru_dont_send_me_my_notes"), (Matcher)Matchers.equalTo((Object)true));
            Assert.assertThat((Object)resultSet.getInt("cru_state_change_email_note"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_comment_email_note"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_reply_email_note"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_general_email_note"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_complete_email_note"), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)resultSet.getInt("cru_uncomplete_email_note"), (Matcher)Matchers.equalTo((Object)2));
            Assert.assertThat((Object)resultSet.getBoolean("cru_uncomplete_on_defect"), (Matcher)Matchers.equalTo((Object)true));
            Assert.assertThat((Object)resultSet.getBoolean("cru_uncomplete_on_rev_added"), (Matcher)Matchers.equalTo((Object)true));
        }
    }
}

