/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.upgrade.LogTableUpgrader51;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.fisheye.rep.DbException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class LogTableUpgrader51Test {
    private LogTableUpgrader51 upgrader;
    private Map<String, Integer> userNames = new HashMap<String, Integer>();
    private Map<String, Integer> displayNames = new HashMap<String, Integer>();
    private Map<String, Integer> reviewKeys = new HashMap<String, Integer>();

    @Before
    public void setUp() throws SQLException, DbException {
        this.reviewKeys.put("CR-FE-6", 1);
        this.reviewKeys.put("CR-FE-2377", 2);
        this.reviewKeys.put("CR-CLOV-114", 3);
        this.reviewKeys.put("CR-FE-1401", 4);
        this.reviewKeys.put("CR-FE-1472", 5);
        this.reviewKeys.put("CR-FE-2283", 6);
        this.reviewKeys.put("CR-FE-2355", 7);
        this.reviewKeys.put("CR-FE-2373", 8);
        this.reviewKeys.put("CR-FE-2374", 9);
        this.reviewKeys.put("CR-FE-2378", 10);
        this.reviewKeys.put("CR-FE-2395", 11);
        this.reviewKeys.put("CR-FE-2412", 12);
        this.reviewKeys.put("CR-145", 13);
        this.reviewKeys.put("CR-FE-1412", 14);
        this.reviewKeys.put("CR-FE-1579", 15);
        this.reviewKeys.put("CR-FE-1597", 16);
        this.reviewKeys.put("CR-FE-2261", 17);
        this.reviewKeys.put("CR-FE-2357", 18);
        this.reviewKeys.put("CR-FE-2369", 19);
        this.reviewKeys.put("CR-FE-2438", 21);
        this.reviewKeys.put("CR-FE-265", 22);
        this.reviewKeys.put("CR-FE-661", 23);
        this.reviewKeys.put("CR-FE-779", 24);
        this.reviewKeys.put("POTATO-12", 25);
        this.reviewKeys.put("CR-FE-2390", 26);
        this.reviewKeys.put("CR-FE-2420", 27);
        this.reviewKeys.put("CR-FE-316", 28);
        this.displayNames.put("Pawel Niewiadomski", 101);
        this.displayNames.put("Geoff Crain", 102);
        this.displayNames.put("Conor MacNeill", 103);
        this.displayNames.put("Erik van Zijst", 104);
        this.displayNames.put("Joe Xie'", 105);
        this.displayNames.put("Matt Quail", 106);
        this.displayNames.put("Seb Ruiz", 108);
        this.displayNames.put("Tim Pettersen", 109);
        this.userNames.put("ahempel", 201);
        this.userNames.put("alyons", 202);
        this.userNames.put("cmacneill", 203);
        this.userNames.put("evzijst", 204);
        this.userNames.put("jxie", 205);
        this.userNames.put("mquail", 206);
        this.userNames.put("mstudman", 207);
        this.userNames.put("sruiz", 208);
        this.upgrader = new LogTableUpgrader51(this.userNames, this.displayNames, this.reviewKeys);
    }

    @After
    public void tearDown() {
        if (!this.upgrader.getUnknownDisplayNames().isEmpty()) {
            System.out.println("Unknown display names: " + this.upgrader.getUnknownDisplayNames());
        }
        if (!this.upgrader.getUnknownUserNames().isEmpty()) {
            System.out.println("Unknown user names: " + this.upgrader.getUnknownUserNames());
        }
        if (!this.upgrader.getUnknownReviewKeys().isEmpty()) {
            System.out.println("Unknown review keys: " + this.upgrader.getUnknownReviewKeys());
        }
    }

    @Test
    public void testReviewCreatedParser() throws SQLException {
        this.verifyParse("Review: 188 CR-FE-121: Rework created.", 188, null, LogAction.REVIEW_REWORK_CREATED);
        this.verifyParse("Review: 3  created.", 3, null, LogAction.REVIEW_CREATED);
        this.verifyParse("Review: 3070  created.", 3070, null, LogAction.REVIEW_CREATED);
        this.verifyParse("Review: 317 This is a pre-commit demo review created.", 317, null, LogAction.REVIEW_CREATED);
        this.verifyParse("Review: 2997 CRUC-2085 - FE PERF - Improve performance of UserListAction by caching committer to user mappings. created.", 2997, null, LogAction.REVIEW_CREATED);
    }

    @Test
    public void testReviewCompleted() throws SQLException {
        this.verifyParse("CR-1: Michael Studman completed review.", null, null, LogAction.REVIEW_COMPLETED);
    }

    @Test
    public void testStateChangeParser() throws SQLException {
        this.verifyParse("CR-FE-6: FE-269: Test path button in edit repository doesn't save the form, user Pawel Niewiadomski, did action:approveReview. Changed to state: Review", this.reviewKeys.get("CR-FE-6"), this.displayNames.get("Pawel Niewiadomski"), LogAction.REVIEW_STATE_CHANGE);
        this.verifyParse("CR-FE-2377: CRUC-1679: mark files as read when you view them and align behaviour with comments (back end), user Geoff Crain, did action:closeReview. Changed to state: Closed", this.reviewKeys.get("CR-FE-2377"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_STATE_CHANGE);
    }

    @Test
    public void testCommentParser() throws SQLException {
        this.verifyParse("CR-FE-2374: alyons posted comment 21002", this.reviewKeys.get("CR-FE-2374"), this.userNames.get("alyons"), LogAction.COMMENT_ADDED);
        this.verifyParse("CR-FE-2412: cmacneill posted comment 21145", this.reviewKeys.get("CR-FE-2412"), this.userNames.get("cmacneill"), LogAction.COMMENT_ADDED);
        this.verifyParse("CR-FE-2283: evzijst deleted comment 19968: Yes we could cache it (and purge in {{setReplyToComment()}}), but that really be a win? Once a Hibernate data object is loaded in a session, there'll be no database IO when you request the same property again. So if the average comment is at a depth of 2 (haven't counted, but seems reasonable), then we'd eliminate a single pass of the while loop (which only follows a single reference in memory).", this.reviewKeys.get("CR-FE-2283"), this.userNames.get("evzijst"), LogAction.COMMENT_DELETED);
        this.verifyParse("CR-FE-2355: jxie deleted comment 20991", this.reviewKeys.get("CR-FE-2355"), this.userNames.get("jxie"), LogAction.COMMENT_DELETED);
        this.verifyParse("CR-FE-2373: evzijst updated comment 21001", this.reviewKeys.get("CR-FE-2373"), this.userNames.get("evzijst"), LogAction.COMMENT_UPDATED);
        this.verifyParse("CR-FE-2395: ahempel updated comment 21006", this.reviewKeys.get("CR-FE-2395"), this.userNames.get("ahempel"), LogAction.COMMENT_UPDATED);
        this.verifyParse("CR-CLOV-114: mstudman added comment 13862", this.reviewKeys.get("CR-CLOV-114"), this.userNames.get("mstudman"), LogAction.COMMENT_ADDED);
        this.verifyParse("CR-FE-2355: jxie added comment 20996", this.reviewKeys.get("CR-FE-2355"), this.userNames.get("jxie"), LogAction.COMMENT_ADDED);
        this.verifyParse("CR-FE-2355: evzijst changed comment 21019: \"I presume the path name in the revisionData element represents the path name of the latest revision (in case of files that get moved)?\" to \"I presume the path name in the revisionData element represents the path name of the latest revision (in case of files that get moved)?\n\nAlso, how do we handle the infamous \"whole file\" issue? Consider the following scenario:\n\n* user A commits a new file and creates a review with that single revision (1)\n* revision 1 renders as full-file\n* user A commits a change to the file and adds revision 2.\n\nHow do we expect crucible (and hence the connector) to render the result? And how does this compare to user B who only wants the review the diff between 1 and 2 by creating a new review from changeset(2)?\nWould the REST response look the same for both scenarios?\nIs revision 1 considered to be reviewed in eyeql?\"", this.reviewKeys.get("CR-FE-2355"), this.userNames.get("evzijst"), LogAction.COMMENT_CHANGED);
        this.verifyParse("CR-FE-2378: sruiz changed comment 20903: \"Same here, pull out {{CRU.FRX}} into a local variable\" to \"Same here, pull out {{CRU.FRX}} into a local variable\"", this.reviewKeys.get("CR-FE-2378"), this.userNames.get("sruiz"), LogAction.COMMENT_CHANGED);
        this.verifyParse("CR-FE-1401: jxie changed comment back to draft.", this.reviewKeys.get("CR-FE-1401"), this.userNames.get("jxie"), LogAction.COMMENT_REDRAFTED);
        this.verifyParse("CR-FE-1472: mquail changed comment back to draft.", this.reviewKeys.get("CR-FE-1472"), this.userNames.get("mquail"), LogAction.COMMENT_REDRAFTED);
    }

    @Test
    public void testAlteringReview() throws SQLException {
        this.verifyParse("Joe Xie' altering CR-FE-2369 changing title to \"CRUC-1778: better api for review manipulation\"", this.reviewKeys.get("CR-FE-2369"), this.displayNames.get("Joe Xie'"), LogAction.REVIEW_TITLE_CHANGED);
        this.verifyParse("Conor MacNeill altering CR-FE-2425 changing description to \"When you upgrade to crowd 2.0 you get the following error in Fisheye:\n\n{noformat}\njava.lang.NoSuchMethodError: com.atlassian.crowd.integration.http.HttpAuthenticator.getPrincipalAuthenticationContext(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/String;Ljava/lang/String;)Lcom/atlassian/crowd/integration/authentication/PrincipalAuthenticationContext;\nat com.cenqua.fisheye.user.crowd.CrowdAuth.checkPassword(CrowdAuth.java:90)\nat com.cenqua.fisheye.user.UserManager.login(UserManager.java:350)\nat com.atlassian.crucible.spi.rpc.RestAuthService.loginImpl(RestAuthService.java:65)\nat com.atlassian.crucible.spi.rpc.RestAuthService.login(RestAuthService.java:55)\nat sun.reflect.GeneratedMethodAccessor55.invoke(Unknown Source)\nat sun.reflect.DelegatingMethodAccessorImpl.invoke(Unknown Source)\nat java.lang.reflect.Method.invoke(Unknown Source)\nat com.sun.jersey.server.impl.model.method.dispatch.AbstractResourceMethodDispatchProvider$TypeOutInvoker._dispatch(AbstractResourceMethodDispatchProvider.java:156)\nat com.sun.jersey.server.impl.model.method.dispatch.ResourceJavaMethodDispatcher.dispatch(ResourceJavaMethodDispatcher.java:67)\nat com.sun.jersey.server.impl.uri.rules.HttpMethodRule.accept(HttpMethodRule.java:163)\nat com.sun.jersey.server.impl.uri.rules.RightHandPathRule.accept(RightHandPathRule.java:111)\nat com.sun.jersey.server.impl.uri.rules.ResourceClassRule.accept(ResourceClassRule.java:71)\nat com.sun.jersey.server.impl.uri.rules.RightHandPathRule.accept(RightHandPathRule.java:111)\nat com.sun.jersey.server.impl.uri.rules.RootResourceClassesRule.accept(RootResourceClassesRule.java:63)\nat com.sun.jersey.server.impl.application.WebApplicationImpl._handleRequest(WebApplicationImpl.java:654)\nat com.sun.jersey.server.impl.application.WebApplicationImpl.handleRequest(WebApplicationImpl.java:612)\nat com.sun.jersey.server.impl.application.WebApplicationImpl.handleRequest(WebApplicationImpl.java:603)\nat com.sun.jersey.spi.container.servlet.WebComponent.service(WebComponent.java:309)\nat com.sun.jersey.spi.container.servlet.ServletContainer.service(ServletContainer.java:425)\nat com.sun.jersey.spi.container.servlet.ServletContainer.service(ServletContainer.java:590)\nat javax.servlet.http.HttpServlet.service(HttpServlet.java:820)\nat org.eclipse.jetty.servlet.ServletHolder.handle(ServletHolder.java:502)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1208)\nat com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:55)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:41)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:55)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:41)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:83)\nat org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:76)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.atlassian.crucible.filters.CrucibleFilter.doFilter(CrucibleFilter.java:118)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.cenqua.fisheye.web.filters.TotalityFilter.doFilter(TotalityFilter.java:224)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.atlassian.security.auth.trustedapps.filter.TrustedApplicationsFilter.doFilter(TrustedApplicationsFilter.java:98)\nat org.springframework.web.filter.DelegatingFilterProxy.invokeDelegate(DelegatingFilterProxy.java:236)\nat org.springframework.web.filter.DelegatingFilterProxy.doFilter(DelegatingFilterProxy.java:167)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:55)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:41)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat org.eclipse.servlet.UserAgentFilter.doFilter(UserAgentFilter.java:81)\nat org.eclipse.servlet.GzipFilter.doFilter(GzipFilter.java:145)\nat com.cenqua.fisheye.web.filters.CustomIncludableGzipFilter.doFilter(CustomIncludableGzipFilter.java:21)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.cenqua.fisheye.web.filters.ProductInfoFilter.doFilter(ProductInfoFilter.java:36)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:55)\nat com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:41)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat com.cenqua.fisheye.web.filters.UpfrontFilter.doFilter(UpfrontFilter.java:59)\nat org.eclipse.jetty.servlet.ServletHandler$Chain.doFilter(ServletHandler.java:1200)\nat org.eclipse.jetty.servlet.ServletHandler.handle(ServletHandler.java:387)\nat org.eclipse.jetty.security.SecurityHandler.handle(SecurityHandler.java:216)\nat org.eclipse.jetty.servlet.SessionHandler.handle(SessionHandler.java:181)\nat org.eclipse.jetty.server.handler.ContextHandler.handle(ContextHandler.java:765)\nat org.eclipse.jetty.webapp.WebAppContext.handle(WebAppContext.java:417)\nat org.eclipse.jetty.server.handler.ContextHandlerCollection.handle(ContextHandlerCollection.java:230)\nat org.eclipse.jetty.server.handler.HandlerCollection.handle(HandlerCollection.java:114)\nat org.eclipse.jetty.server.handler.HandlerWrapper.handle(HandlerWrapper.java:152)\nat org.eclipse.jetty.Server.handle(Server.java:324)\nat org.eclipse.jetty.HttpConnection.handleRequest(HttpConnection.java:535)\nat org.eclipse.jetty.server.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:865)\nat org.eclipse.jetty.HttpParser.parseNext(HttpParser.java:539)\nat org.eclipse.jetty.HttpParser.parseAvailable(HttpParser.java:212)\nat org.eclipse.jetty.HttpConnection.handle(HttpConnection.java:404)\nat org.eclipse.jetty.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:409)\nat org.eclipse.jetty.util.thread.BoundedThreadPool$PoolThread.run(BoundedThreadPool.java:451)\n{noformat} \n\n\"", this.reviewKeys.get("CR-FE-2425"), this.displayNames.get("Conor MacNeill"), LogAction.REVIEW_DESCRIPTION_CHANGED);
        this.verifyParse("Geoff Crain altering CR-FE-1597 changing allow reviewers to join to \"true\"", this.reviewKeys.get("CR-FE-1597"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_ALLOW_JOIN_CHANGED);
        this.verifyParse("Erik van Zijst altering CR-FE-1412 changing due date to \"2009-03-19T00:00:00\"", this.reviewKeys.get("CR-FE-1412"), this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_DUE_DATE_CHANGED);
        this.verifyParse("Seb Ruiz altering CR-FE-2357 unlinked jira issue key", this.reviewKeys.get("CR-FE-2357"), this.displayNames.get("Seb Ruiz"), LogAction.REVIEW_JIRA_KEY_DELETED);
        this.verifyParse("Erik van Zijst altering CR-FE-1579 changing jira issue key to \"CRUC-1293\"", this.reviewKeys.get("CR-FE-1579"), this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_JIRA_KEY_CHANGED);
        this.verifyParse("Erik van Zijst altering CR-FE-2261 changing author to evzijst", this.reviewKeys.get("CR-FE-2261"), this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_AUTHOR_CHANGED);
        this.verifyParse("Peter McNeil altering POTATO-12 changing moderator to pmcneil", this.reviewKeys.get("POTATO-12"), this.displayNames.get("Peter McNeil"), LogAction.REVIEW_MODERATOR_CHANGED);
        this.verifyParse("Geoff Crain altering CR-FE-779 removing reviewer mquail", this.reviewKeys.get("CR-FE-779"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_REVIEWER_REMOVED);
        this.verifyParse("Seb Ruiz altering CR-FE-2438 adding reviewer mquail", this.reviewKeys.get("CR-FE-2438"), this.displayNames.get("Seb Ruiz"), LogAction.REVIEW_REVIEWER_ADDED);
        this.verifyParse("Erik van Zijst altering CR-145 changing repository to \"FE\"", this.reviewKeys.get("CR-145"), this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_REPOSITORY_CHANGED);
        this.verifyParse("Geoff Crain altering CR-FE-265 adding search select revisions from dir / where comment matches \"highlighting\" group by changeset", this.reviewKeys.get("CR-FE-265"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_SEARCH_ADDED);
        this.verifyParse("Matt Quail altering CR-FE-661 changing parent review to \"CR-FE-659\"", this.reviewKeys.get("CR-FE-661"), this.displayNames.get("Matt Quail"), LogAction.REVIEW_PARENT_REVIEW_CHANGED);
    }

    @Test
    public void testUpdatedRevisionParser() throws SQLException {
        this.verifyParse("Erik van Zijst Updated trunk/src/java/com/cenqua/crucible/model/discussion/DiscussionBrowser.java, now contains 41414", null, this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_REVISION_UPDATED);
        this.verifyParse("Erik van Zijst Updated trunk/src/content/WEB-INF/tags/review/jiraDisplay.tag, now contains ", null, this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_REVISION_UPDATED);
        this.verifyParse("Erik van Zijst Updated trunk/src/java/com/atlassian/crucible/spi/rpc/ContentAwareFileData.java, was (23300 to 23355), now (23355)", null, this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_REVISION_UPDATED);
        this.verifyParse("Tim Pettersen Updated trunk/src/java/com/cenqua/fisheye/web/CrossRepositoryChangelogServlet.java, was (25926 to 26014), now (25926 to 26175)", null, this.displayNames.get("Tim Pettersen"), LogAction.REVIEW_REVISION_UPDATED);
    }

    @Test
    public void testAddRemoveRevisionParser() throws SQLException {
        this.verifyParse("Erik van Zijst adding revision trunk/src/java/com/atlassian/crucible/spi/impl/DefaultReviewService.java r42457-42722 to CR-FE-2420", this.reviewKeys.get("CR-FE-2420"), this.displayNames.get("Erik van Zijst"), LogAction.REVIEW_REVISION_ADDED);
        this.verifyParse("Geoff Crain removing revision trunk/src/java/com/cenqua/crucible/actions/create/CreateReviewFromChangesetAjaxAction.java r42401 from CR-FE-2390", this.reviewKeys.get("CR-FE-2390"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_REVISION_REMOVED);
        this.verifyParse("Geoff Crain removing frx 26876 r42206 from CR-FE-2377", this.reviewKeys.get("CR-FE-2377"), this.displayNames.get("Geoff Crain"), LogAction.REVIEW_FRX_REMOVED);
        this.verifyParse("Peter McNeil adding revision trunk/src/java/com/cenqua/crucible/model/Review.java r17154-17672 to CR-FE-316 replacing trunk/src/java/com/cenqua/crucible/model/Review.java r17154-17666", this.reviewKeys.get("CR-FE-316"), this.displayNames.get("Peter McNeil"), LogAction.REVIEW_REVISION_ADDED);
    }

    @Test
    public void testUpdatedRevision2Parser() throws SQLException {
        this.verifyParse("Geoff Crain updated revision trunk/src/java/com/cenqua/crucible/util/ReviewCreationHelper.java r17206-17485 (fromRevision was '17206')", null, this.displayNames.get("Geoff Crain"), LogAction.REVIEW_REVISION_UPDATED);
    }

    @Test
    public void testDeleteParser() throws SQLException {
        this.verifyParse("Deleted linked Jira issue FE-1969", null, null, LogAction.JIRA_ISSUE_DELETED);
        this.verifyParse("Deleted comment CMT:21348: \"{quote}    <link rel=\"history\" href=\"http://localhost:6060/crucible/rest-service/repositories-v1/history/CSLite/2353/trunk/checkstyle/AllCheckstyleTests.launch\"/>\n    <link rel=\"content\" href=\"http://localhost:6060/crucible/rest-service/repositories-v1/content/CSLite/2353/trunk/checkstyle/AllCheckstyleTests.launch\"/>\n{quote}\n\nwhy do both these links point to the same href?\"", null, null, LogAction.COMMENT_DELETED);
    }

    private void verifyParse(String text, Integer reviewId, Integer userId, LogAction logAction) throws SQLException {
        LogTableUpgrader51.ParseResult result = this.upgrader.parseItem(text, 1);
        Assert.assertEquals((Object)result.logAction, (Object)logAction);
        Assert.assertEquals((Object)result.reviewId, (Object)reviewId);
        Assert.assertEquals((Object)result.userId, (Object)userId);
    }
}

