/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtil;
import java.util.Map;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level0-datasource.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class Hibernate4UpgradeTaskTest {
    @Autowired
    DataSource dataSource;
    private DefaultDBControl dbControl;

    @Before
    public void setup() throws Exception {
        DatabaseConfig dbConfig = UpgradeTestUtil.createDbConfig(this.dataSource);
        this.dbControl = UpgradeTestUtil.createDbControl(dbConfig, this.dataSource);
    }

    @After
    public void tearDown() throws Exception {
        UpgradeTestUtil.dropTables(this.dataSource);
    }

    @Test
    public void testUpgrade_shouldMatchIndexesAndConstraintsOnANewDB() throws Exception {
        UpgradeTestUtil.createSchema((DBControl)this.dbControl, 92);
        Map<String, UpgradeTestUtil.TableData> newlyCreated = UpgradeTestUtil.collectTableData(this.dataSource);
        this.dbControl.dropTables();
        UpgradeTestUtil.createSchema((DBControl)this.dbControl, 91);
        this.dbControl.upgrade(92);
        Map<String, UpgradeTestUtil.TableData> afterUpgrade = UpgradeTestUtil.collectTableData(this.dataSource);
        UpgradeTestUtil.assertTableDataMatches(newlyCreated, afterUpgrade, this.dbControl.getType());
    }
}

