/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.GroupMigrationUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.ProxyDB0HandleFactory;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTestUtils;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.config.DB0HandleFactory;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.google.common.base.Splitter;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level1-session.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class GroupMigrationUpgradeTaskTest {
    private Resource data0binResource = new ClassPathResource("/com/cenqua/crucible/hibernate/upgrade/data/data0.bin");
    private Resource data0PropertiesResource = new ClassPathResource("/com/cenqua/crucible/hibernate/upgrade/data/data0.properties");
    private Properties data0Properties;
    private DB0Handle db0Handle;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private SessionFactory sessionFactory;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        Assert.assertThat((Object)this.dataSource, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.data0binResource.exists(), (Matcher)Matchers.equalTo((Object)true));
        this.db0Handle = new DB0Handle(this.data0binResource.getFile());
        Assert.assertThat((Object)this.db0Handle.isOpen(), (Matcher)Matchers.equalTo((Object)true));
        this.connection = this.dataSource.getConnection();
        this.data0Properties = PropertiesUtil.loadFromFile((File)this.data0PropertiesResource.getFile());
        Assert.assertThat((Object)this.data0Properties.getProperty("group.all.count"), (Matcher)Matchers.notNullValue());
        this.createGroupsTables(((SessionFactoryImplementor)this.sessionFactory).getDialect());
    }

    private void createGroupsTables(Dialect dialect) throws SQLException {
        Statement createTables = this.connection.createStatement();
        if (dialect instanceof MySQL5Dialect) {
            createTables.executeUpdate("create table cru_builtin_group (cru_builtin_group_id integer not null, cru_builtin_group_name varchar(255) not null, primary key (cru_builtin_group_id), unique (cru_builtin_group_name))");
            createTables.executeUpdate("create table cru_builtin_group_user (cru_builtin_group_id integer not null, cru_user_id integer not null, primary key (cru_builtin_group_id, cru_user_id))");
        } else if (dialect instanceof HSQLDialect) {
            createTables.executeUpdate("create table cru_builtin_group (cru_builtin_group_id integer not null, cru_builtin_group_name varchar(255) not null, primary key (cru_builtin_group_id), unique (cru_builtin_group_name))");
            createTables.executeUpdate("create table cru_builtin_group_user (cru_builtin_group_id integer not null, cru_user_id integer not null, primary key (cru_builtin_group_id, cru_user_id))");
        } else if (dialect instanceof Oracle10gDialect) {
            createTables.executeUpdate("create table cru_builtin_group (cru_builtin_group_id number(10,0) not null, cru_builtin_group_name varchar2(255 char) not null unique, primary key (cru_builtin_group_id))");
            createTables.executeUpdate("create table cru_builtin_group_user (cru_builtin_group_id number(10,0) not null, cru_user_id number(10,0) not null, primary key (cru_builtin_group_id, cru_user_id))");
        } else if (dialect instanceof PostgreSQL82Dialect) {
            createTables.executeUpdate("create table cru_builtin_group (cru_builtin_group_id int4 not null, cru_builtin_group_name varchar(255) not null unique, primary key (cru_builtin_group_id))");
            createTables.executeUpdate("create table cru_builtin_group_user (cru_builtin_group_id int4 not null, cru_user_id int4 not null, primary key (cru_builtin_group_id, cru_user_id))");
        } else if (dialect instanceof SQLServerDialect) {
            createTables.executeUpdate("create table cru_builtin_group (cru_builtin_group_id int not null, cru_builtin_group_name nvarchar(255) not null unique, primary key (cru_builtin_group_id))");
            createTables.executeUpdate("create table cru_builtin_group_user (cru_builtin_group_id int not null, cru_user_id int not null, primary key (cru_builtin_group_id, cru_user_id))");
        } else {
            throw new AssertionError((Object)("Wrong dialect " + dialect));
        }
        createTables.close();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.db0Handle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Statement dropTables = this.connection.createStatement();
            dropTables.executeUpdate("DROP TABLE CRU_BUILTIN_GROUP");
            dropTables.executeUpdate("DROP TABLE CRU_BUILTIN_GROUP_USER");
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAfterUpgradeScript() throws Exception {
        UpgradeTestUtils.initDBUsers(this.connection, this.data0Properties, "group.users.csv");
        GroupMigrationUpgradeTask groupMigrationUpgradeTask = new GroupMigrationUpgradeTask((DB0HandleFactory)new ProxyDB0HandleFactory(this.db0Handle));
        groupMigrationUpgradeTask.afterUpgradeScript(this.connection, DBType.HSQL);
        int allGroupCount = UpgradeTestUtils.getCount(this.connection, "select count(*) from cru_builtin_group");
        int expectedAllGroupGroup = this.getExpectedCountFor("all");
        Assert.assertThat((Object)allGroupCount, (Matcher)Matchers.equalTo((Object)expectedAllGroupGroup));
        Iterable groupNames = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.data0Properties.getProperty("group.names.csv"));
        Assert.assertThat((Object)groupNames, (Matcher)IsNot.not((Matcher)Matchers.emptyIterable()));
        for (String groupName : groupNames) {
            int groupCount = UpgradeTestUtils.getCount(this.connection, String.format("select count(*) from cru_builtin_group g, cru_builtin_group_user gu where g.cru_builtin_group_id = gu.cru_builtin_group_id and g.cru_builtin_group_name like '%s'", groupName));
            int expectedGroupCount = this.getExpectedCountFor(groupName);
            Assert.assertThat((String)("wrong number of users in group: " + groupName), (Object)groupCount, (Matcher)Matchers.equalTo((Object)expectedGroupCount));
        }
    }

    private int getExpectedCountFor(String name) {
        return Integer.parseInt(this.data0Properties.getProperty("group." + name + ".count"));
    }
}

