/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.upgrade.DedupeStoredPathUpgradeTask;
import com.cenqua.crucible.hibernate.upgrade.UpgradeTaskTestDbHelper;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DedupeStoredPathUpgradeTaskTest {
    public static final String PATH1 = "/some/path";
    public static final String PATH2 = "/and/some/other/path";
    public static final String SOURCE1 = "SOURCE1";
    public static final int SCHEMA_VERSION = 81;
    public static final String REVISION1 = "1";
    public static final int REVIEW1 = 1;
    public static final int REVIEW100 = 100;
    private UpgradeTaskTestDbHelper sqlDbHelper;
    private long sequence;
    private DedupeStoredPathUpgradeTask task;
    private Frx frx;

    @Before
    public void setUp() throws Exception {
        this.sqlDbHelper = new UpgradeTaskTestDbHelper("usersMigrationTestDB");
        this.task = new DedupeStoredPathUpgradeTask();
        this.sequence = 1L;
        this.createCruDedupTables();
        this.frx = this.insertFrx();
    }

    @After
    public void tearDown() throws Exception {
        this.sqlDbHelper.closeQuietly();
    }

    @Test
    public void testDuplicateNonNullPaths() throws Exception {
        StoredPath path11 = this.insertPath(PATH1);
        StoredPath path12 = this.insertPath(PATH1);
        StoredPath path2 = this.insertPath(PATH2);
        Revision rev4 = this.insertRevision(path11.pathId);
        Revision rev5 = this.insertRevision(path12.pathId);
        Revision rev6 = this.insertRevision(path2.pathId);
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        List<StoredPath> storedPaths = this.listStoredPaths();
        Assert.assertThat(storedPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new StoredPath[]{path11, path2}));
        List<Revision> revisions = this.listRevisions();
        Assert.assertThat(revisions, (Matcher)Matchers.containsInAnyOrder((Object[])new Revision[]{rev4, rev6}));
    }

    @Test
    public void testDeduplicateNullPaths() throws Exception {
        StoredPath pathNull1 = this.insertPath(null);
        StoredPath pathNull2 = this.insertPath(null);
        StoredPath pathNull3 = this.insertPath(null);
        StoredPath path11 = this.insertPath(PATH1);
        StoredPath path12 = this.insertPath(PATH1);
        StoredPath path2 = this.insertPath(PATH2);
        Revision rev1 = this.insertRevision(pathNull1.pathId);
        Revision rev2 = this.insertRevision(pathNull2.pathId);
        Revision rev3 = this.insertRevision(pathNull3.pathId);
        Revision rev4 = this.insertRevision(path11.pathId);
        Revision rev5 = this.insertRevision(path12.pathId);
        Revision rev6 = this.insertRevision(path2.pathId);
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        List<StoredPath> storedPaths = this.listStoredPaths();
        Assert.assertThat(storedPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new StoredPath[]{pathNull1, path11, path2}));
        List<Revision> revisions = this.listRevisions();
        Assert.assertThat(revisions, (Matcher)Matchers.containsInAnyOrder((Object[])new Revision[]{rev1, rev4, rev6}));
    }

    @Test
    public void testChosenPathIdDoesntHaveRevision() throws Exception {
        StoredPath pathNull1 = this.insertPath(null);
        StoredPath pathNull2 = this.insertPath(null);
        StoredPath pathNull3 = this.insertPath(null);
        StoredPath path11 = this.insertPath(PATH1);
        StoredPath path12 = this.insertPath(PATH1);
        StoredPath path2 = this.insertPath(PATH2);
        Revision rev2 = this.insertRevision(pathNull2.pathId);
        Revision rev3 = this.insertRevision(pathNull3.pathId);
        Revision rev4 = this.insertRevision(path11.pathId);
        Revision rev5 = this.insertRevision(path12.pathId);
        Revision rev6 = this.insertRevision(path2.pathId);
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        List<StoredPath> storedPaths = this.listStoredPaths();
        Assert.assertThat(storedPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new StoredPath[]{pathNull1, path11, path2}));
        List<Revision> revisions = this.listRevisions();
        rev2.path = pathNull1.pathId;
        Assert.assertThat(revisions, (Matcher)Matchers.containsInAnyOrder((Object[])new Revision[]{rev2, rev4, rev6}));
    }

    @Test
    public void testFeindexMsgRefersToRevision() throws Exception {
        StoredPath pathNull1 = this.insertPath(null);
        StoredPath pathNull2 = this.insertPath(null);
        StoredPath pathNull3 = this.insertPath(null);
        StoredPath path11 = this.insertPath(PATH1);
        StoredPath path12 = this.insertPath(PATH1);
        StoredPath path2 = this.insertPath(PATH2);
        Revision rev1 = this.insertRevision(pathNull1.pathId);
        Revision rev2 = this.insertRevision(pathNull2.pathId);
        Revision rev3 = this.insertRevision(pathNull3.pathId);
        Revision rev4 = this.insertRevision(path11.pathId);
        Revision rev5 = this.insertRevision(path12.pathId);
        Revision rev6 = this.insertRevision(path2.pathId);
        FeindexMsg fm1 = this.insertFeindexMsg(rev1.revisionId);
        FeindexMsg fm2 = this.insertFeindexMsg(rev2.revisionId);
        FeindexMsg fm3 = this.insertFeindexMsg(rev3.revisionId);
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        List<StoredPath> storedPaths = this.listStoredPaths();
        Assert.assertThat(storedPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new StoredPath[]{pathNull1, path11, path2}));
        List<Revision> revisions = this.listRevisions();
        Assert.assertThat(revisions, (Matcher)Matchers.containsInAnyOrder((Object[])new Revision[]{rev1, rev4, rev6}));
        List<FeindexMsg> fms = this.listFeindexMsgs();
        Assert.assertThat(fms, (Matcher)Matchers.containsInAnyOrder((Object[])new FeindexMsg[]{fm1}));
    }

    @Test
    public void testFrxRevisionRefersToRevision() throws Exception {
        StoredPath path11 = this.insertPath(PATH1);
        StoredPath path12 = this.insertPath(PATH1);
        Revision rev4 = this.insertRevision(path11.pathId);
        Revision rev5 = this.insertRevision(path12.pathId);
        FrxRevision frxRev4 = this.insertFrxRevision(rev4.revisionId);
        FrxRevision frxRev5 = this.insertFrxRevision(rev5.revisionId);
        this.task.afterUpgradeScript(this.sqlDbHelper.getConnection(), DBType.HSQL);
        List<FrxRevision> frxRevs = this.listFrxRevisions();
        frxRev5.revision = rev4.revisionId;
        Assert.assertThat(frxRevs, (Matcher)Matchers.containsInAnyOrder((Object[])new FrxRevision[]{frxRev4, frxRev5}));
    }

    @Test
    public void testFormatSqlQueryWithString() throws Exception {
        Assert.assertThat((Object)DedupeStoredPathUpgradeTask.formatSqlQuery((String)"SELECT * FROM t1 WHERE name = ?", (Object[])new Object[]{"ala"}), (Matcher)Is.is((Object)"SELECT * FROM t1 WHERE name = 'ala'"));
    }

    @Test
    public void testFormatSqlQueryWithLong() throws Exception {
        Assert.assertThat((Object)DedupeStoredPathUpgradeTask.formatSqlQuery((String)"SELECT * FROM t1 WHERE id = ?", (Object[])new Object[]{1L}), (Matcher)Is.is((Object)"SELECT * FROM t1 WHERE id = 1"));
    }

    @Test
    public void testFormatSqlQueryWithStringAndLong() throws Exception {
        Assert.assertThat((Object)DedupeStoredPathUpgradeTask.formatSqlQuery((String)"SELECT * FROM t1 WHERE name = ? AND id = ?", (Object[])new Object[]{"ala", 1L}), (Matcher)Is.is((Object)"SELECT * FROM t1 WHERE name = 'ala' AND id = 1"));
    }

    private void createCruDedupTables() throws IOException, SQLException {
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/tables_81.sql"), "create table cru_review", "create table cru_inline_comment", "create table cru_inline_comment_to_frx_rev", "create table cru_frx", "create table cru_upload_item", "create table cru_feindex_msg", "create table cru_fr_detail", "create table cru_frx_revision", "create table cru_revision", "create table cru_stored_path", "create table cru_version");
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/schema/constraints_81.sql"), "alter table cru_inline_comment_to_frx_rev", "on cru_inline_comment_to_frx_rev", "alter table cru_feindex_msg", "on cru_feindex_msg", "alter table cru_fr_detail", "on cru_fr_detail", "alter table cru_frx_revision", "on cru_frx_revision", "alter table cru_revision", "on cru_revision", "alter table cru_stored_path", "on cru_stored_path");
        this.sqlDbHelper.runScripts(new File("etc/dist/sql/HSQL/upgrade/upgrade_81.sql"), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoredPath insertPath(String path) throws SQLException {
        StoredPath storedPath;
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_stored_path(cru_path_id, cru_path) VALUES (?, ?)");
            long id = this.sequence++;
            statement.setLong(1, id);
            statement.setString(2, path);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
            storedPath = new StoredPath(id, path);
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
        return storedPath;
    }

    private Revision insertRevision(long pathId) throws SQLException {
        return this.insertRevision(SOURCE1, REVISION1, pathId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Revision insertRevision(String sourceName, String revision, long path) throws SQLException {
        Revision revision2;
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_revision(cru_revision_id, cru_source_name, cru_revision, cru_path, cru_revision_display_name) VALUES (?, ?, ?, ?, ?)");
            long id = this.sequence++;
            statement.setLong(1, id);
            statement.setString(2, sourceName);
            statement.setString(3, revision);
            statement.setLong(4, path);
            statement.setString(5, sourceName + "-" + revision);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
            revision2 = new Revision(id, sourceName, revision, path);
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
        return revision2;
    }

    private FeindexMsg insertFeindexMsg(long frId) throws SQLException {
        return this.insertFeindexMsg(frId, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeindexMsg insertFeindexMsg(long frId, long reviewId) throws SQLException {
        FeindexMsg feindexMsg;
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_feindex_msg(cru_id, cru_fr_id, cru_review_id) VALUES (?, ?, ?)");
            long id = this.sequence++;
            statement.setLong(1, id);
            statement.setLong(2, frId);
            statement.setLong(3, reviewId);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
            feindexMsg = new FeindexMsg(id, frId, reviewId);
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
        return feindexMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Frx insertFrx() throws SQLException {
        Frx frx;
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_frx(cru_frx_id, cru_review_id, cru_show_as_diff) VALUES (?, ?, ?)");
            long id = this.sequence++;
            statement.setLong(1, id);
            statement.setLong(2, 100L);
            statement.setBoolean(3, true);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
            frx = new Frx(id);
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
        return frx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrxRevision insertFrxRevision(long revision) throws SQLException {
        FrxRevision frxRevision;
        PreparedStatement statement = null;
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("INSERT INTO cru_frx_revision(cru_frx_rev_id, cru_revision, cru_frx_id, cru_date_added, cru_revision_order) VALUES (?, ?, ?, ?, ?)");
            long id = this.sequence++;
            statement.setLong(1, id);
            statement.setLong(2, revision);
            statement.setLong(3, this.frx.frxId);
            statement.setLong(4, System.currentTimeMillis());
            statement.setLong(5, 10L);
            Assert.assertThat((Object)statement.executeUpdate(), (Matcher)Is.is((Object)1));
            frxRevision = new FrxRevision(id, revision, this.frx.frxId);
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((Statement)statement);
        return frxRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StoredPath> listStoredPaths() throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList rows = Lists.newArrayList();
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("SELECT cru_path_id, cru_path FROM cru_stored_path");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long pathId = resultSet.getLong(1);
                String path = resultSet.getString(2);
                rows.add(new StoredPath(pathId, path));
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((ResultSet)resultSet, (Statement)statement);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Revision> listRevisions() throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList rows = Lists.newArrayList();
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("SELECT cru_revision_id, cru_source_name, cru_revision, cru_path FROM cru_revision");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long revisionId = resultSet.getLong(1);
                String sourceName = resultSet.getString(2);
                String revision = resultSet.getString(3);
                long path = resultSet.getLong(4);
                rows.add(new Revision(revisionId, sourceName, revision, path));
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((ResultSet)resultSet, (Statement)statement);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FeindexMsg> listFeindexMsgs() throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList rows = Lists.newArrayList();
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("SELECT cru_id, cru_fr_id, cru_review_id FROM cru_feindex_msg");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long id = resultSet.getLong(1);
                long frId = resultSet.getLong(2);
                long reviewId = resultSet.getLong(3);
                rows.add(new FeindexMsg(id, frId, reviewId));
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((ResultSet)resultSet, (Statement)statement);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FrxRevision> listFrxRevisions() throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList rows = Lists.newArrayList();
        try {
            statement = this.sqlDbHelper.getConnection().prepareStatement("SELECT cru_frx_rev_id, cru_revision, cru_frx_id FROM cru_frx_revision");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long frxRevId = resultSet.getLong(1);
                long revision = resultSet.getLong(2);
                long frxId = resultSet.getLong(3);
                rows.add(new FrxRevision(frxRevId, revision, frxId));
            }
        }
        catch (Throwable throwable) {
            JDBCHelper.closeQuietly(resultSet, statement);
            throw throwable;
        }
        JDBCHelper.closeQuietly((ResultSet)resultSet, (Statement)statement);
        return rows;
    }

    static class FrxRevision {
        long frxRevId;
        long revision;
        long frxId;

        FrxRevision(long frxRevId, long revision, long frxId) {
            this.frxRevId = frxRevId;
            this.revision = revision;
            this.frxId = frxId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrxRevision that = (FrxRevision)o;
            if (this.frxId != that.frxId) {
                return false;
            }
            if (this.frxRevId != that.frxRevId) {
                return false;
            }
            return this.revision == that.revision;
        }

        public int hashCode() {
            int result = (int)(this.frxRevId ^ this.frxRevId >>> 32);
            result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
            result = 31 * result + (int)(this.frxId ^ this.frxId >>> 32);
            return result;
        }

        public String toString() {
            return "FrxRevision{frxRevId=" + this.frxRevId + ", revision=" + this.revision + ", frxId=" + this.frxId + '}';
        }
    }

    static class Frx {
        long frxId;

        Frx(long frxId) {
            this.frxId = frxId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frx that = (Frx)o;
            return this.frxId == that.frxId;
        }

        public int hashCode() {
            return (int)(this.frxId ^ this.frxId >>> 32);
        }

        public String toString() {
            return "FrxRevision{frxId=" + this.frxId + '}';
        }
    }

    static class FeindexMsg {
        private long id;
        private long frId;
        private long reviewId;

        FeindexMsg(long id, long frId, long reviewId) {
            this.id = id;
            this.frId = frId;
            this.reviewId = reviewId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeindexMsg that = (FeindexMsg)o;
            if (this.reviewId != that.reviewId) {
                return false;
            }
            if (this.frId != that.frId) {
                return false;
            }
            return this.id == that.id;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.frId ^ this.frId >>> 32);
            result = 31 * result + (int)(this.reviewId ^ this.reviewId >>> 32);
            return result;
        }

        public String toString() {
            return "FeindexMsg{id=" + this.id + ", frId=" + this.frId + ", reviewId=" + this.reviewId + '}';
        }
    }

    static class Revision {
        private long revisionId;
        private String sourceName;
        private String revision;
        private long path;

        Revision(long revisionId, String sourceName, String revision, long path) {
            this.revisionId = revisionId;
            this.sourceName = sourceName;
            this.revision = revision;
            this.path = path;
        }

        Revision(long revisionId, long path) {
            this(revisionId, DedupeStoredPathUpgradeTaskTest.SOURCE1, DedupeStoredPathUpgradeTaskTest.REVISION1, path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Revision revision1 = (Revision)o;
            if (this.path != revision1.path) {
                return false;
            }
            if (this.revisionId != revision1.revisionId) {
                return false;
            }
            if (this.revision != null ? !this.revision.equals(revision1.revision) : revision1.revision != null) {
                return false;
            }
            return !(this.sourceName != null ? !this.sourceName.equals(revision1.sourceName) : revision1.sourceName != null);
        }

        public int hashCode() {
            int result = (int)(this.revisionId ^ this.revisionId >>> 32);
            result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
            result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
            result = 31 * result + (int)(this.path ^ this.path >>> 32);
            return result;
        }

        public String toString() {
            return "Revision{revisionId=" + this.revisionId + ", sourceName='" + this.sourceName + '\'' + ", revision='" + this.revision + '\'' + ", path=" + this.path + '}';
        }
    }

    static class StoredPath {
        private long pathId;
        private String path;

        StoredPath(long pathId, String path) {
            this.pathId = pathId;
            this.path = path;
        }

        public String toString() {
            return "StoredPath{pathId=" + this.pathId + ", path='" + this.path + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredPath that = (StoredPath)o;
            if (this.pathId != that.pathId) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
        }

        public int hashCode() {
            int result = (int)(this.pathId ^ this.pathId >>> 32);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }
}

