/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.hibernate.trackingstatements.TrackingStatementsConnection;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableWithSize;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TrackingStatementsConnectionTest {
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();
    private TrackingStatementsConnection trackingStatementsConnection;
    private Connection connectionMock;
    private Statement statementMock;
    private CallableStatement callableStatementMock;
    private PreparedStatement preparedStatementMock;

    @Before
    public void setUp() throws Exception {
        this.connectionMock = (Connection)Mockito.mock(Connection.class);
        this.statementMock = (Statement)Mockito.mock(Statement.class);
        this.configureStatementMockCloseBehaviour(this.statementMock);
        this.callableStatementMock = (CallableStatement)Mockito.mock(CallableStatement.class);
        this.configureStatementMockCloseBehaviour(this.callableStatementMock);
        this.preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.configureStatementMockCloseBehaviour(this.preparedStatementMock);
        this.trackingStatementsConnection = new TrackingStatementsConnection(this.connectionMock, false);
    }

    private void configureStatementMockCloseBehaviour(Statement statement) throws SQLException {
        AtomicBoolean isStatementClosed = new AtomicBoolean(false);
        Answer isStatementClosedAnswer = invocation -> isStatementClosed.get();
        Answer setStatementClosedAnswer = invocation -> {
            isStatementClosed.set(true);
            return null;
        };
        Mockito.when((Object)statement.isClosed()).then(isStatementClosedAnswer);
        ((Statement)Mockito.doAnswer((Answer)setStatementClosedAnswer).when((Object)statement)).close();
    }

    @After
    public void tearDown() throws Exception {
    }

    private static Predicate<LoggingEvent> detectUnclosedStatementsPredicate() {
        return loggingEvent -> loggingEvent.getMessage().toString().contains("Statement was not properly closed before this connection was closed. Stack trace when statement was created: %s".substring(0, 30));
    }

    @Test
    public void testDoNotDetectUnclosedStatement() throws Exception {
        this.trackingStatementsConnection = new TrackingStatementsConnection(this.connectionMock, false);
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement();
        this.trackingStatementsConnection.close();
        Assert.assertThat((Object)Iterables.filter(this.logs.getEvents(), TrackingStatementsConnectionTest.detectUnclosedStatementsPredicate()), (Matcher)IsIterableWithSize.iterableWithSize((int)0));
    }

    @Test
    public void testDoDetectUnclosedStatement() throws Exception {
        this.trackingStatementsConnection = new TrackingStatementsConnection(this.connectionMock, true);
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement();
        this.trackingStatementsConnection.close();
        Assert.assertThat((Object)Iterables.filter(this.logs.getEvents(), TrackingStatementsConnectionTest.detectUnclosedStatementsPredicate()), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
    }

    @Test
    public void testClosedStatementNotTracked() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        Statement statement = this.trackingStatementsConnection.createStatement();
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)1L));
        statement.close();
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testManyClosedStatementsNotTracked() throws Exception {
        int i;
        int size = 100;
        ArrayList statements = Lists.newArrayList();
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)0L));
        for (i = 0; i < 100; ++i) {
            Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
            statements.add(this.trackingStatementsConnection.createStatement());
        }
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)100L));
        for (i = 0; i < 100; ++i) {
            Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)(100L - (long)i)));
            ((Statement)statements.get(i)).close();
        }
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testClosedCallableStatementNotTracked() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select")).thenReturn((Object)this.callableStatementMock);
        CallableStatement callableStatement = this.trackingStatementsConnection.prepareCall("select");
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)1L));
        callableStatement.close();
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testClosedPreparedStatementNotTracked() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select")).thenReturn((Object)this.preparedStatementMock);
        PreparedStatement preparedStatement = this.trackingStatementsConnection.prepareStatement("select");
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)1L));
        preparedStatement.close();
        Assert.assertThat((Object)this.trackingStatementsConnection.numberOfTrackedStatements(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testCloseCreateStatementOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement();
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseCreateStatement1OnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement(2, 6)).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement(2, 6);
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseCreateStatement2OnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement(2, 6, 8)).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement(2, 6, 8);
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareCallOneParamOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything1")).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything1");
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareCallThreeParamsOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything2", 3, 7)).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything2", 3, 7);
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareCallFourParamsOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything3", 3, 7, 9)).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything3", 3, 7, 9);
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((CallableStatement)Mockito.verify((Object)this.callableStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementOneParamOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything4")).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything4");
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.never())).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementThreeParamsOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything5", 4, 8)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything5", 4, 8);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementFourParamsOnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything6", 5, 8, 11)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything6", 5, 8, 11);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementTwoParams1OnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything7", 6)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything7", 6);
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementTwoParams2OnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything8", new int[]{8, 9})).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything8", new int[]{8, 9});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testClosePrepareStatementTwoParams3OnConnectionClose() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything9", new String[]{"a", "b"})).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything9", new String[]{"a", "b"});
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)0))).close();
        this.trackingStatementsConnection.close();
        ((PreparedStatement)Mockito.verify((Object)this.preparedStatementMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseAllStatementsConnectionClose() throws Exception {
        ArrayList statements = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            Statement statementMock = (Statement)Mockito.mock(Statement.class);
            this.configureStatementMockCloseBehaviour(statementMock);
            Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)statementMock);
            this.trackingStatementsConnection.createStatement();
            statements.add(statementMock);
        }
        for (Statement statement : statements) {
            ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.never())).close();
        }
        this.trackingStatementsConnection.close();
        for (Statement statement : statements) {
            ((Statement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testCloseOnlyOnceAndOnlyOnceConnectionClose() throws Exception {
        Statement statementMock1 = (Statement)Mockito.mock(Statement.class);
        this.configureStatementMockCloseBehaviour(statementMock1);
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)statementMock1);
        this.trackingStatementsConnection.createStatement();
        ((Statement)Mockito.verify((Object)statementMock1, (VerificationMode)Mockito.never())).close();
        this.trackingStatementsConnection.close();
        ((Statement)Mockito.verify((Object)statementMock1, (VerificationMode)Mockito.times((int)1))).close();
        Statement statementMock2 = (Statement)Mockito.mock(Statement.class);
        this.configureStatementMockCloseBehaviour(statementMock2);
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)statementMock2);
        this.trackingStatementsConnection.createStatement();
        ((Statement)Mockito.verify((Object)statementMock2, (VerificationMode)Mockito.never())).close();
        this.trackingStatementsConnection.close();
        ((Statement)Mockito.verify((Object)statementMock1, (VerificationMode)Mockito.times((int)1))).close();
        ((Statement)Mockito.verify((Object)statementMock2, (VerificationMode)Mockito.times((int)1))).close();
        this.trackingStatementsConnection.close();
        ((Statement)Mockito.verify((Object)statementMock1, (VerificationMode)Mockito.times((int)1))).close();
        ((Statement)Mockito.verify((Object)statementMock2, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseOnlyWhenOpen() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement();
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.never())).close();
        Mockito.when((Object)this.statementMock.isClosed()).thenReturn((Object)true);
        this.trackingStatementsConnection.close();
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testDelegateClose() throws Exception {
        this.trackingStatementsConnection.close();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testDelegateCreateStatement() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement()).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createStatement();
    }

    @Test
    public void testDelegateCreateStatement1() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement(2, 6)).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement(2, 6);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createStatement(2, 6);
    }

    @Test
    public void testDelegateCreateStatement2() throws Exception {
        Mockito.when((Object)this.connectionMock.createStatement(2, 6, 8)).thenReturn((Object)this.statementMock);
        this.trackingStatementsConnection.createStatement(2, 6, 8);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createStatement(2, 6, 8);
    }

    @Test
    public void testDelegatePrepareCallOneParam() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything1")).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything1");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareCall("select from everything1");
    }

    @Test
    public void testDelegatePrepareCallThreeParams() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything2", 3, 7)).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything2", 3, 7);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareCall("select from everything2", 3, 7);
    }

    @Test
    public void testDelegatePrepareCallFourParams() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareCall("select from everything3", 3, 7, 9)).thenReturn((Object)this.callableStatementMock);
        this.trackingStatementsConnection.prepareCall("select from everything3", 3, 7, 9);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareCall("select from everything3", 3, 7, 9);
    }

    @Test
    public void testDelegatePrepareStatementOneParam() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything4")).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything4");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything4");
    }

    @Test
    public void testDelegatePrepareStatementThreeParams() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything5", 4, 8)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything5", 4, 8);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything5", 4, 8);
    }

    @Test
    public void testDelegatePrepareStatementFourParams() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything6", 5, 8, 11)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything6", 5, 8, 11);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything6", 5, 8, 11);
    }

    @Test
    public void testDelegatePrepareStatementTwoParams1() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything7", 6)).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything7", 6);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything7", 6);
    }

    @Test
    public void testDelegatePrepareStatementTwoParams2() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything8", new int[]{8, 9})).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything8", new int[]{8, 9});
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything8", new int[]{8, 9});
    }

    @Test
    public void testDelegatePrepareStatementTwoParams3() throws Exception {
        Mockito.when((Object)this.connectionMock.prepareStatement("select from everything9", new String[]{"a", "b"})).thenReturn((Object)this.preparedStatementMock);
        this.trackingStatementsConnection.prepareStatement("select from everything9", new String[]{"a", "b"});
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).prepareStatement("select from everything9", new String[]{"a", "b"});
    }

    @Test
    public void testDelegateNativeSQL() throws Exception {
        Mockito.when((Object)this.connectionMock.nativeSQL("select * from everything")).thenReturn((Object)"select * from everything_native");
        Assert.assertThat((Object)this.trackingStatementsConnection.nativeSQL("select * from everything"), (Matcher)CoreMatchers.equalTo((Object)"select * from everything_native"));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).nativeSQL("select * from everything");
    }

    @Test
    public void testDelegateSetAutoCommit() throws Exception {
        this.trackingStatementsConnection.setAutoCommit(true);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setAutoCommit(true);
    }

    @Test
    public void testDelegateGetAutoCommit() throws Exception {
        Mockito.when((Object)this.connectionMock.getAutoCommit()).thenReturn((Object)true);
        Assert.assertThat((Object)this.trackingStatementsConnection.getAutoCommit(), (Matcher)CoreMatchers.equalTo((Object)true));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getAutoCommit();
    }

    @Test
    public void testDelegateCommit() throws Exception {
        this.trackingStatementsConnection.commit();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testDelegateRollback() throws Exception {
        this.trackingStatementsConnection.rollback();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).rollback();
    }

    @Test
    public void testDelegateRollbackOneParam() throws Exception {
        Savepoint savepointMock = (Savepoint)Mockito.mock(Savepoint.class);
        this.trackingStatementsConnection.rollback(savepointMock);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).rollback(savepointMock);
    }

    @Test
    public void testDelegateIsClosed() throws Exception {
        Mockito.when((Object)this.connectionMock.isClosed()).thenReturn((Object)false);
        Assert.assertThat((Object)this.trackingStatementsConnection.isClosed(), (Matcher)CoreMatchers.equalTo((Object)false));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).isClosed();
    }

    @Test
    public void testDelegateGetMetaData() throws Exception {
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.connectionMock.getMetaData()).thenReturn((Object)databaseMetaData);
        Assert.assertThat((Object)this.trackingStatementsConnection.getMetaData(), (Matcher)CoreMatchers.equalTo((Object)databaseMetaData));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getMetaData();
    }

    @Test
    public void testDelegateSetReadOnly() throws Exception {
        this.trackingStatementsConnection.setReadOnly(true);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(true);
    }

    @Test
    public void testDelegateIsReadOnly() throws Exception {
        Mockito.when((Object)this.connectionMock.isReadOnly()).thenReturn((Object)true);
        Assert.assertThat((Object)this.trackingStatementsConnection.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)true));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    public void testDelegateSetCatalog() throws Exception {
        this.trackingStatementsConnection.setCatalog("catalog");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setCatalog("catalog");
    }

    @Test
    public void testDelegateGetCatalog() throws Exception {
        Mockito.when((Object)this.connectionMock.getCatalog()).thenReturn((Object)"catalog");
        Assert.assertThat((Object)this.trackingStatementsConnection.getCatalog(), (Matcher)CoreMatchers.equalTo((Object)"catalog"));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getCatalog();
    }

    @Test
    public void testDelegateSetTransactionIsolation() throws Exception {
        this.trackingStatementsConnection.setTransactionIsolation(1);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setTransactionIsolation(1);
    }

    @Test
    public void testDelegateGetTransactionIsolation() throws Exception {
        Mockito.when((Object)this.connectionMock.getTransactionIsolation()).thenReturn((Object)2);
        Assert.assertThat((Object)this.trackingStatementsConnection.getTransactionIsolation(), (Matcher)CoreMatchers.equalTo((Object)2));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getTransactionIsolation();
    }

    @Test
    public void testDelegateGetWarnings() throws Exception {
        SQLWarning sqlWarningMock = (SQLWarning)Mockito.mock(SQLWarning.class);
        Mockito.when((Object)this.connectionMock.getWarnings()).thenReturn((Object)sqlWarningMock);
        Assert.assertThat((Object)this.trackingStatementsConnection.getWarnings(), (Matcher)CoreMatchers.equalTo((Object)sqlWarningMock));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getWarnings();
    }

    @Test
    public void testDelegateClearWarnings() throws Exception {
        this.trackingStatementsConnection.clearWarnings();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).clearWarnings();
    }

    @Test
    public void testDelegateGetTypeMap() throws Exception {
        HashMap typeMap = Maps.newHashMap();
        Mockito.when(this.connectionMock.getTypeMap()).thenReturn((Object)typeMap);
        Assert.assertThat((Object)this.trackingStatementsConnection.getTypeMap(), (Matcher)CoreMatchers.equalTo((Object)typeMap));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getTypeMap();
    }

    @Test
    public void testDelegateSetTypeMap() throws Exception {
        HashMap typeMap = Maps.newHashMap();
        this.trackingStatementsConnection.setTypeMap((Map)typeMap);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setTypeMap(typeMap);
    }

    @Test
    public void testDelegateGetHoldability() throws Exception {
        Mockito.when((Object)this.connectionMock.getHoldability()).thenReturn((Object)3);
        Assert.assertThat((Object)this.trackingStatementsConnection.getHoldability(), (Matcher)CoreMatchers.equalTo((Object)3));
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getHoldability();
    }

    @Test
    public void testDelegateSetHoldability() throws Exception {
        this.trackingStatementsConnection.setHoldability(4);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setHoldability(4);
    }

    @Test
    public void testDelegateSetSavepoint() throws Exception {
        this.trackingStatementsConnection.setSavepoint();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setSavepoint();
    }

    @Test
    public void testDelegateSetSavepoint1() throws Exception {
        this.trackingStatementsConnection.setSavepoint("savepoint");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setSavepoint("savepoint");
    }

    @Test
    public void testDelegateReleaseSavepoint() throws Exception {
        Savepoint savepointMock = (Savepoint)Mockito.mock(Savepoint.class);
        this.trackingStatementsConnection.releaseSavepoint(savepointMock);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).releaseSavepoint(savepointMock);
    }

    @Test
    public void testDelegateCreateClob() throws Exception {
        this.trackingStatementsConnection.createClob();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createClob();
    }

    @Test
    public void testDelegateCreateBlob() throws Exception {
        this.trackingStatementsConnection.createBlob();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createBlob();
    }

    @Test
    public void testDelegateCreateNClob() throws Exception {
        this.trackingStatementsConnection.createNClob();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createNClob();
    }

    @Test
    public void testDelegateCreateSQLXML() throws Exception {
        this.trackingStatementsConnection.createSQLXML();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createSQLXML();
    }

    @Test
    public void testDelegateIsValid() throws Exception {
        this.trackingStatementsConnection.isValid(4);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).isValid(4);
    }

    @Test
    public void testDelegateSetClientInfo() throws Exception {
        Properties properties = (Properties)Mockito.mock(Properties.class);
        this.trackingStatementsConnection.setClientInfo(properties);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setClientInfo(properties);
    }

    @Test
    public void testDelegateSetClientInfo1() throws Exception {
        this.trackingStatementsConnection.setClientInfo("s1", "s2");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setClientInfo("s1", "s2");
    }

    @Test
    public void testDelegateGetClientInfo() throws Exception {
        this.trackingStatementsConnection.getClientInfo();
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getClientInfo();
    }

    @Test
    public void testDelegateGetClientInfo1() throws Exception {
        this.trackingStatementsConnection.getClientInfo("s");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).getClientInfo("s");
    }

    @Test
    public void testDelegateCreateArrayOf() throws Exception {
        this.trackingStatementsConnection.createArrayOf("s", new Object[]{"o1", "o2"});
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createArrayOf("s", new Object[]{"o1", "o2"});
    }

    @Test
    public void testDelegateCreateStruct() throws Exception {
        this.trackingStatementsConnection.createStruct("s", new Object[]{"o1", "o2"});
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).createStruct("s", new Object[]{"o1", "o2"});
    }

    @Test
    public void testDelegateUnwrap() throws Exception {
        this.trackingStatementsConnection.unwrap(String.class);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).unwrap(String.class);
    }

    @Test
    public void testDelegateIsWrapperFor() throws Exception {
        this.trackingStatementsConnection.isWrapperFor(String.class);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).isWrapperFor(String.class);
    }

    @Test
    public void testSetSchema() throws SQLException {
        this.trackingStatementsConnection.setSchema("foo");
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setSchema("foo");
    }

    @Test
    public void testGetSchema() throws SQLException {
        Mockito.when((Object)this.connectionMock.getSchema()).thenReturn((Object)"foobar");
        String schema = this.trackingStatementsConnection.getSchema();
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)"foobar"));
    }

    @Test
    public void testAbort() throws SQLException {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        this.trackingStatementsConnection.abort(executor);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).abort(executor);
    }

    @Test
    public void testSetNetworkTimeout() throws Exception {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        int millis = 15;
        this.trackingStatementsConnection.setNetworkTimeout(executor, millis);
        ((Connection)Mockito.verify((Object)this.connectionMock, (VerificationMode)Mockito.times((int)1))).setNetworkTimeout(executor, millis);
    }

    @Test
    public void testGetNetworkTimeout() throws Exception {
        Mockito.when((Object)this.trackingStatementsConnection.getNetworkTimeout()).thenReturn((Object)1000000);
        int timeout = this.trackingStatementsConnection.getNetworkTimeout();
        Assert.assertThat((Object)timeout, (Matcher)CoreMatchers.equalTo((Object)1000000));
    }
}

