/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.trackingstatements;

import com.cenqua.crucible.hibernate.trackingstatements.CanUntrackStatement;
import com.cenqua.crucible.hibernate.trackingstatements.TrackingStatementFactory;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TrackingStatementFactoryTest {
    private CanUntrackStatement canUntrackStatementMock;

    @Before
    public void setUp() throws Exception {
        this.canUntrackStatementMock = (CanUntrackStatement)Mockito.mock(CanUntrackStatement.class);
    }

    @Test
    public void testDelegateStatement() throws Exception {
        Statement statementMock = (Statement)Mockito.mock(Statement.class);
        Statement statement = TrackingStatementFactory.createTrackingStatement((CanUntrackStatement)this.canUntrackStatementMock, (Statement)statementMock);
        ((Statement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)0))).executeBatch();
        statement.executeBatch();
        ((Statement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    public void testDelegatePreparedStatement() throws Exception {
        PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatement statement = TrackingStatementFactory.createTrackingPreparedStatement((CanUntrackStatement)this.canUntrackStatementMock, (PreparedStatement)statementMock);
        ((PreparedStatement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)0))).executeBatch();
        statement.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    public void testDelegateCallableStatement() throws Exception {
        CallableStatement statementMock = (CallableStatement)Mockito.mock(CallableStatement.class);
        CallableStatement statement = TrackingStatementFactory.createTrackingCallableStatement((CanUntrackStatement)this.canUntrackStatementMock, (CallableStatement)statementMock);
        ((CallableStatement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)0))).executeBatch();
        statement.executeBatch();
        ((CallableStatement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    public void testUntrackStatement() throws Exception {
        Statement statementMock = (Statement)Mockito.mock(Statement.class);
        Statement statement = TrackingStatementFactory.createTrackingStatement((CanUntrackStatement)this.canUntrackStatementMock, (Statement)statementMock);
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)0))).untrackStatement(statement);
        statement.close();
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)1))).untrackStatement(statement);
    }

    @Test
    public void testUntrackPreparedStatement() throws Exception {
        PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatement statement = TrackingStatementFactory.createTrackingPreparedStatement((CanUntrackStatement)this.canUntrackStatementMock, (PreparedStatement)statementMock);
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)0))).untrackStatement((Statement)statement);
        statement.close();
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)1))).untrackStatement((Statement)statement);
    }

    @Test
    public void testUntrackCallableStatement() throws Exception {
        CallableStatement statementMock = (CallableStatement)Mockito.mock(CallableStatement.class);
        CallableStatement statement = TrackingStatementFactory.createTrackingCallableStatement((CanUntrackStatement)this.canUntrackStatementMock, (CallableStatement)statementMock);
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)0))).untrackStatement((Statement)statement);
        statement.close();
        ((CanUntrackStatement)Mockito.verify((Object)this.canUntrackStatementMock, (VerificationMode)Mockito.times((int)1))).untrackStatement((Statement)statement);
    }

    @Test(expected=BatchUpdateException.class)
    public void testCheckedExceptionHandlingOnStatement() throws Exception {
        Statement statementMock = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statementMock.executeBatch()).thenThrow(new Class[]{BatchUpdateException.class});
        Statement statement = TrackingStatementFactory.createTrackingStatement((CanUntrackStatement)this.canUntrackStatementMock, (Statement)statementMock);
        statement.executeBatch();
    }

    @Test(expected=BatchUpdateException.class)
    public void testCheckedExceptionHandlingOnPreparedStatement() throws Exception {
        PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)statementMock.executeBatch()).thenThrow(new Class[]{BatchUpdateException.class});
        PreparedStatement statement = TrackingStatementFactory.createTrackingPreparedStatement((CanUntrackStatement)this.canUntrackStatementMock, (PreparedStatement)statementMock);
        statement.executeBatch();
    }

    @Test(expected=BatchUpdateException.class)
    public void testCheckedExceptionHandlingOnCallableStatement() throws Exception {
        CallableStatement statementMock = (CallableStatement)Mockito.mock(CallableStatement.class);
        Mockito.when((Object)statementMock.executeBatch()).thenThrow(new Class[]{BatchUpdateException.class});
        CallableStatement statement = TrackingStatementFactory.createTrackingCallableStatement((CanUntrackStatement)this.canUntrackStatementMock, (CallableStatement)statementMock);
        statement.executeBatch();
    }
}

