/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.SessionState;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SessionStateTest {
    @Mock
    Session session;
    @Mock
    Transaction tx;

    @Test
    public void testCommitRollback() throws Exception {
        SessionState ss = new SessionState(this.session);
        Mockito.when((Object)this.session.beginTransaction()).thenReturn((Object)this.tx);
        HibernateException hibernateException = new HibernateException("test commiting error");
        ((Transaction)Mockito.doThrow((Throwable)hibernateException).when((Object)this.tx)).commit();
        ss.beginTx();
        HibernateException thrown = null;
        try {
            ss.commitTx();
            Assert.fail((String)"Commit exception not rethrown");
        }
        catch (HibernateException e) {
            thrown = e;
        }
        Assert.assertThat((Object)((Object)thrown), (Matcher)Matchers.sameInstance((Object)((Object)hibernateException)));
        ((Transaction)Mockito.verify((Object)this.tx)).rollback();
    }
}

