/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.SessionDecorator;
import java.io.Serializable;
import java.sql.Connection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.Transaction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SessionDecoratorTest {
    private Session session;
    private SessionDecorator sessionDecorator;

    @Before
    public void setUp() throws Exception {
        this.session = (Session)Mockito.mock(Session.class);
        this.sessionDecorator = new SessionDecorator(this.session);
    }

    @Test
    public void testSessionWithOptions() throws Exception {
        SharedSessionBuilder sharedSessionBuilder = (SharedSessionBuilder)Mockito.mock(SharedSessionBuilder.class);
        Mockito.when((Object)this.session.sessionWithOptions()).thenReturn((Object)sharedSessionBuilder);
        SharedSessionBuilder result = this.sessionDecorator.sessionWithOptions();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).sessionWithOptions();
        Assert.assertSame((Object)sharedSessionBuilder, (Object)result);
    }

    @Test
    public void testFlush() throws Exception {
        this.sessionDecorator.flush();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void testSetFlushMode() throws Exception {
        FlushMode flushMode = FlushMode.COMMIT;
        this.sessionDecorator.setFlushMode(flushMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).setFlushMode((FlushMode)Matchers.same((Object)flushMode));
    }

    @Test
    public void testGetFlushMode() throws Exception {
        FlushMode mode = FlushMode.ALWAYS;
        Mockito.when((Object)this.session.getFlushMode()).thenReturn((Object)mode);
        FlushMode result = this.sessionDecorator.getFlushMode();
        Assert.assertSame((Object)mode, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getFlushMode();
    }

    @Test
    public void testSetCacheMode() throws Exception {
        CacheMode cacheMode = CacheMode.NORMAL;
        this.sessionDecorator.setCacheMode(cacheMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).setCacheMode((CacheMode)Matchers.same((Object)cacheMode));
    }

    @Test
    public void testGetCacheMode() throws Exception {
        CacheMode cacheMode = CacheMode.IGNORE;
        Mockito.when((Object)this.session.getCacheMode()).thenReturn((Object)cacheMode);
        CacheMode result = this.sessionDecorator.getCacheMode();
        Assert.assertSame((Object)cacheMode, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getCacheMode();
    }

    @Test
    public void testGetSessionFactory() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Mockito.when((Object)this.session.getSessionFactory()).thenReturn((Object)sessionFactory);
        SessionFactory result = this.sessionDecorator.getSessionFactory();
        Assert.assertSame((Object)sessionFactory, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getSessionFactory();
    }

    @Test
    public void testClose() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.session.close()).thenReturn((Object)connection);
        Connection result = this.sessionDecorator.close();
        Assert.assertSame((Object)connection, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCancelQuery() throws Exception {
        this.sessionDecorator.cancelQuery();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).cancelQuery();
    }

    @Test
    public void testIsOpen() throws Exception {
        this.sessionDecorator.isOpen();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).isOpen();
    }

    @Test
    public void testIsConnected() throws Exception {
        this.sessionDecorator.isConnected();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).isConnected();
    }

    @Test
    public void testIsDirty() throws Exception {
        this.sessionDecorator.isDirty();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).isDirty();
    }

    @Test
    public void testIsDefaultReadOnly() throws Exception {
        this.sessionDecorator.isDefaultReadOnly();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).isDefaultReadOnly();
    }

    @Test
    public void testSetDefaultReadOnly() throws Exception {
        boolean val = true;
        this.sessionDecorator.setDefaultReadOnly(val);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).setDefaultReadOnly(Matchers.eq((boolean)val));
    }

    @Test
    public void testGetIdentifier() throws Exception {
        Object object = new Object();
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Mockito.when((Object)this.session.getIdentifier(Matchers.same((Object)object))).thenReturn((Object)serializable);
        Serializable result = this.sessionDecorator.getIdentifier(object);
        Assert.assertSame((Object)serializable, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getIdentifier(object);
    }

    @Test
    public void testContains() throws Exception {
        Object object = new Object();
        Mockito.when((Object)this.session.contains(Matchers.same((Object)object))).thenReturn((Object)true);
        boolean result = this.sessionDecorator.contains(object);
        Assert.assertTrue((boolean)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).contains(Matchers.same((Object)object));
    }

    @Test
    public void testEvict() throws Exception {
        Object object = new Object();
        this.sessionDecorator.evict(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).evict(Matchers.same((Object)object));
    }

    @Test
    public void testLoadClassSerializable() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Object object = new Object();
        Mockito.when((Object)this.session.load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testLoadClassSerializableLockMode() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockMode lockMode = LockMode.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testLoadClassSerializableLockOptions() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockOptions lockOptions = LockOptions.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable, lockOptions);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testLoadObjSerializable() throws Exception {
        Object entityObj = new Object();
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        this.sessionDecorator.load(entityObj, serializable);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load(Matchers.same((Object)entityObj), (Serializable)Matchers.same((Object)serializable));
    }

    @Test
    public void testLoadStringSerializable() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Object object = new Object();
        Mockito.when((Object)this.session.load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testLoadStringSerializableLockMode() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockMode lockMode = LockMode.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testLoadStringSerializableLockOptions() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockOptions lockOptions = LockOptions.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions))).thenReturn(object);
        Object result = this.sessionDecorator.load(clazz, serializable, lockOptions);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).load((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testReplicateStringObjMode() throws Exception {
        String clazz = "clazz";
        Object object = new Object();
        ReplicationMode replicationMode = ReplicationMode.IGNORE;
        this.sessionDecorator.replicate(clazz, object, replicationMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).replicate((String)Matchers.same((Object)clazz), Matchers.same((Object)object), (ReplicationMode)Matchers.same((Object)replicationMode));
    }

    @Test
    public void testReplicateObjMode() throws Exception {
        Object object = new Object();
        ReplicationMode replicationMode = ReplicationMode.IGNORE;
        this.sessionDecorator.replicate(object, replicationMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).replicate(Matchers.same((Object)object), (ReplicationMode)Matchers.same((Object)replicationMode));
    }

    @Test
    public void testSave() throws Exception {
        Object object = new Object();
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Mockito.when((Object)this.session.save(Matchers.same((Object)object))).thenReturn((Object)serializable);
        Serializable result = this.sessionDecorator.save(object);
        Assert.assertSame((Object)serializable, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).save(Matchers.same((Object)object));
    }

    @Test
    public void testSaveStringObj() throws Exception {
        String entity = "entity";
        Object object = new Object();
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Mockito.when((Object)this.session.save((String)Matchers.same((Object)entity), Matchers.same((Object)object))).thenReturn((Object)serializable);
        Serializable result = this.sessionDecorator.save(entity, object);
        Assert.assertSame((Object)serializable, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).save((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testSaveOrUpdate() throws Exception {
        Object object = new Object();
        this.sessionDecorator.saveOrUpdate(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).saveOrUpdate(Matchers.same((Object)object));
    }

    @Test
    public void testSaveOrUpdateStringObject() throws Exception {
        String entity = "entity";
        Object object = new Object();
        this.sessionDecorator.saveOrUpdate(entity, object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).saveOrUpdate((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testUpdate() throws Exception {
        Object object = new Object();
        this.sessionDecorator.update(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).update(Matchers.same((Object)object));
    }

    @Test
    public void testUpdateStringObj() throws Exception {
        String entity = "entity";
        Object object = new Object();
        this.sessionDecorator.update(entity, object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).update((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testMerge() throws Exception {
        Object object = new Object();
        this.sessionDecorator.merge(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).merge(Matchers.same((Object)object));
    }

    @Test
    public void testMergeStringObj() throws Exception {
        String entity = "entity";
        Object object = new Object();
        this.sessionDecorator.merge(entity, object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).merge((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testPersist() throws Exception {
        Object object = new Object();
        this.sessionDecorator.persist(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).persist(Matchers.same((Object)object));
    }

    @Test
    public void testPersistStringObj() throws Exception {
        String entity = "entity";
        Object object = new Object();
        this.sessionDecorator.persist(entity, object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).persist((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testDelete() throws Exception {
        Object object = new Object();
        this.sessionDecorator.delete(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).delete(Matchers.same((Object)object));
    }

    @Test
    public void testDeleteStringObj() throws Exception {
        String entity = "entity";
        Object object = new Object();
        this.sessionDecorator.delete(entity, object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).delete((String)Matchers.same((Object)entity), Matchers.same((Object)object));
    }

    @Test
    public void testLockObjectLockMode() throws Exception {
        Object object = new Object();
        LockMode lockMode = LockMode.NONE;
        this.sessionDecorator.lock(object, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).lock(Matchers.same((Object)object), (LockMode)Matchers.same((Object)lockMode));
    }

    @Test
    public void testLockStringObjectLockMode() throws Exception {
        String entity = "entity";
        Object object = new Object();
        LockMode lockMode = LockMode.NONE;
        this.sessionDecorator.lock(entity, object, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).lock((String)Matchers.same((Object)entity), Matchers.same((Object)object), (LockMode)Matchers.same((Object)lockMode));
    }

    @Test
    public void testBuildLockRequest() throws Exception {
        Session.LockRequest lockRequest = (Session.LockRequest)Mockito.mock(Session.LockRequest.class);
        Mockito.when((Object)this.session.buildLockRequest(LockOptions.READ)).thenReturn((Object)lockRequest);
        Session.LockRequest result = this.sessionDecorator.buildLockRequest(LockOptions.READ);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).buildLockRequest(LockOptions.READ);
        Assert.assertSame((Object)lockRequest, (Object)result);
    }

    @Test
    public void testRefreshObj() throws Exception {
        Object object = new Object();
        this.sessionDecorator.refresh(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).refresh(Matchers.same((Object)object));
    }

    @Test
    public void testRefreshEntityNameObj() throws Exception {
        Object object = new Object();
        this.sessionDecorator.refresh("name", object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).refresh((String)Matchers.eq((Object)"name"), Matchers.same((Object)object));
    }

    @Test
    public void testRefreshObjLockMode() throws Exception {
        Object object = new Object();
        LockMode lockMode = LockMode.READ;
        this.sessionDecorator.refresh(object, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).refresh(Matchers.same((Object)object), (LockMode)Matchers.same((Object)lockMode));
    }

    @Test
    public void testRefreshEntityNameObjLockOptions() throws Exception {
        Object object = new Object();
        LockOptions lockOptions = LockOptions.READ;
        this.sessionDecorator.refresh("name", object, lockOptions);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).refresh((String)Matchers.eq((Object)"name"), Matchers.same((Object)object), (LockOptions)Matchers.same((Object)lockOptions));
    }

    @Test
    public void testRefreshObjLockOptions() throws Exception {
        Object object = new Object();
        LockOptions lockOptions = LockOptions.READ;
        this.sessionDecorator.refresh(object, lockOptions);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).refresh(Matchers.same((Object)object), (LockOptions)Matchers.same((Object)lockOptions));
    }

    @Test
    public void testGetCurrentLockMode() throws Exception {
        Object object = new Object();
        Mockito.when((Object)this.session.getCurrentLockMode(Matchers.same((Object)object))).thenReturn((Object)LockMode.NONE);
        LockMode result = this.sessionDecorator.getCurrentLockMode(object);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getCurrentLockMode(Matchers.same((Object)object));
        Assert.assertSame((Object)LockMode.NONE, (Object)result);
    }

    @Test
    public void testGetTenantIdentifier() throws Exception {
        Mockito.when((Object)this.session.getTenantIdentifier()).thenReturn((Object)"id");
        String result = this.sessionDecorator.getTenantIdentifier();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getTenantIdentifier();
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)"id"));
    }

    @Test
    public void testBeginTransaction() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.session.beginTransaction()).thenReturn((Object)transaction);
        Transaction result = this.sessionDecorator.beginTransaction();
        Assert.assertSame((Object)transaction, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).beginTransaction();
    }

    @Test
    public void testGetTransaction() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.session.getTransaction()).thenReturn((Object)transaction);
        Transaction result = this.sessionDecorator.getTransaction();
        Assert.assertSame((Object)transaction, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getTransaction();
    }

    @Test
    public void testCreateCriteriaClass() throws Exception {
        Class<SessionDecoratorTest> entity = SessionDecoratorTest.class;
        Criteria criteria = (Criteria)Mockito.mock(Criteria.class);
        Mockito.when((Object)this.session.createCriteria((Class)Matchers.same(entity))).thenReturn((Object)criteria);
        Criteria result = this.sessionDecorator.createCriteria(entity);
        Assert.assertSame((Object)criteria, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createCriteria((Class)Matchers.same(entity));
    }

    @Test
    public void testCreateCriteriaClassString() throws Exception {
        Class<SessionDecoratorTest> entity = SessionDecoratorTest.class;
        String alias = "alias";
        Criteria criteria = (Criteria)Mockito.mock(Criteria.class);
        Mockito.when((Object)this.session.createCriteria((Class)Matchers.same(entity), (String)Matchers.same((Object)alias))).thenReturn((Object)criteria);
        Criteria result = this.sessionDecorator.createCriteria(entity, alias);
        Assert.assertSame((Object)criteria, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createCriteria((Class)Matchers.same(entity), (String)Matchers.same((Object)alias));
    }

    @Test
    public void testCreateCriteriaString() throws Exception {
        String entity = "entity";
        Criteria criteria = (Criteria)Mockito.mock(Criteria.class);
        Mockito.when((Object)this.session.createCriteria((String)Matchers.same((Object)entity))).thenReturn((Object)criteria);
        Criteria result = this.sessionDecorator.createCriteria(entity);
        Assert.assertSame((Object)criteria, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createCriteria((String)Matchers.same((Object)entity));
    }

    @Test
    public void testCreateCriteriaStringString() throws Exception {
        String entity = "entity";
        String alias = "alias";
        Criteria criteria = (Criteria)Mockito.mock(Criteria.class);
        Mockito.when((Object)this.session.createCriteria((String)Matchers.same((Object)entity), (String)Matchers.same((Object)alias))).thenReturn((Object)criteria);
        Criteria result = this.sessionDecorator.createCriteria(entity, alias);
        Assert.assertSame((Object)criteria, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createCriteria((String)Matchers.same((Object)entity), (String)Matchers.same((Object)alias));
    }

    @Test
    public void testCreateQuery() throws Exception {
        String queryString = "query";
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.session.createQuery((String)Matchers.same((Object)queryString))).thenReturn((Object)query);
        Query result = this.sessionDecorator.createQuery(queryString);
        Assert.assertSame((Object)query, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createQuery((String)Matchers.same((Object)queryString));
    }

    @Test
    public void testCreateSQLQuery() throws Exception {
        String queryString = "query";
        SQLQuery query = (SQLQuery)Mockito.mock(SQLQuery.class);
        Mockito.when((Object)this.session.createSQLQuery((String)Matchers.same((Object)queryString))).thenReturn((Object)query);
        SQLQuery result = this.sessionDecorator.createSQLQuery(queryString);
        Assert.assertSame((Object)query, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createSQLQuery((String)Matchers.same((Object)queryString));
    }

    @Test
    public void testCreateFilter() throws Exception {
        Object collection = new Object();
        String queryString = "query";
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.session.createFilter(Matchers.same((Object)collection), (String)Matchers.same((Object)queryString))).thenReturn((Object)query);
        Query result = this.sessionDecorator.createFilter(collection, queryString);
        Assert.assertSame((Object)query, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).createFilter(Matchers.same((Object)collection), (String)Matchers.same((Object)queryString));
    }

    @Test
    public void testGetNamedQuery() throws Exception {
        String namedQuery = "query";
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.session.getNamedQuery((String)Matchers.same((Object)namedQuery))).thenReturn((Object)query);
        Query result = this.sessionDecorator.getNamedQuery(namedQuery);
        Assert.assertSame((Object)query, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getNamedQuery((String)Matchers.same((Object)namedQuery));
    }

    @Test
    public void testClear() throws Exception {
        this.sessionDecorator.clear();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testGetClassSerializable() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Object object = new Object();
        Mockito.when((Object)this.session.get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable);
        Assert.assertSame((Object)object, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable));
    }

    @Test
    public void testGetClassSerializableLockMode() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockMode lockMode = LockMode.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable, lockMode);
        Assert.assertSame((Object)object, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode));
    }

    @Test
    public void testGetClassSerializableLockOptions() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockOptions lockOptions = LockOptions.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable, lockOptions);
        Assert.assertSame((Object)object, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((Class)Matchers.same(clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions));
    }

    @Test
    public void testGetStringSerializable() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        Object object = new Object();
        Mockito.when((Object)this.session.get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable);
        Assert.assertSame((Object)object, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable));
    }

    @Test
    public void testGetStringSerializableLockOptions() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockOptions lockOptions = LockOptions.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable, lockOptions);
        Assert.assertSame((Object)object, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockOptions)Matchers.same((Object)lockOptions));
    }

    @Test
    public void testGetStringSerializableLockMode() throws Exception {
        String clazz = "clazz";
        Serializable serializable = (Serializable)Mockito.mock(Serializable.class);
        LockMode lockMode = LockMode.NONE;
        Object object = new Object();
        Mockito.when((Object)this.session.get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode))).thenReturn(object);
        Object result = this.sessionDecorator.get(clazz, serializable, lockMode);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).get((String)Matchers.same((Object)clazz), (Serializable)Matchers.same((Object)serializable), (LockMode)Matchers.same((Object)lockMode));
        Assert.assertSame((Object)object, (Object)result);
    }

    @Test
    public void testGetEntityName() throws Exception {
        Object entity = new Object();
        String entityName = "name";
        Mockito.when((Object)this.session.getEntityName(Matchers.same((Object)entity))).thenReturn((Object)entityName);
        String result = this.sessionDecorator.getEntityName(entity);
        Assert.assertSame((Object)entityName, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getEntityName(Matchers.same((Object)entity));
    }

    @Test
    public void testByIdEntityName() throws Exception {
        IdentifierLoadAccess identifierLoadAccess = (IdentifierLoadAccess)Mockito.mock(IdentifierLoadAccess.class);
        Mockito.when((Object)this.session.byId("name")).thenReturn((Object)identifierLoadAccess);
        IdentifierLoadAccess result = this.sessionDecorator.byId("name");
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).byId((String)Matchers.eq((Object)"name"));
        Assert.assertSame((Object)identifierLoadAccess, (Object)result);
    }

    @Test
    public void testByIdEntityClass() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        IdentifierLoadAccess identifierLoadAccess = (IdentifierLoadAccess)Mockito.mock(IdentifierLoadAccess.class);
        Mockito.when((Object)this.session.byId(clazz)).thenReturn((Object)identifierLoadAccess);
        IdentifierLoadAccess result = this.sessionDecorator.byId(clazz);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).byId((Class)Matchers.same(clazz));
        Assert.assertSame((Object)identifierLoadAccess, (Object)result);
    }

    @Test
    public void testByNaturalIdEntityName() throws Exception {
        NaturalIdLoadAccess identifierLoadAccess = (NaturalIdLoadAccess)Mockito.mock(NaturalIdLoadAccess.class);
        Mockito.when((Object)this.session.byNaturalId("name")).thenReturn((Object)identifierLoadAccess);
        NaturalIdLoadAccess result = this.sessionDecorator.byNaturalId("name");
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).byNaturalId((String)Matchers.eq((Object)"name"));
        Assert.assertSame((Object)identifierLoadAccess, (Object)result);
    }

    @Test
    public void testByNaturalIdEntityClass() throws Exception {
        Class<SessionDecoratorTest> clazz = SessionDecoratorTest.class;
        NaturalIdLoadAccess identifierLoadAccess = (NaturalIdLoadAccess)Mockito.mock(NaturalIdLoadAccess.class);
        Mockito.when((Object)this.session.byNaturalId(clazz)).thenReturn((Object)identifierLoadAccess);
        NaturalIdLoadAccess result = this.sessionDecorator.byNaturalId(clazz);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).byNaturalId((Class)Matchers.same(clazz));
        Assert.assertSame((Object)identifierLoadAccess, (Object)result);
    }

    @Test
    public void testEnableFilter() throws Exception {
        String filterName = "filter";
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)this.session.enableFilter((String)Matchers.same((Object)filterName))).thenReturn((Object)filter);
        Filter result = this.sessionDecorator.enableFilter(filterName);
        Assert.assertSame((Object)filter, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).enableFilter((String)Matchers.same((Object)filterName));
    }

    @Test
    public void testGetEnabledFilter() throws Exception {
        String filterName = "filter";
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)this.session.getEnabledFilter((String)Matchers.same((Object)filterName))).thenReturn((Object)filter);
        Filter result = this.sessionDecorator.getEnabledFilter(filterName);
        Assert.assertSame((Object)filter, (Object)result);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).getEnabledFilter((String)Matchers.same((Object)filterName));
    }
}

