/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.OracleDialectUtils;
import org.junit.Assert;
import org.junit.Test;

public class OracleDialectUtilsTest {
    @Test
    public void testClobCompareUsed() {
        Assert.assertEquals((Object)"DBMS_LOB.compare(nvl(foo, '<%cru_null%>'), nvl(:bar, '<%cru_null%>')) = 0", (Object)new OracleDialectUtils().getClobsEqualExpression("foo", ":bar"));
        Assert.assertEquals((Object)"DBMS_LOB.compare(nvl(foo, '<%cru_null%>'), nvl('', '<%cru_null%>')) = 0", (Object)new OracleDialectUtils().getClobsEqualExpression("foo", "''"));
        Assert.assertEquals((Object)"foo is null", (Object)new OracleDialectUtils().getClobsEqualExpression("foo", null));
        Assert.assertEquals((Object)"foo is null", (Object)new OracleDialectUtils().getClobsEqualExpression("foo", "null"));
    }

    @Test(expected=NullPointerException.class)
    public void testNullClobColNameThrowsNPE() {
        new OracleDialectUtils().getClobsEqualExpression(null, "bar");
    }
}

