/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.helpers.MySQLConstraintTransformer;
import com.cenqua.crucible.hibernate.dialects.FeCruMySQL5InnoDBDialect;
import com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MySQLConstraintTransformerTest {
    Configuration cfg = (Configuration)Mockito.mock(Configuration.class);
    Table table = (Table)Mockito.mock(Table.class);
    Column varchar100 = (Column)Mockito.mock(Column.class);
    Column varchar500 = (Column)Mockito.mock(Column.class);
    Column longtext = (Column)Mockito.mock(Column.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.cfg.getTableMappings()).thenReturn((Object)ImmutableList.of((Object)this.table).iterator());
        Mockito.when((Object)this.table.getColumnIterator()).thenReturn((Object)ImmutableList.of((Object)this.varchar100, (Object)this.varchar500, (Object)this.longtext).iterator());
        Mockito.when((Object)this.table.getName()).thenReturn((Object)"table");
        this.stubColumn(this.varchar100, "varchar100", "varchar(100)");
        this.stubColumn(this.varchar500, "varchar500", "varchar(500)");
        this.stubColumn(this.longtext, "longtext", "longtext");
    }

    private void stubColumn(Column column, String name, String type) {
        Mockito.when((Object)column.getName()).thenReturn((Object)name);
        Mockito.when((Object)column.getSqlType((Dialect)Matchers.any(Dialect.class), (Mapping)Matchers.any(Mapping.class))).thenReturn((Object)type);
    }

    @Test
    public void testTransform() throws Exception {
        MySQLConstraintTransformer transformer = new MySQLConstraintTransformer(this.cfg, (Dialect)new FeCruMySQL5InnoDBDialect());
        Assert.assertThat((Object)transformer.apply("create index idx1 on table (varchar100)"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"create index idx1 on table (varchar100)"));
        Assert.assertThat((Object)transformer.apply("create index idx1 on table (varchar500)"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"create index idx1 on table (varchar500(255))"));
        Assert.assertThat((Object)transformer.apply("create index idx1 on table (longtext)"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"create index idx1 on table (longtext(255))"));
        Assert.assertThat((Object)transformer.apply("create index idx1 on table (longtext, varchar100, varchar500)"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"create index idx1 on table (longtext(255), varchar100, varchar500(255))"));
        Assert.assertThat((Object)transformer.apply("create index idx1 on table (longtext(128))"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"create index idx1 on table (longtext(128))"));
    }
}

