/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.fisheye.event.FisheyeEventPublisher;
import com.cenqua.crucible.helpers.TestDbConfigFactory;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.HibernateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.engine.HibernateIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HibernateUtilTest {
    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        HibernateUtil.destroy();
    }

    @Test
    public void testSimpleCleanList() {
        List<Integer> l1 = Arrays.asList(1, 2, 3);
        HibernateUtil.repairList(l1, (HibernateUtil.ListAccessor)new HibernateUtil.ListAccessor<Integer>(){

            public void resetIndexOf(Integer integer, int i) {
                Assert.fail((String)"Shouldn't need to call this");
            }

            public int getIndexOf(Integer integer) {
                return integer;
            }

            public Comparator<? super Integer> getComparator(@Nonnull Integer integers) {
                Assert.fail((String)"Shouldn't need to call this");
                return null;
            }
        });
        Assert.assertEquals((long)3L, (long)l1.size());
    }

    private Y my(int n, int order) {
        return new Y(n, order);
    }

    private X mx(int n) {
        return new X(n);
    }

    private HibernateUtil.ListAccessor<X> xSetter() {
        return new HibernateUtil.ListAccessor<X>(){

            public void resetIndexOf(X x, int i) {
                x.index = i;
            }

            public int getIndexOf(X x) {
                return x.index;
            }

            public Comparator<? super X> getComparator(X x) {
                return (o1, o2) -> o1.index - o2.index;
            }
        };
    }

    private HibernateUtil.ListAccessor<Y> yAccessor() {
        return new HibernateUtil.ListAccessor<Y>(){

            public void resetIndexOf(Y x, int i) {
                x.index = i;
            }

            public int getIndexOf(Y x) {
                return x.index;
            }

            public Comparator<? super Y> getComparator(Y y) {
                return (o1, o2) -> ((Y)o1).order - ((Y)o2).order;
            }
        };
    }

    @Test
    public void testListWithNull() {
        List<X> l1 = this.createList(this.mx(1), null, this.mx(3));
        HibernateUtil.doRemoveNulls(l1, this.xSetter());
        Assert.assertEquals((long)2L, (long)l1.size());
        Assert.assertEquals((long)0L, (long)l1.get((int)0).index);
        Assert.assertEquals((long)1L, (long)l1.get((int)1).index);
    }

    @Test
    public void testListWithNulls() {
        List<X> l1 = this.createList(null, null, this.mx(1), null, this.mx(3), null);
        HibernateUtil.doRemoveNulls(l1, this.xSetter());
        Assert.assertEquals((long)2L, (long)l1.size());
        Assert.assertEquals((long)0L, (long)l1.get((int)0).index);
        Assert.assertEquals((long)1L, (long)l1.get((int)1).index);
    }

    @Test
    public void testHasRepeatedIndices() {
        Assert.assertFalse((boolean)HibernateUtil.hasRepeatedIndices(Collections.emptyList(), this.xSetter()));
        List<X> l1 = this.createList(this.mx(1), this.mx(2), this.mx(3));
        Assert.assertFalse((boolean)HibernateUtil.hasRepeatedIndices(l1, this.xSetter()));
        List<X> l2 = this.createList(this.mx(1), this.mx(2), this.mx(1));
        Assert.assertTrue((boolean)HibernateUtil.hasRepeatedIndices(l2, this.xSetter()));
    }

    @Test
    public void testListWithDuplicates() {
        List<Y> l1 = this.createList(this.my(1, 2), this.my(1, 1), this.my(2, 3));
        HibernateUtil.doReorderRevisions(l1, this.yAccessor());
        this.assertCorrectlyOrdered(l1);
    }

    private void assertCorrectlyOrdered(List<Y> ys) {
        for (int i = 0; i < ys.size(); ++i) {
            Y y = ys.get(i);
            Assert.assertTrue((i == y.index ? 1 : 0) != 0);
            if (i <= 0) continue;
            Assert.assertTrue((y.order > ys.get(i - 1).order ? 1 : 0) != 0);
        }
    }

    private <T> List<T> createList(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    @Test
    public void testDrainingEventQueue() throws Exception {
        HibernateUtil.setUp((DatabaseConfig)TestDbConfigFactory.getHSQLConfig("hibernateUtilTest"));
        HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        FisheyeEventPublisher.EventPublication publication = (FisheyeEventPublisher.EventPublication)Mockito.mock(FisheyeEventPublisher.EventPublication.class);
        boolean enqueued = HibernateUtil.enqueueEvent((FisheyeEventPublisher.EventPublication)publication);
        Iterable firstQueue = HibernateUtil.drainSessionEventQueue();
        Iterable secondQueue = HibernateUtil.drainSessionEventQueue();
        Assert.assertThat((Object)enqueued, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)firstQueue, (Matcher)IsIterableContainingInOrder.contains((Object[])new FisheyeEventPublisher.EventPublication[]{publication}));
        Assert.assertThat((Object)secondQueue, (Matcher)IsEmptyIterable.emptyIterable());
    }

    @Test
    public void testEventsNotQueuedWhenNoTxRunning() throws Exception {
        HibernateUtil.setUp((DatabaseConfig)TestDbConfigFactory.getHSQLConfig("hibernateUtilTest"));
        FisheyeEventPublisher.EventPublication publication = (FisheyeEventPublisher.EventPublication)Mockito.mock(FisheyeEventPublisher.EventPublication.class);
        boolean enqueuedBeforeSession = HibernateUtil.enqueueEvent((FisheyeEventPublisher.EventPublication)publication);
        HibernateUtil.currentSession();
        boolean enqueuedBeforeTx = HibernateUtil.enqueueEvent((FisheyeEventPublisher.EventPublication)publication);
        HibernateUtil.beginTransaction();
        Assert.assertThat((Object)enqueuedBeforeSession, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)enqueuedBeforeTx, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testWithIterator() {
        Query query = (Query)Mockito.mock(Query.class);
        HibernateIterator iterator = (HibernateIterator)Mockito.mock(HibernateIterator.class);
        Mockito.when((Object)query.iterate()).thenReturn((Object)iterator);
        HibernateUtil.withIterator((Query)query, input -> {
            Assert.assertThat((Object)input, (Matcher)Matchers.instanceOf(HibernateIterator.class));
            Assert.assertThat((Object)input, (Matcher)Matchers.sameInstance((Object)iterator));
            return null;
        });
        ((HibernateIterator)Mockito.verify((Object)iterator)).close();
    }

    @Test
    public void testWithIteratorWhenExceptionIsThrown() throws Exception {
        Query query = (Query)Mockito.mock(Query.class);
        HibernateIterator iterator = (HibernateIterator)Mockito.mock(HibernateIterator.class);
        Mockito.when((Object)query.iterate()).thenReturn((Object)iterator);
        try {
            HibernateUtil.withIterator((Query)query, input -> {
                throw new RuntimeException("Test exception");
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((HibernateIterator)Mockito.verify((Object)iterator)).close();
    }

    @Test
    public void testClosingSession() throws Exception {
        HibernateUtil.setUp((DatabaseConfig)TestDbConfigFactory.getHSQLConfig("hibernateUtilTest"));
        Session closedSession = HibernateUtil.currentSession();
        closedSession.close();
        Session newSession = HibernateUtil.currentSession();
        Assert.assertTrue((String)"Returned session must not be closed", (boolean)newSession.isOpen());
        Assert.assertNotSame((String)"Returned session should be different than closed one", (Object)closedSession, (Object)newSession);
    }

    private static class Y {
        private int index;
        private final int order;

        private Y(int index, int order) {
            this.index = index;
            this.order = order;
        }
    }

    private static class X {
        public int index;

        private X(int index) {
            this.index = index;
        }
    }
}

