/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DialectUtils;
import org.junit.Assert;
import org.junit.Test;

public class DialectUtilsTest {
    @Test
    public void testClobEqualityChecked() {
        Assert.assertEquals((Object)"foo = :bar", (Object)new DialectUtils().getClobsEqualExpression("foo", ":bar"));
        Assert.assertEquals((Object)"foo = ''", (Object)new DialectUtils().getClobsEqualExpression("foo", "''"));
        Assert.assertEquals((Object)"foo is null", (Object)new DialectUtils().getClobsEqualExpression("foo", null));
        Assert.assertEquals((Object)"foo is null", (Object)new DialectUtils().getClobsEqualExpression("foo", "null"));
    }

    @Test(expected=NullPointerException.class)
    public void testNullClobColNameThrowsNPE() {
        new DialectUtils().getClobsEqualExpression(null, "bar");
    }
}

