/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DatabaseConfigDBControlConnectionProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDBControlTest {
    @Test
    public void testJdbcUrlStripSocketTimeoutParam() throws Exception {
        Assert.assertThat((String)"JDBC intact when no socketTimeout specified (simple URL)", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible"));
        Assert.assertThat((String)"JDBC intact when no socketTimeout specified (complex URL)", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?useUnicode=true&characterEncoding=UTF-8&connectTimeout=5000&zeroDateTimeBehavior=convertToNull&useTimezone=true&serverTimezone=Europe/Moscow&rewriteBatchedStatements=true"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?useUnicode=true&characterEncoding=UTF-8&connectTimeout=5000&zeroDateTimeBehavior=convertToNull&useTimezone=true&serverTimezone=Europe/Moscow&rewriteBatchedStatements=true"));
        Assert.assertThat((String)"socketTimeout stripped out from every position, even when appears more than once", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?socketTimeout=12&a=b&socketTimeout=21&c=d&socketTimeout=55"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?a=b&c=d"));
        Assert.assertThat((String)"socketTimeout intact when set to 0 (infinity)", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?socketTimeout=0"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?socketTimeout=0"));
        Assert.assertThat((String)"socketTimeout stripped out from complex URL", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost/crucible?useUnicode=true&characterEncoding=UTF-8&connectTimeout=5000&socketTimeout=60000&zeroDateTimeBehavior=convertToNull&useTimezone=true&serverTimezone=Europe/Moscow&rewriteBatchedStatements=true"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost/crucible?useUnicode=true&characterEncoding=UTF-8&connectTimeout=5000&zeroDateTimeBehavior=convertToNull&useTimezone=true&serverTimezone=Europe/Moscow&rewriteBatchedStatements=true"));
        Assert.assertThat((String)"question mark removed when socketTimeout is the only parameter", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?socketTimeout=32"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible"));
        Assert.assertThat((String)"question mark not removed when socketTimeout is the first parameter followed by others", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?socketTimeout=32&p=v"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?p=v"));
        Assert.assertThat((String)"question mark used as parameter value not removed (socketTimeout stripped)", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?socketTimeout=32&P=V&paramWithAmpInValue=really?"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?P=V&paramWithAmpInValue=really?"));
        Assert.assertThat((String)"question mark used as parameter value not removed", (Object)DatabaseConfigDBControlConnectionProvider.JdbcUrlMangler.STRIP_SOCKET_TIMEOUT.apply("jdbc:mysql://localhost:3306/crucible?p=?"), (Matcher)Matchers.equalTo((Object)"jdbc:mysql://localhost:3306/crucible?p=?"));
    }
}

