/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.config1.DriverSource;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatabaseConfigTest {
    DatabaseConfig mainConfig;

    @Before
    public void setUp() throws Exception {
        this.mainConfig = new DatabaseConfig(DBType.ORACLE, "testJdbcUrl", "testUsername", "testPassword", DriverSource.Enum.forInt((int)1), 20, 30);
    }

    @Test
    public void testStealConnections() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(5, 30);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(3);
        Assert.assertThat((String)"all 3 connections stolen", (Object)stolenConfig, (Matcher)PoolSizeMatcher.poolSizesOf(3, 3));
        Assert.assertThat((String)"all 3 connections stolen from main config", (Object)mainConfig, (Matcher)PoolSizeMatcher.maxPoolSizeOf(27));
        Assert.assertThat((String)"min pool should not be reduced", (Object)mainConfig, (Matcher)PoolSizeMatcher.minPoolSizeOf(5));
        this.assertDatabaseConfigsEqualExceptPoolSizes(mainConfig, stolenConfig);
    }

    @Test
    public void testStealConnectionsMoreThanHalf() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(2, 5);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(3);
        Assert.assertThat((String)"less connections stolen than requested", (Object)stolenConfig, (Matcher)PoolSizeMatcher.poolSizesOf(1, 1));
        Assert.assertThat((String)"not stealing all connections as not enough would stay", (Object)mainConfig, (Matcher)PoolSizeMatcher.maxPoolSizeOf(4));
        Assert.assertThat((String)"min pool should not be reduced", (Object)mainConfig, (Matcher)PoolSizeMatcher.minPoolSizeOf(2));
        this.assertDatabaseConfigsEqualExceptPoolSizes(mainConfig, stolenConfig);
    }

    @Test
    public void testStealConnectionsMoreThanHalfMinReduced() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(5, 5);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(3);
        Assert.assertThat((String)"less connections stolen than requested", (Object)stolenConfig, (Matcher)PoolSizeMatcher.poolSizesOf(1, 1));
        Assert.assertThat((String)"not stealing all connections as not enough would stay", (Object)mainConfig, (Matcher)PoolSizeMatcher.maxPoolSizeOf(4));
        Assert.assertThat((String)"min pool size should be reduced", (Object)mainConfig, (Matcher)PoolSizeMatcher.minPoolSizeOf(4));
        this.assertDatabaseConfigsEqualExceptPoolSizes(mainConfig, stolenConfig);
    }

    private DatabaseConfig makeDbConfig(int minPoolSize, int maxPoolSize) {
        return new DatabaseConfig(DBType.ORACLE, "testJDBCUrl", "testUsername", "testPassword", DriverSource.Enum.forInt((int)0), minPoolSize, maxPoolSize);
    }

    @Test
    public void testStealConnectionsStealingAll() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(2, 2);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(3);
        Assert.assertThat((String)"less connections stolen than requested", (Object)stolenConfig, (Matcher)PoolSizeMatcher.poolSizesOf(1, 1));
        Assert.assertThat((String)"not stealing all connections as not enough would stay", (Object)mainConfig, (Matcher)PoolSizeMatcher.maxPoolSizeOf(1));
        Assert.assertThat((String)"min pool should not be reduced", (Object)mainConfig, (Matcher)PoolSizeMatcher.minPoolSizeOf(1));
        this.assertDatabaseConfigsEqualExceptPoolSizes(mainConfig, stolenConfig);
    }

    @Test(expected=IllegalStateException.class)
    public void testStealConnectionsNothingToStealFrom() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(1, 1);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(3);
        Assert.fail((String)("Expected exception, can't steal even single connection from the pool. Got " + stolenConfig));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStealConnectionsStealingNothing() throws Exception {
        DatabaseConfig mainConfig = this.makeDbConfig(1, 1);
        DatabaseConfig stolenConfig = mainConfig.stealConnections(0);
        Assert.fail((String)("Expected exception, got " + stolenConfig));
    }

    private void assertDatabaseConfigsEqualExceptPoolSizes(DatabaseConfig mainConfig, DatabaseConfig stolenConfig) {
        stolenConfig.setMaxPoolSize(mainConfig.getMaxPoolSize());
        stolenConfig.setMinPoolSize(mainConfig.getMinPoolSize());
        Assert.assertThat((String)"db config are equal except pool sizes", (Object)stolenConfig, (Matcher)Matchers.equalTo((Object)mainConfig));
    }

    private static class PoolSizeMatcher
    extends TypeSafeMatcher<DatabaseConfig> {
        private final Matcher<Integer> minMatcher;
        private final Matcher<Integer> maxMatcher;

        private PoolSizeMatcher(Matcher<Integer> minMatcher, Matcher<Integer> maxMatcher) {
            this.minMatcher = minMatcher;
            this.maxMatcher = maxMatcher;
        }

        protected boolean matchesSafely(DatabaseConfig item) {
            return !(this.minMatcher != null && !this.minMatcher.matches((Object)item.getMinPoolSize()) || this.maxMatcher != null && !this.maxMatcher.matches((Object)item.getMaxPoolSize()));
        }

        static PoolSizeMatcher poolSizesOf(Matcher<Integer> minMatcher, Matcher<Integer> maxMatcher) {
            return new PoolSizeMatcher(minMatcher, maxMatcher);
        }

        static PoolSizeMatcher poolSizesOf(int expectedMin, int expectedMax) {
            return PoolSizeMatcher.poolSizesOf((Matcher<Integer>)Matchers.is((Object)expectedMin), (Matcher<Integer>)Matchers.is((Object)expectedMax));
        }

        static PoolSizeMatcher minPoolSizeOf(int expectedMin) {
            return PoolSizeMatcher.poolSizesOf((Matcher<Integer>)Matchers.is((Object)expectedMin), (Matcher<Integer>)Matchers.any(Integer.class));
        }

        static PoolSizeMatcher maxPoolSizeOf(int expectedMax) {
            return PoolSizeMatcher.poolSizesOf((Matcher<Integer>)Matchers.any(Integer.class), (Matcher<Integer>)Matchers.is((Object)expectedMax));
        }

        public void describeTo(Description description) {
            description.appendText("a config with (min,max) connection pool settings of (");
            this.minMatcher.describeTo(description);
            description.appendText(", ");
            this.maxMatcher.describeTo(description);
            description.appendText(")");
        }
    }
}

