/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DBTypeTest {
    @Test
    public void sqlServerBinCollationDetected() throws SQLException {
        Assert.assertTrue((boolean)DBType.isSqlServerCollationCaseSensitive((Connection)this.mockConnection("SQL_Latin1_General_BIN")));
    }

    @Test
    public void sqlServerBin2CollationDetected() throws SQLException {
        Assert.assertTrue((boolean)DBType.isSqlServerCollationCaseSensitive((Connection)this.mockConnection("SQL_Latin1_General_BIN2")));
    }

    @Test
    public void sqlServerCaseSensitiveCollationDetected() throws SQLException {
        Assert.assertTrue((boolean)DBType.isSqlServerCollationCaseSensitive((Connection)this.mockConnection("SQL_Latin1_General_CS_AS")));
    }

    @Test
    public void sqlServerCaseInsensitiveCollationDetected() throws SQLException {
        Assert.assertFalse((boolean)DBType.isSqlServerCollationCaseSensitive((Connection)this.mockConnection("SQL_Latin1_General_CI_AI")));
        Assert.assertFalse((boolean)DBType.isSqlServerCollationCaseSensitive((Connection)this.mockConnection("SQL_Latin1_General_CI_AS")));
    }

    @Test
    public void testIsReadCommittedSnapshotOn() throws Exception {
        Assert.assertTrue((boolean)DBType.isReadCommittedSnapshotOn((Connection)this.mockConnection("1")));
        Assert.assertFalse((boolean)DBType.isReadCommittedSnapshotOn((Connection)this.mockConnection("0")));
    }

    private Connection mockConnection(String result) throws SQLException {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement mockPrepStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockConnection.prepareStatement(Mockito.anyString())).thenReturn((Object)mockPrepStatement);
        Mockito.when((Object)mockPrepStatement.executeQuery()).thenReturn((Object)mockResultSet);
        Mockito.when((Object)mockResultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)mockResultSet.getString(1)).thenReturn((Object)result);
        return mockConnection;
    }
}

