/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DBControlTest {
    private DBControl dbControl;
    private volatile boolean gotTx = false;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadWebOnlySanity(false);
        TestFishEyeInstances.getDBControlFactory().setCurrentControl(null);
        this.dbControl = TestFishEyeInstances.getDBControlFactory().getCurrentControl();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dbControl.getInfo().state() == DBInfo.DBState.STARTED) {
            this.dbControl.stop();
        }
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
    }

    @Test
    public void testUnexpectedDatabaseVersion() throws Exception {
        this.dbControl.start();
        this.updateVersion(DbVersion.getDatabaseVersion() + 1);
        this.dbControl.stop();
        TestFishEyeInstances.getDBControlFactory().setCurrentControl(null);
        this.dbControl = TestFishEyeInstances.getDBControlFactory().getCurrentControl();
        try {
            this.dbControl.start();
            junit.framework.Assert.fail((String)"should throw IllegalStateException");
        }
        catch (CruDBException e) {
            e.printStackTrace(System.err);
            junit.framework.Assert.fail((String)"should not throw CruDBException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            this.updateVersion(DbVersion.getDatabaseVersion());
            TestFishEyeInstances.getDBControlFactory().setCurrentControl(null);
            this.dbControl = TestFishEyeInstances.getDBControlFactory().getCurrentControl();
            this.dbControl.start();
        }
    }

    private void updateVersion(int newVersion) throws CruDBException, SQLException {
        Statement update = this.dbControl.getConnection().createStatement();
        update.execute(String.format("UPDATE cru_version SET cru_version=%d WHERE cru_version_id=%d;", newVersion, 1));
        Statement versionCheck = this.dbControl.getConnection().createStatement();
        versionCheck.execute(String.format("SELECT cru_version FROM cru_version WHERE cru_version_id=%d", 1));
        ResultSet resultSet = versionCheck.getResultSet();
        junit.framework.Assert.assertTrue((boolean)resultSet.next());
        junit.framework.Assert.assertEquals((int)newVersion, (int)resultSet.getInt("cru_version"));
    }

    @Test
    public void testStartStop() throws CruDBException {
        this.dbControl.start();
        junit.framework.Assert.assertTrue((this.dbControl.getInfo().state() == DBInfo.DBState.STARTED ? 1 : 0) != 0);
        try {
            this.dbControl.start();
            junit.framework.Assert.fail((String)"No IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.dbControl.stop();
        junit.framework.Assert.assertTrue((this.dbControl.getInfo().state() == DBInfo.DBState.STOPPED ? 1 : 0) != 0);
        try {
            this.dbControl.stop();
        }
        catch (IllegalStateException e) {
            junit.framework.Assert.fail((String)"IllegalStateException shouldn't happen");
        }
    }

    @Test
    public void testReadOnly() throws Exception {
        this.dbControl.start();
        junit.framework.Assert.assertTrue((this.dbControl.getInfo().state() == DBInfo.DBState.STARTED ? 1 : 0) != 0);
        this.dbControl.readOnly(true);
        junit.framework.Assert.assertTrue((this.dbControl.getInfo().state() == DBInfo.DBState.READ_ONLY ? 1 : 0) != 0);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HibernateUtil.beginTransaction();
                DBControlTest.this.gotTx = true;
                HibernateUtil.commitTransaction();
                HibernateUtil.closeSession();
            }
        });
        t.start();
        this.sleep(500);
        Assert.assertThat((String)"inner thread didn't got transaction while db in read only mode", (Object)this.gotTx, (Matcher)Matchers.equalTo((Object)Boolean.FALSE));
        this.dbControl.readOnly(false);
        t.join(1000L);
        Assert.assertThat((String)"inner thread completed in time", (Object)t.isAlive(), (Matcher)Matchers.equalTo((Object)Boolean.FALSE));
        Assert.assertThat((String)"inner thread got transaction once read only mode disabled", (Object)this.gotTx, (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        this.dbControl.stop();
    }

    private void sleep(int ms) {
        long wait;
        long timeout = System.currentTimeMillis() + (long)ms;
        while ((wait = timeout - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                System.out.println("Sleep interrupted");
            }
        }
    }
}

