/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserTestRule;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.EmptyHibernateListener;
import com.cenqua.crucible.hibernate.HibernateListener;
import com.cenqua.crucible.hibernate.HibernateListenerInterceptor;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-crowd.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class CrowdAwareUserLoadListenerTest {
    @Autowired
    @Rule
    public UserTestRule userTestRule;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    CurrentSessionProvider sessionProvider;
    @Autowired
    TxTemplate txTemplate;
    @Autowired
    CrowdService crowdService;

    @Test
    @DirtiesContext
    @Transactional
    public void shouldntTriggerLoadWhenGettingId() throws Exception {
        List<Integer> ids = this.userTestRule.addUsersAndFlush(new FecruUser("tom"));
        this.userTestRule.setupFecruUserListener(username -> {
            throw new AssertionError((Object)"Shouldn't trigger loading");
        });
        Integer userId = ids.get(0);
        UserProfile tom = (UserProfile)this.sessionProvider.currentSession().createCriteria(UserProfile.class).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId)).uniqueResult();
        Integer id = tom.getUser().getId();
        Assert.assertThat((Object)id, (Matcher)Matchers.equalTo((Object)userId));
    }

    @Test
    @DirtiesContext
    public void shouldntCrashWhenAListenerTriggersLoadUserAgain() throws Exception {
        List<Integer> ids = this.userTestRule.addUsersAndFlush(new FecruUser("tom"));
        Integer userId = ids.get(0);
        this.userTestRule.setupFecruUserListener(this.crowdService);
        Session session = this.sessionWithInterceptor((HibernateListener)new EmptyHibernateListener(){

            public void onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
                if (entity instanceof FecruUser && !((FecruUser)entity).isCrowdBacked()) {
                    ((FecruUser)entity).setBackingCrowdUser(CrowdAwareUserLoadListenerTest.this.crowdService.getUser("tom"));
                }
            }
        });
        this.txTemplate.execute(callback -> {
            FecruUser fecruUser = (FecruUser)session.createCriteria(FecruUser.class).add((Criterion)Restrictions.eq((String)"username", (Object)"tom")).uniqueResult();
            Assert.assertThat((Object)fecruUser.getId(), (Matcher)Matchers.equalTo((Object)userId));
            return null;
        });
    }

    private Session sessionWithInterceptor(HibernateListener listener) {
        return this.sessionFactory.withOptions().interceptor((Interceptor)new HibernateListenerInterceptor((Collection)ImmutableList.of((Object)listener))).openSession();
    }
}

