/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.dbutils.Util;
import com.cenqua.dbutils.comparison.DbComparator;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.sql.Connection;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ConfigTest {
    private File dbdir;
    private String data = "INSERT INTO COMMENT VALUES(1,'2006-11-13 12:13:23.988000000','This is a defect in review 1',FALSE,FALSE,TRUE,TRUE,8,1);\nINSERT INTO COMMENT VALUES(2,'2006-11-13 12:13:46.500000000','Another defect in review 1',FALSE,FALSE,TRUE,TRUE,8,2);\nINSERT INTO COMMENT VALUES(3,'2006-11-13 12:15:05.113000000','A defect in review 2',FALSE,FALSE,TRUE,TRUE,8,3);\nINSERT INTO COMMENT_FIELD VALUES(1,1,0);\nINSERT INTO COMMENT_FIELD VALUES(1,2,1);\nINSERT INTO COMMENT_FIELD VALUES(2,3,0);\nINSERT INTO COMMENT_FIELD VALUES(2,4,1);\nINSERT INTO COMMENT_FIELD VALUES(3,9,0);\nINSERT INTO COMMENT_FIELD VALUES(3,10,1);\nINSERT INTO DEFECT VALUES(1,'2006-11-13 12:13:55.111000000','This is a defect in review 1','This is a defect in review 1',0,0,1,3);\nINSERT INTO DEFECT VALUES(2,'2006-11-13 12:13:55.119000000','Another defect in review 1','Another defect in review 1',1,0,1,4);\nINSERT INTO DEFECT VALUES(3,'2006-11-13 12:15:10.187000000','A defect in review 2','A defect in review 2',0,0,2,5);\nINSERT INTO DEFECT_FIELD VALUES(1,5,0);\nINSERT INTO DEFECT_FIELD VALUES(1,6,1);\nINSERT INTO DEFECT_FIELD VALUES(2,7,0);\nINSERT INTO DEFECT_FIELD VALUES(2,8,1);\nINSERT INTO DEFECT_FIELD VALUES(3,11,0);\nINSERT INTO DEFECT_FIELD VALUES(3,12,1);\nINSERT INTO FIELD VALUES(1,1,'comment','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(2,1,'comment','classification',NULL,4,NULL,NULL);\nINSERT INTO FIELD VALUES(3,1,'comment','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(4,1,'comment','classification',NULL,7,NULL,NULL);\nINSERT INTO FIELD VALUES(5,1,'defect','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(6,1,'defect','classification',NULL,4,NULL,NULL);\nINSERT INTO FIELD VALUES(7,1,'defect','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(8,1,'defect','classification',NULL,7,NULL,NULL);\nINSERT INTO FIELD VALUES(9,1,'comment','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(10,1,'comment','classification',NULL,8,NULL,NULL);\nINSERT INTO FIELD VALUES(11,1,'defect','rank',NULL,NULL,TRUE,NULL);\nINSERT INTO FIELD VALUES(12,1,'defect','classification',NULL,8,NULL,NULL);\nINSERT INTO FR_EXTRA VALUES(1,'2006-11-13 12:11:50.090000000',0,0,0,1,1,2,0);\nINSERT INTO FR_EXTRA VALUES(2,'2006-11-13 12:11:50.418000000',0,0,0,3,1,4,1);\nINSERT INTO FR_EXTRA VALUES(3,'2006-11-13 12:11:50.541000000',0,0,0,5,1,6,2);\nINSERT INTO FR_EXTRA VALUES(4,'2006-11-13 12:11:50.677000000',0,0,0,7,1,8,3);\nINSERT INTO FR_EXTRA VALUES(5,'2006-11-13 12:14:27.278000000',0,0,0,9,2,10,0);\nINSERT INTO FR_EXTRA VALUES(6,'2006-11-13 12:14:29.603000000',0,0,0,11,2,12,1);\nINSERT INTO FR_EXTRA VALUES(7,'2006-11-13 12:16:10.363000000',-1,0,0,1,3,2,0);\nINSERT INTO FR_EXTRA VALUES(8,'2006-11-13 12:17:00.213000000',-1,0,0,3,4,4,0);\nINSERT INTO FR_EXTRA VALUES(9,'2006-11-13 12:17:31.332000000',-1,0,0,9,5,10,0);\nINSERT INTO FR_EXTRA VALUES(10,'2006-11-13 12:17:31.857000000',-1,0,0,11,5,12,1);\nINSERT INTO LOGITEM VALUES(1,'2006-11-13 12:10:57.080000000','Review-null:  created.');\nINSERT INTO LOGITEM VALUES(2,'2006-11-13 12:11:31.273000000','Peter McNeil altering CR-1 changing title to \"review 1\"');\nINSERT INTO LOGITEM VALUES(3,'2006-11-13 12:11:31.273000000','Peter McNeil altering CR-1 changing description to \"create a defect\"');\nINSERT INTO LOGITEM VALUES(4,'2006-11-13 12:11:50.110000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/FileRevision.java r8287 to CR-1');\nINSERT INTO LOGITEM VALUES(5,'2006-11-13 12:11:50.420000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/grouping/PathGroup.java r8287 to CR-1');\nINSERT INTO LOGITEM VALUES(6,'2006-11-13 12:11:50.542000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/managers/FileRevisionManager.java r8287 to CR-1');\nINSERT INTO LOGITEM VALUES(7,'2006-11-13 12:11:50.678000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/util/ReviewCreationHelper.java r8287 to CR-1');\nINSERT INTO LOGITEM VALUES(8,'2006-11-13 12:11:54.413000000','CR-1: review 1, user Peter McNeil, did Approve. Changed to state: Review');\nINSERT INTO LOGITEM VALUES(9,'2006-11-13 12:13:23.990000000','CR-1: pmcneil added comment 1');\nINSERT INTO LOGITEM VALUES(10,'2006-11-13 12:13:46.501000000','CR-1: pmcneil added comment 2');\nINSERT INTO LOGITEM VALUES(11,'2006-11-13 12:13:54.888000000','CR-1: review 1, user Peter McNeil, did Summarize. Changed to state: Summarize');\nINSERT INTO LOGITEM VALUES(12,'2006-11-13 12:14:04.275000000','CR-1: review 1, user Peter McNeil, did Close. Changed to state: Closed');\nINSERT INTO LOGITEM VALUES(13,'2006-11-13 12:14:05.769000000','Review-null:  created.');\nINSERT INTO LOGITEM VALUES(14,'2006-11-13 12:14:17.371000000','Peter McNeil altering CR-2 changing title to \"review 2\"');\nINSERT INTO LOGITEM VALUES(15,'2006-11-13 12:14:17.372000000','Peter McNeil altering CR-2 changing description to \"create another defect\"');\nINSERT INTO LOGITEM VALUES(16,'2006-11-13 12:14:27.283000000','Peter McNeil adding revision trunk/src/content-cru/WEB-INF/jsp/crucible/review/monolithic/viewreview-group.jspf r8284 to CR-2');\nINSERT INTO LOGITEM VALUES(17,'2006-11-13 12:14:29.605000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/FileRevisionExtraInfo.java r8284 to CR-2');\nINSERT INTO LOGITEM VALUES(18,'2006-11-13 12:14:32.110000000','CR-2: review 2, user Peter McNeil, did Approve. Changed to state: Review');\nINSERT INTO LOGITEM VALUES(19,'2006-11-13 12:15:05.113000000','CR-2: pmcneil added comment 3');\nINSERT INTO LOGITEM VALUES(20,'2006-11-13 12:15:10.157000000','CR-2: review 2, user Peter McNeil, did Summarize. Changed to state: Summarize');\nINSERT INTO LOGITEM VALUES(21,'2006-11-13 12:15:16.514000000','CR-2: review 2, user Peter McNeil, did Close. Changed to state: Closed');\nINSERT INTO LOGITEM VALUES(22,'2006-11-13 12:15:22.181000000','Review-null:  created.');\nINSERT INTO LOGITEM VALUES(23,'2006-11-13 12:15:56.401000000','Peter McNeil altering CR-3 changing title to \"re-review of CR1 defect 1\"');\nINSERT INTO LOGITEM VALUES(24,'2006-11-13 12:15:56.423000000','Peter McNeil altering CR-3 adding input defect 1');\nINSERT INTO LOGITEM VALUES(25,'2006-11-13 12:16:10.366000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/FileRevision.java r8287 to CR-3');\nINSERT INTO LOGITEM VALUES(26,'2006-11-13 12:16:14.391000000','CR-3: re-review of CR1 defect 1, user Peter McNeil, did Approve. Changed to state: Review');\nINSERT INTO LOGITEM VALUES(27,'2006-11-13 12:16:17.462000000','Review-null:  created.');\nINSERT INTO LOGITEM VALUES(28,'2006-11-13 12:16:51.760000000','Peter McNeil altering CR-4 changing title to \"re-review of CR-1 DF-2\"');\nINSERT INTO LOGITEM VALUES(29,'2006-11-13 12:16:51.777000000','Peter McNeil altering CR-4 adding input defect 2');\nINSERT INTO LOGITEM VALUES(30,'2006-11-13 12:17:00.215000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/grouping/PathGroup.java r8287 to CR-4');\nINSERT INTO LOGITEM VALUES(31,'2006-11-13 12:17:02.294000000','CR-4: re-review of CR-1 DF-2, user Peter McNeil, did Approve. Changed to state: Review');\nINSERT INTO LOGITEM VALUES(32,'2006-11-13 12:17:04.754000000','Review-null:  created.');\nINSERT INTO LOGITEM VALUES(33,'2006-11-13 12:17:16.323000000','Peter McNeil altering CR-5 changing title to \"re-review of CR-2\"');\nINSERT INTO LOGITEM VALUES(34,'2006-11-13 12:17:25.238000000','Peter McNeil altering CR-5 changing title to \"re-review of CR-2 DF-3\"');\nINSERT INTO LOGITEM VALUES(35,'2006-11-13 12:17:25.250000000','Peter McNeil altering CR-5 adding input defect 3');\nINSERT INTO LOGITEM VALUES(36,'2006-11-13 12:17:31.335000000','Peter McNeil adding revision trunk/src/content-cru/WEB-INF/jsp/crucible/review/monolithic/viewreview-group.jspf r8284 to CR-5');\nINSERT INTO LOGITEM VALUES(37,'2006-11-13 12:17:31.859000000','Peter McNeil adding revision trunk/src/crucible/com/cenqua/crucible/model/FileRevisionExtraInfo.java r8284 to CR-5');\nINSERT INTO LOGITEM VALUES(38,'2006-11-13 12:17:33.860000000','CR-5: re-review of CR-2 DF-3, user Peter McNeil, did Approve. Changed to state: Review');\nINSERT INTO METRIC_DEFINITION VALUES(1,'<metrics version=\"1\" xmlns=\"http://www.cenqua.com/crucible/metrics-1\">\\u000a    <review>\\u000a        <field type=\"STRING\">\\u000a            <name>section</name>\\u000a            <label>Department</label>\\u000a            <restriction type=\"NON_EXCLUSIVE_SET\"/>\\u000a            <namedValue name=\"None\">none</namedValue>\\u000a            <namedValue name=\"Crucible\">crucible</namedValue>\\u000a            <namedValue name=\"Fisheye\">fisheye</namedValue>\\u000a            <namedValue name=\"Clover\">clover</namedValue>\\u000a        </field>\\u000a        <field type=\"STRING\">\\u000a            <name>spec</name>\\u000a            <label>Specification Document (URL)</label>\\u000a        </field>\\u000a        <field type=\"STRING\">\\u000a            <name>uml</name>\\u000a            <label>UML diagram (URL)</label>\\u000a        </field>\\u000a        <field type=\"DATE\">\\u000a            <name>due</name>\\u000a            <label>Due date</label>\\u000a        </field>\\u000a    </review>\\u000a    <comment>\\u000a        <field type=\"INTEGER\">\\u000a            <name>classification</name>\\u000a            <label>Classification</label>\\u000a            <restriction type=\"EXCLUSIVE_SET\"/>\\u000a            <namedValue name=\"Missing\">1</namedValue>\\u000a            <namedValue name=\"Extra (superfluous)\">2</namedValue>\\u000a            <namedValue name=\"Ambiguous\">3</namedValue>\\u000a            <namedValue name=\"Inconsistent\">4</namedValue>\\u000a            <namedValue name=\"Improvement desirable\">5</namedValue>\\u000a            <namedValue name=\"Not conforming to standards\">6</namedValue>\\u000a            <namedValue name=\"Risk-prone\">7</namedValue>\\u000a            <namedValue name=\"Factually incorrect\">8</namedValue>\\u000a            <namedValue name=\"Not implementable\">9</namedValue>\\u000a            <namedValue name=\"Editorial\">10</namedValue>\\u000a            <defaultValue>Improvement desirable</defaultValue>\\u000a        </field>\\u000a        <field type=\"BOOLEAN\">\\u000a            <name>rank</name>\\u000a            <label>Ranking</label>\\u000a            <restriction type=\"EXCLUSIVE_SET\"/>\\u000a            <namedValue name=\"Major\">true</namedValue>\\u000a            <namedValue name=\"Minor\">false</namedValue>\\u000a            <defaultValue>Minor</defaultValue>\\u000a        </field>\\u000a    </comment>\\u000a    <defect>\\u000a        <field type=\"INTEGER\">\\u000a            <name>classification</name>\\u000a            <label>Classification</label>\\u000a            <restriction type=\"EXCLUSIVE_SET\"/>\\u000a            <namedValue name=\"Missing\">1</namedValue>\\u000a            <namedValue name=\"Extra (superfluous)\">2</namedValue>\\u000a            <namedValue name=\"Ambiguous\">3</namedValue>\\u000a            <namedValue name=\"Inconsistent\">4</namedValue>\\u000a            <namedValue name=\"Improvement desirable\">5</namedValue>\\u000a            <namedValue name=\"Not conforming to standards\">6</namedValue>\\u000a            <namedValue name=\"Risk-prone\">7</namedValue>\\u000a            <namedValue name=\"Factually incorrect\">8</namedValue>\\u000a            <namedValue name=\"Not implementable\">9</namedValue>\\u000a            <namedValue name=\"Editorial\">10</namedValue>\\u000a            <defaultValue>Improvement desirable</defaultValue>\\u000a        </field>\\u000a        <field type=\"BOOLEAN\">\\u000a            <name>rank</name>\\u000a            <label>Ranking</label>\\u000a            <restriction type=\"EXCLUSIVE_SET\"/>\\u000a            <namedValue name=\"Major\">true</namedValue>\\u000a            <namedValue name=\"Minor\">false</namedValue>\\u000a            <defaultValue>Minor</defaultValue>\\u000a        </field>\\u000a    </defect>\\u000a\\u000a</metrics>');\nINSERT INTO NOTIFICATION VALUES(1,'1','2006-11-13 12:11:54.409000000',8,'Review',1,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(2,'5','2006-11-13 12:13:24.075000000',8,NULL,1,1,NULL);\nINSERT INTO NOTIFICATION VALUES(3,'5','2006-11-13 12:13:46.566000000',8,NULL,1,2,NULL);\nINSERT INTO NOTIFICATION VALUES(4,'1','2006-11-13 12:13:54.887000000',8,'Summarize',1,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(5,'1','2006-11-13 12:14:04.273000000',8,'Closed',1,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(6,'1','2006-11-13 12:14:32.108000000',8,'Review',2,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(7,'5','2006-11-13 12:15:05.125000000',8,NULL,2,3,NULL);\nINSERT INTO NOTIFICATION VALUES(8,'1','2006-11-13 12:15:10.156000000',8,'Summarize',2,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(9,'1','2006-11-13 12:15:16.506000000',8,'Closed',2,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(10,'1','2006-11-13 12:16:14.386000000',8,'Review',3,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(11,'1','2006-11-13 12:17:02.293000000',8,'Review',4,NULL,NULL);\nINSERT INTO NOTIFICATION VALUES(12,'1','2006-11-13 12:17:33.858000000',8,'Review',5,NULL,NULL);\nINSERT INTO REVIEW VALUES(1,'review 1','cenq','Closed','create a defect',NULL,'2006-11-13 12:10:57.076000000',1,8);\nINSERT INTO REVIEW VALUES(2,'review 2','cenq','Closed','create another defect',NULL,'2006-11-13 12:14:05.769000000',1,8);\nINSERT INTO REVIEW VALUES(3,'re-review of CR1 defect 1','cenq','Review','',NULL,'2006-11-13 12:15:22.180000000',1,8);\nINSERT INTO REVIEW VALUES(4,'re-review of CR-1 DF-2','cenq','Review','',NULL,'2006-11-13 12:16:17.462000000',1,8);\nINSERT INTO REVIEW VALUES(5,'re-review of CR-2 DF-3','cenq','Review','',NULL,'2006-11-13 12:17:04.754000000',1,8);\nINSERT INTO REVIEW_PARTICIPANT VALUES(1,1,8,TRUE,TRUE,FALSE,FALSE,NULL);\nINSERT INTO REVIEW_PARTICIPANT VALUES(2,2,8,TRUE,TRUE,FALSE,FALSE,NULL);\nINSERT INTO REVIEW_PARTICIPANT VALUES(3,3,8,TRUE,TRUE,FALSE,FALSE,NULL);\nINSERT INTO REVIEW_PARTICIPANT VALUES(4,4,8,TRUE,TRUE,FALSE,FALSE,NULL);\nINSERT INTO REVIEW_PARTICIPANT VALUES(5,5,8,TRUE,TRUE,FALSE,FALSE,NULL);\nINSERT INTO REVISION VALUES(1,'2006-03-17 18:17:19.630000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/FileRevision.java','8287','unset');\nINSERT INTO REVISION VALUES(2,'2006-03-03 15:25:12.824000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/FileRevision.java','8142','unset');\nINSERT INTO REVISION VALUES(3,'2006-03-17 18:17:19.630000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/grouping/PathGroup.java','8287','unset');\nINSERT INTO REVISION VALUES(4,'2006-03-16 15:45:37.921000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/grouping/PathGroup.java','8284','unset');\nINSERT INTO REVISION VALUES(5,'2006-03-17 18:17:19.630000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/managers/FileRevisionManager.java','8287','unset');\nINSERT INTO REVISION VALUES(6,'2006-03-01 13:16:40.526000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/managers/FileRevisionManager.java','8105','unset');\nINSERT INTO REVISION VALUES(7,'2006-03-17 18:17:19.630000000','cenq','trunk/src/crucible/com/cenqua/crucible/util/ReviewCreationHelper.java','8287','unset');\nINSERT INTO REVISION VALUES(8,'2006-03-16 15:45:37.921000000','cenq','trunk/src/crucible/com/cenqua/crucible/util/ReviewCreationHelper.java','8284','unset');\nINSERT INTO REVISION VALUES(9,'2006-03-16 15:45:37.921000000','cenq','trunk/src/content-cru/WEB-INF/jsp/crucible/review/monolithic/viewreview-group.jspf','8284','unset');\nINSERT INTO REVISION VALUES(10,'2006-03-13 09:50:47.388000000','cenq','trunk/src/content-cru/WEB-INF/jsp/crucible/review/monolithic/viewreview-group.jspf','8239','unset');\nINSERT INTO REVISION VALUES(11,'2006-03-16 15:45:37.921000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/FileRevisionExtraInfo.java','8284','unset');\nINSERT INTO REVISION VALUES(12,'2006-02-28 12:54:08.385000000','cenq','trunk/src/crucible/com/cenqua/crucible/model/FileRevisionExtraInfo.java','8089','unset');\nINSERT INTO REVISION_COMMENT VALUES(1,'2006-11-13 12:13:24.036000000','64',1,1,1);\nINSERT INTO REVISION_COMMENT VALUES(2,'2006-11-13 12:13:46.510000000','43',3,5,2);\nINSERT INTO REVISION_COMMENT VALUES(3,'2006-11-13 12:13:46.566000000','36',3,6,2);\nINSERT INTO REVISION_COMMENT VALUES(4,'2006-11-13 12:15:05.124000000','51',5,9,3);\nINSERT INTO STATE_CHANGE VALUES(1,'2006-11-13 12:10:57.079000000',NULL,'Draft');\nINSERT INTO STATE_CHANGE VALUES(2,'2006-11-13 12:11:54.413000000',1,'Review');\nINSERT INTO STATE_CHANGE VALUES(3,'2006-11-13 12:13:54.888000000',1,'Summarize');\nINSERT INTO STATE_CHANGE VALUES(4,'2006-11-13 12:14:04.275000000',1,'Closed');\nINSERT INTO STATE_CHANGE VALUES(5,'2006-11-13 12:14:05.769000000',NULL,'Draft');\nINSERT INTO STATE_CHANGE VALUES(6,'2006-11-13 12:14:32.110000000',2,'Review');\nINSERT INTO STATE_CHANGE VALUES(7,'2006-11-13 12:15:10.156000000',2,'Summarize');\nINSERT INTO STATE_CHANGE VALUES(8,'2006-11-13 12:15:16.514000000',2,'Closed');\nINSERT INTO STATE_CHANGE VALUES(9,'2006-11-13 12:15:22.180000000',NULL,'Draft');\nINSERT INTO STATE_CHANGE VALUES(10,'2006-11-13 12:16:14.391000000',3,'Review');\nINSERT INTO STATE_CHANGE VALUES(11,'2006-11-13 12:16:17.462000000',NULL,'Draft');\nINSERT INTO STATE_CHANGE VALUES(12,'2006-11-13 12:17:02.294000000',4,'Review');\nINSERT INTO STATE_CHANGE VALUES(13,'2006-11-13 12:17:04.754000000',NULL,'Draft');\nINSERT INTO STATE_CHANGE VALUES(14,'2006-11-13 12:17:33.860000000',5,'Review');\nINSERT INTO USER VALUES(8,'pmcneil',TRUE,1,1,1,1,1);\nINSERT INTO USER VALUES(9,'matt',TRUE,1,1,1,1,1);\nINSERT INTO USER VALUES(10,'pete',TRUE,1,1,1,1,1)";

    @Before
    public void setUp() throws Exception {
        this.dbdir = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/ugtestdb");
        if (this.dbdir.exists()) {
            FileUtils.deleteTree((File)this.dbdir);
        }
        Assert.assertTrue((boolean)this.dbdir.mkdir());
        System.out.println("Created " + this.dbdir.getAbsolutePath());
        TestFishEyeInstances.loadWebOnlySanity(false);
    }

    @After
    public void tearDown() throws Exception {
        try {
            TestFishEyeInstances.stop();
            TestFishEyeInstances.checkCleanStart();
        }
        finally {
            FileUtils.deleteTree((File)this.dbdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunUpgrade() throws Exception {
        int START_VERSION = 11;
        DefaultDBControl db1Control = Util.createDataBase(11, this.dbdir, "cruTestDB-11", this.data);
        for (int ver = 11; ver < DbVersion.getDatabaseVersion(); ++ver) {
            int nextVer = ver + 1;
            Assert.assertEquals((int)db1Control.getInfo().currentVersion(), (int)ver);
            DefaultDBControl db2Control = Util.createDataBase(ver + 1, this.dbdir, "cruTestDB-" + nextVer, null);
            Connection c1 = null;
            Connection c2 = null;
            try {
                System.out.println("Comparing upgraded " + ver + " with " + nextVer);
                db1Control.upgrade(nextVer);
                Assert.assertEquals((int)nextVer, (int)db1Control.getInfo().currentVersion());
                c1 = db1Control.getConnection();
                c2 = db2Control.getConnection();
                DbComparator dbCompare = new DbComparator(DBType.HSQL, c1, DBType.HSQL, c2, false);
                Assert.assertEquals((boolean)true, (boolean)dbCompare.areEqual(true));
                db1Control.closeConnection(c1);
                db2Control.closeConnection(c2);
                db2Control.dropTables();
                db1Control.closeConnection(c1);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                continue;
            }
            finally {
                db1Control.closeConnection(c1);
                db2Control.closeConnection(c2);
            }
            db2Control.closeConnection(c2);
            continue;
        }
        db1Control.dropTables();
    }
}

