/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.BoneCPConnectionHook;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.ConnectionHandle;
import java.sql.Connection;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BoneCPConnectionHookTest {
    private Connection internalConnectionMock;
    private ConnectionHandle connectionHandle;
    private BoneCPConnectionHook connHook;
    private BoneCP poolMock;
    private BoneCPConfig poolConfigMock;

    @Before
    public void setUp() throws Exception {
        this.internalConnectionMock = (Connection)Mockito.mock(Connection.class);
        this.poolConfigMock = (BoneCPConfig)Mockito.mock(BoneCPConfig.class);
        this.poolMock = (BoneCP)Mockito.mock(BoneCP.class);
        this.connectionHandle = (ConnectionHandle)Mockito.mock(ConnectionHandle.class);
        Mockito.when((Object)this.poolMock.getConfig()).thenReturn((Object)this.poolConfigMock);
        Mockito.when((Object)this.poolConfigMock.getStatementsCacheSize()).thenReturn((Object)0);
        Mockito.when((Object)this.connectionHandle.getInternalConnection()).thenReturn((Object)this.internalConnectionMock);
        this.connHook = new BoneCPConnectionHook();
    }

    @Test
    public void testOnCheckIn() throws Exception {
        Mockito.when((Object)this.internalConnectionMock.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.internalConnectionMock.getAutoCommit()).thenReturn((Object)false);
        this.connHook.onCheckIn(this.connectionHandle);
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).isClosed();
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).getAutoCommit();
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).rollback();
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).setAutoCommit(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.internalConnectionMock});
    }

    @Test
    public void testOnCheckInNoExceptionWhenConnectionIsClosed() throws Exception {
        Mockito.when((Object)this.internalConnectionMock.isClosed()).thenReturn((Object)true);
        this.connHook.onCheckIn(this.connectionHandle);
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).isClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.internalConnectionMock});
    }

    @Test
    public void testOnCheckInNoActionIfAutoCommitEnabled() throws Exception {
        Mockito.when((Object)this.internalConnectionMock.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.internalConnectionMock.getAutoCommit()).thenReturn((Object)true);
        this.connHook.onCheckIn(this.connectionHandle);
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).isClosed();
        ((Connection)Mockito.verify((Object)this.internalConnectionMock)).getAutoCommit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.internalConnectionMock});
    }
}

