/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.atlassian.fecru.anttasks.testdbs.BaseDbTask;
import com.atlassian.fecru.anttasks.testdbs.CreateMySQLDBsTask;
import com.atlassian.fecru.anttasks.testdbs.CreateOracleUsersTask;
import com.atlassian.fecru.anttasks.testdbs.CreatePostgresqlDBsTask;
import com.atlassian.fecru.anttasks.testdbs.CreateSQLServerDBsTask;
import com.atlassian.fecru.anttasks.testdbs.DropMySQLDBsTask;
import com.atlassian.fecru.anttasks.testdbs.DropOracleUsersTask;
import com.atlassian.fecru.anttasks.testdbs.DropPostgresqlDBsTask;
import com.atlassian.fecru.anttasks.testdbs.DropSQLServerDBsTask;
import com.cenqua.crucible.helpers.TestDbConfigFactory;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TestDbControlFactory {
    private static final Logger LOGGER = Logger.getLogger(TestDbControlFactory.class);
    public static final String BASE_SCRIPT_PATH = "etc/dist/sql";
    public static final File SQL_SCRIPT_BASE_DIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/sql");

    public static DefaultDBControl newHSQLController(String dbName) throws IOException {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getHSQLConfig(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newPostgreSQLController(String dbName) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getPostgreSQLConfig(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newMySQLController(String dbName) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getMySQLConfig(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newOracleController(String dbName) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getOracleConfig(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newSQLServerController2005(String dbName) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getSQLServerConfig2005(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newSQLServerController2008(String dbName) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getSQLServerConfig2008(dbName), (File)SQL_SCRIPT_BASE_DIR);
    }

    public static DefaultDBControl newSecondaryOracleController(String dbName) {
        return TestDbControlFactory.newOracleController(dbName, TestDbConfigFactory.getSecondaryDbUsername(), TestDbConfigFactory.getSecondaryDbPassword());
    }

    public static DefaultDBControl newOracleController(String dbName, String username, String password) {
        return DefaultDBControl.newInstance((DatabaseConfig)TestDbConfigFactory.getOracleConfig(dbName, username, password), (File)SQL_SCRIPT_BASE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeOusideTx(DefaultDBControl controller, String sql) throws Exception {
        Connection conn = null;
        Statement s = null;
        try {
            conn = controller.getConnection();
            conn.setAutoCommit(true);
            s = conn.createStatement();
            s.execute(sql);
            conn.setAutoCommit(false);
        }
        finally {
            if (s != null) {
                s.close();
            }
            controller.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printQuery(DefaultDBControl controller, String sql) {
        Connection conn = null;
        Statement s = null;
        try {
            conn = controller.getConnection();
            conn.setAutoCommit(true);
            s = conn.createStatement();
            ResultSet r = s.executeQuery(sql);
            while (r.next()) {
                StringBuilder b = new StringBuilder();
                for (int i = 1; i <= r.getMetaData().getColumnCount(); ++i) {
                    b.append(r.getMetaData().getColumnName(i)).append(": ").append(r.getObject(i)).append(", ");
                }
                System.out.println(b.toString());
            }
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error with query " + sql + ": " + e.getMessage()));
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"Failed to close statement", (Throwable)e);
                }
            }
            controller.closeConnection(conn);
        }
    }

    public static boolean isPostgresAvailable() {
        return !TestDbControlFactory.newPostgreSQLController(TestDbConfigFactory.getPrimaryDbName()).getInfo().state().equals((Object)DBInfo.DBState.NO_DB);
    }

    public static boolean isOracleAvailable() {
        return !TestDbControlFactory.newOracleController(TestDbConfigFactory.getPrimaryDbName()).getInfo().state().equals((Object)DBInfo.DBState.NO_DB);
    }

    public static boolean isMySQLAvailable() {
        return !TestDbControlFactory.newMySQLController(TestDbConfigFactory.getPrimaryDbName()).getInfo().state().equals((Object)DBInfo.DBState.NO_DB);
    }

    public static boolean isSQLServer2005Available() {
        return !TestDbControlFactory.newSQLServerController2005(TestDbConfigFactory.getPrimaryDbName()).getInfo().state().equals((Object)DBInfo.DBState.NO_DB);
    }

    public static boolean isSQLServer2008Available() {
        return !TestDbControlFactory.newSQLServerController2008(TestDbConfigFactory.getPrimaryDbName()).getInfo().state().equals((Object)DBInfo.DBState.NO_DB);
    }

    private static <T extends BaseDbTask> T primeTask(T task) {
        task.setHost(TestDbConfigFactory.getDbHost());
        task.setName(TestDbConfigFactory.getPrimaryDbName());
        task.setName2(TestDbConfigFactory.getSecondaryDbName());
        task.setUsername(TestDbConfigFactory.getDbUsername());
        task.setUsername2(TestDbConfigFactory.getSecondaryDbUsername());
        task.setPassword(TestDbConfigFactory.getDbPassword());
        task.setPassword2(TestDbConfigFactory.getSecondaryDbPassword());
        return task;
    }

    private static boolean executeCreateDbTask(BaseDbTask task, int port, String dbaUsername, String dbaPassword) {
        return TestDbControlFactory.executeDbTask(task, port, dbaUsername, dbaPassword, "create");
    }

    private static boolean executeDropDbTask(BaseDbTask task, int port, String dbaUsername, String dbaPassword) {
        return TestDbControlFactory.executeDbTask(task, port, dbaUsername, dbaPassword, "drop");
    }

    private static boolean executeDbTask(BaseDbTask task, int port, String dbaUsername, String dbaPassword, String action) {
        try {
            TestDbControlFactory.primeTask(task);
            task.setPort(Integer.toString(port));
            task.setDbaUsername(dbaUsername);
            task.setDbaPassword(dbaPassword);
            task.execute(TestDbConfigFactory.getProjectDir());
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to " + action + " database"), (Throwable)e);
            return false;
        }
    }

    public static boolean createPostgresDbs() {
        return TestDbControlFactory.executeCreateDbTask((BaseDbTask)new CreatePostgresqlDBsTask(), TestDbConfigFactory.getPostgreSQLPort(), TestDbConfigFactory.getPostgreSQLDBAUsername(), TestDbConfigFactory.getPostgreSQLDBAPassword());
    }

    public static boolean dropPostgresDbs() {
        return TestDbControlFactory.executeDropDbTask((BaseDbTask)new DropPostgresqlDBsTask(), TestDbConfigFactory.getPostgreSQLPort(), TestDbConfigFactory.getPostgreSQLDBAUsername(), TestDbConfigFactory.getPostgreSQLDBAPassword());
    }

    public static boolean dropOracleUsers() {
        return TestDbControlFactory.executeDropDbTask((BaseDbTask)new DropOracleUsersTask(), TestDbConfigFactory.getOraclePort(), TestDbConfigFactory.getOracleDBAUsername(), TestDbConfigFactory.getOracleDBAPassword());
    }

    public static boolean createOracleUsers() {
        return TestDbControlFactory.executeCreateDbTask((BaseDbTask)new CreateOracleUsersTask(), TestDbConfigFactory.getOraclePort(), TestDbConfigFactory.getOracleDBAUsername(), TestDbConfigFactory.getOracleDBAPassword());
    }

    public static boolean createMySQLDbs() {
        return TestDbControlFactory.executeCreateDbTask((BaseDbTask)new CreateMySQLDBsTask(), TestDbConfigFactory.getMySQLPort(), TestDbConfigFactory.getMySQLDBAUsername(), TestDbConfigFactory.getMySQLDBAPassword());
    }

    public static boolean dropMySQLDbs() {
        return TestDbControlFactory.executeDropDbTask((BaseDbTask)new DropMySQLDBsTask(), TestDbConfigFactory.getMySQLPort(), TestDbConfigFactory.getMySQLDBAUsername(), TestDbConfigFactory.getMySQLDBAPassword());
    }

    public static boolean createSQLServer2005Dbs() {
        return TestDbControlFactory.executeCreateDbTask((BaseDbTask)new CreateSQLServerDBsTask(), TestDbConfigFactory.getSQLServer2005Port(), TestDbConfigFactory.getSQLServerDBAUsername(), TestDbConfigFactory.getSQLServerDBAPassword());
    }

    public static boolean createSQLServer2008Dbs() {
        return TestDbControlFactory.executeCreateDbTask((BaseDbTask)new CreateSQLServerDBsTask(), TestDbConfigFactory.getSQLServer2008Port(), TestDbConfigFactory.getSQLServerDBAUsername(), TestDbConfigFactory.getSQLServerDBAPassword());
    }

    public static boolean dropSQLServer2005Dbs() {
        return TestDbControlFactory.executeDropDbTask((BaseDbTask)new DropSQLServerDBsTask(), TestDbConfigFactory.getSQLServer2005Port(), TestDbConfigFactory.getSQLServerDBAUsername(), TestDbConfigFactory.getSQLServerDBAPassword());
    }

    public static boolean dropSQLServer2008Dbs() {
        return TestDbControlFactory.executeDropDbTask((BaseDbTask)new DropSQLServerDBsTask(), TestDbConfigFactory.getSQLServer2008Port(), TestDbConfigFactory.getSQLServerDBAUsername(), TestDbConfigFactory.getSQLServerDBAPassword());
    }

    public static boolean dropTables(String dbName, DBType dbType) {
        DBControl control = TestDbControlFactory.getDBController(dbName, dbType);
        try {
            if (!control.isEmpty()) {
                control.dropTables();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to drop tables for " + dbName), (Throwable)e);
            return false;
        }
    }

    public static DBControl getDBController(final String dbName, DBType dbType) {
        if (dbType != null) {
            return (DBControl)dbType.accept((DBType.Visitor)new DBType.Visitor<DefaultDBControl>(){

                public DefaultDBControl visitHsql() {
                    try {
                        return TestDbControlFactory.newHSQLController(dbName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create HSQL db directory", e);
                    }
                }

                public DefaultDBControl visitMySQL() {
                    return TestDbControlFactory.newMySQLController(dbName);
                }

                public DefaultDBControl visitPostgresSQL() {
                    return TestDbControlFactory.newPostgreSQLController(dbName);
                }

                public DefaultDBControl visitOracle() {
                    return TestDbControlFactory.newOracleController(dbName);
                }

                public DefaultDBControl visitSQLServer2005() {
                    return TestDbControlFactory.newSQLServerController2005(dbName);
                }

                public DefaultDBControl visitSQLServer2008() {
                    return TestDbControlFactory.newSQLServerController2008(dbName);
                }
            });
        }
        throw new IllegalArgumentException("Cannot construct a db controller for a null db type");
    }

    public static String getDBScriptPathFor(DBType dbType) {
        if (dbType != null) {
            return String.format("%s/%s/", BASE_SCRIPT_PATH, dbType.accept((DBType.Visitor)new DBType.Visitor<String>(){

                public String visitHsql() {
                    return "HSQL";
                }

                public String visitMySQL() {
                    return DBType.MYSQL.name();
                }

                public String visitPostgresSQL() {
                    return DBType.POSTGRESQL.name();
                }

                public String visitOracle() {
                    return DBType.ORACLE.name();
                }

                public String visitSQLServer2005() {
                    return DBType.SQLSERVER2005.name();
                }

                public String visitSQLServer2008() {
                    return DBType.SQLSERVER2008.name();
                }
            }));
        }
        throw new IllegalArgumentException("Cannot determine the script path for a null db type");
    }
}

