/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TestDbConfigFactory {
    private static final Logger LOGGER = Logger.getLogger(TestDbConfigFactory.class);
    private static final String PROP_PROJECT_DIR = "project.dir";
    private static final String PROP_DB_HOST = "db.host";
    private static final String PROP_DB_USERNAME = "db.username";
    private static final String PROP_DB_PASSWORD = "db.password";
    private static final String PROP_DB_USERNAME2 = "db.username2";
    private static final String PROP_DB_PASSWORD2 = "db.password2";
    private static final String PROP_DB_NAME1 = "db.name";
    private static final String PROP_DB_NAME2 = "db.name2";
    private static final String PROP_DB_POSTGRESQL_PORT = "db.postgresql.port";
    private static final String PROP_DB_POSTGRESQL_DBA_USERNAME = "db.postgresql.dba.username";
    private static final String PROP_DB_POSTGRESQL_DBA_PASSWORD = "db.postgresql.dba.password";
    private static final String PROP_DB_MYSQL_PORT = "db.mysql.port";
    private static final String PROP_DB_MYSQL_DBA_USERNAME = "db.mysql.dba.username";
    private static final String PROP_DB_MYSQL_DBA_PASSWORD = "db.mysql.dba.password";
    private static final String PROP_DB_SQLSERVER_2005_PORT = "db.sqlserver2005.port";
    private static final String PROP_DB_SQLSERVER_2008_PORT = "db.sqlserver2008.port";
    private static final String PROP_DB_SQLSERVER_DBA_USERNAME = "db.sqlserver.dba.username";
    private static final String PROP_DB_SQLSERVER_DBA_PASSWORD = "db.sqlserver.dba.password";
    private static final String PROP_DB_ORACLE_PORT = "db.oracle.port";
    private static final String PROP_DB_ORACLE_DBA_USERNAME = "db.oracle.dba.username";
    private static final String PROP_DB_ORACLE_DBA_PASSWORD = "db.oracle.dba.password";
    private static final String PROP_DB_ORACLE_SYSDBA_ROLE_NEEDED = "db.oracle.dba.sysdba.role.needed";

    public static String getProjectDir() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_PROJECT_DIR);
    }

    public static String getPrimaryDbName() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_NAME1);
    }

    public static String getSecondaryDbName() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_NAME2);
    }

    public static String getDbHost() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_HOST);
    }

    public static String getDbUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_USERNAME);
    }

    public static String getDbPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_PASSWORD);
    }

    public static String getSecondaryDbUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_USERNAME2);
    }

    public static String getSecondaryDbPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_PASSWORD2);
    }

    public static int getMySQLPort() {
        return TestDbConfigFactory.getDbPort(PROP_DB_MYSQL_PORT);
    }

    public static String getMySQLDBAUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_MYSQL_DBA_USERNAME);
    }

    public static String getMySQLDBAPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_MYSQL_DBA_PASSWORD);
    }

    public static int getPostgreSQLPort() {
        return TestDbConfigFactory.getDbPort(PROP_DB_POSTGRESQL_PORT);
    }

    public static String getPostgreSQLDBAUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_POSTGRESQL_DBA_USERNAME);
    }

    public static String getPostgreSQLDBAPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_POSTGRESQL_DBA_PASSWORD);
    }

    public static int getOraclePort() {
        return TestDbConfigFactory.getDbPort(PROP_DB_ORACLE_PORT);
    }

    public static String getOracleDBAUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_ORACLE_DBA_USERNAME);
    }

    public static String getOracleDBAPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_ORACLE_DBA_PASSWORD);
    }

    public static boolean isOracleSysdbaRoleNeeded() {
        return Boolean.valueOf(TestDbConfigFactory.getPropertyOrFail(PROP_DB_ORACLE_SYSDBA_ROLE_NEEDED));
    }

    public static int getSQLServer2005Port() {
        return TestDbConfigFactory.getDbPort(PROP_DB_SQLSERVER_2005_PORT);
    }

    public static int getSQLServer2008Port() {
        return TestDbConfigFactory.getDbPort(PROP_DB_SQLSERVER_2008_PORT);
    }

    public static String getSQLServerDBAUsername() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_SQLSERVER_DBA_USERNAME);
    }

    public static String getSQLServerDBAPassword() {
        return TestDbConfigFactory.getPropertyOrFail(PROP_DB_SQLSERVER_DBA_PASSWORD);
    }

    private static int getDbPort(String propertyName) {
        try {
            return Integer.parseInt(String.valueOf(TestDbConfigFactory.getPropertyOrFail(propertyName)));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Invalid value (not an integer) for system property " + propertyName + ": '" + System.getProperty(propertyName) + "'"));
            throw e;
        }
    }

    private static String getPropertyOrFail(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (StringUtils.isEmpty((String)propertyValue)) {
            throw new IllegalArgumentException("System property " + propertyName + " must be supplied and must not be empty");
        }
        return propertyValue;
    }

    public static DatabaseConfig getHSQLConfig(String dbName) throws IOException {
        File tmpDbDir = FisheyeTestUtil.createTempDir(dbName);
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.HSQL);
        dbconfig.setJdbcURL(DBType.HSQL.getUrlFromTemplate(new Object[]{tmpDbDir.getAbsolutePath() + "/crudb"}));
        dbconfig.setPassword("");
        dbconfig.setUsername("sa");
        return dbconfig;
    }

    public static DatabaseConfig getMySQLConfig(String dbName) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.MYSQL);
        dbconfig.setJdbcURL(DBType.MYSQL.getUrlFromTemplate(new Object[]{TestDbConfigFactory.getDbHost(), TestDbConfigFactory.getMySQLPort(), dbName}));
        TestDbConfigFactory.setCruUsernamePasswordProperties(dbconfig);
        return dbconfig;
    }

    public static DatabaseConfig getPostgreSQLConfig(String dbName) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.POSTGRESQL);
        dbconfig.setJdbcURL(DBType.POSTGRESQL.getUrlFromTemplate(new Object[]{TestDbConfigFactory.getDbHost(), TestDbConfigFactory.getPostgreSQLPort(), dbName}));
        TestDbConfigFactory.setCruUsernamePasswordProperties(dbconfig);
        return dbconfig;
    }

    public static DatabaseConfig getOracleConfig(String dbName) {
        return TestDbConfigFactory.getOracleConfig(dbName, TestDbConfigFactory.getDbUsername(), TestDbConfigFactory.getDbPassword());
    }

    public static DatabaseConfig getOracleConfig(String dbName, String username, String password) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.ORACLE);
        dbconfig.setJdbcURL(TestDbConfigFactory.newOracleJdbcUrl(dbName));
        dbconfig.setPassword(username);
        dbconfig.setUsername(password);
        return dbconfig;
    }

    public static DatabaseConfig getSQLServerConfig2005(String dbName) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.SQLSERVER2005);
        dbconfig.setJdbcURL(DBType.SQLSERVER2005.getUrlFromTemplate(new Object[]{TestDbConfigFactory.getDbHost(), TestDbConfigFactory.getSQLServer2005Port(), dbName}));
        TestDbConfigFactory.setCruUsernamePasswordProperties(dbconfig);
        return dbconfig;
    }

    public static DatabaseConfig getSQLServerConfig2008(String dbName) {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.SQLSERVER2008);
        dbconfig.setJdbcURL(DBType.SQLSERVER2008.getUrlFromTemplate(new Object[]{TestDbConfigFactory.getDbHost(), TestDbConfigFactory.getSQLServer2008Port(), dbName}));
        TestDbConfigFactory.setCruUsernamePasswordProperties(dbconfig);
        return dbconfig;
    }

    public static String newOracleJdbcUrl(String dbName) {
        return DBType.ORACLE.getUrlFromTemplate(new Object[]{TestDbConfigFactory.getDbHost(), TestDbConfigFactory.getOraclePort(), dbName});
    }

    private static void setCruUsernamePasswordProperties(DatabaseConfig dbconfig) {
        dbconfig.setUsername(TestDbConfigFactory.getDbUsername());
        dbconfig.setPassword(TestDbConfigFactory.getDbPassword());
    }
}

