/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ScmHelper {
    public static boolean copyFile(String existingFileName, String newFileName) throws IOException {
        if (Strings.isNullOrEmpty((String)existingFileName) || Strings.isNullOrEmpty((String)newFileName) || existingFileName.equals(newFileName)) {
            throw new IllegalArgumentException("existingFileName and newFileName must be provided and not the same");
        }
        Files.copy((File)new File(existingFileName), (File)new File(newFileName));
        return ScmHelper.addFile(newFileName);
    }

    public static boolean addFile(String fileName) throws IOException {
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw new IllegalArgumentException("fileName is null or empty");
        }
        return ScmHelper.execute("git", "add", fileName);
    }

    private static boolean execute(String ... args) throws IOException {
        String line;
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        InputStream is = p.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        System.out.println(String.join((CharSequence)" ", args));
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        return true;
    }
}

