/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class MySQLConstraintTransformer
implements Function<String, String> {
    private static final Logger LOGGER = Logger.getLogger(MySQLConstraintTransformer.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile("create index (\\w+) on (\\w+) \\((.+)\\)");
    private static final Pattern VARCHAR_PATTERN = Pattern.compile("varchar\\(([0-9]+)\\)");
    private static final int MYSQL_CHAR_INDEX_LIMIT = 255;
    private Multimap<String, String> tableColumnsToTrim = HashMultimap.create();

    public MySQLConstraintTransformer(Configuration cfg, Dialect dialect) {
        Mapping mapping = cfg.buildMapping();
        Iterator tableIterator = cfg.getTableMappings();
        while (tableIterator.hasNext()) {
            Table table = (Table)tableIterator.next();
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                String sqlType = column.getSqlType(dialect, mapping);
                Matcher varCharMatcher = VARCHAR_PATTERN.matcher(sqlType);
                if ((!varCharMatcher.matches() || Integer.valueOf(varCharMatcher.group(1)) <= 255) && !sqlType.equals("longtext")) continue;
                this.tableColumnsToTrim.put((Object)table.getName(), (Object)column.getName());
            }
        }
    }

    @Override
    public String apply(String input) {
        Matcher indexMatcher = INDEX_PATTERN.matcher(input);
        if (indexMatcher.matches()) {
            String indexName = indexMatcher.group(1);
            String tableName = indexMatcher.group(2);
            Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)indexMatcher.group(3));
            if (this.tableColumnsToTrim.containsKey((Object)tableName)) {
                Iterable truncatedIndexes = Iterables.transform((Iterable)columns, line -> {
                    ImmutableList nameAndLength = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"()")).omitEmptyStrings().trimResults().split((CharSequence)line));
                    String columName = (String)nameAndLength.get(0);
                    if (!this.tableColumnsToTrim.get((Object)tableName).contains(columName) || nameAndLength.size() > 1 && Integer.valueOf((String)nameAndLength.get(1)) <= 255) {
                        return line;
                    }
                    return String.format("%s(%s)", columName, 255);
                });
                String output = "create index " + indexName + " on " + tableName + " (" + Joiner.on((String)", ").join(truncatedIndexes) + ")";
                if (!output.equals(input)) {
                    LOGGER.info((Object)String.format("Truncated MySQL index for %s (%s -> %s)", tableName, ImmutableList.copyOf((Iterable)columns), ImmutableList.copyOf((Iterable)truncatedIndexes)));
                }
                return output;
            }
        }
        return input;
    }
}

