/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.StringClobType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.el.PropertyNotFoundException;

public class DbLint {
    private List<String> errors = new ArrayList<String>();
    private File mappingFile;
    protected static final Pattern CLASS_NAME_PATTERN = Pattern.compile("<class.*name=\"([^\"]*)");
    protected static final Pattern COMPID_CLASS_NAME_PATTERN = Pattern.compile("<composite-id.*class=\"([^\"]*)");
    protected static final Pattern COL_NAME_PATTERN = Pattern.compile(" column=\"([^\"]*)\"");
    protected static final Pattern TABLE_NAME_PATTERN = Pattern.compile(" table=\"([^\"]*)\"");
    protected static final Pattern INDEX_NAME_PATTERN = Pattern.compile(" index=\"([^\"]*)\"");
    protected static final Pattern NEED_COL_PATTERN = Pattern.compile("<(property|id|many-to-one|many-to-many|key|list-index)[^>]*>");
    protected static final Pattern NEED_FK_PATTERN = Pattern.compile("<(many-to-one |many-to-many |one-to-one |key |key-many-to-one)[^>]*>");
    protected static final Pattern PROPERTY_PATTERN = Pattern.compile("<(property|id)[^>]*>");
    protected static final Pattern KEY_PROPERTY_PATTERN = Pattern.compile("<key-property[^>]*>");
    protected static final Pattern UPROPERTIES_PATTERN = Pattern.compile("<properties[^>]*unique=\"true\"[^>]*>([<\\w\\s\\-=\"./>\\n]*)</properties>");
    private static final int MYSQL_MAX_IDX_LEN = 767;
    private static final int MYSQL_MAX_TOTAL_IDX_LEN = 3072;
    private static final Set<String> EXCLUDED_FROM_INDEX_LENGTH_CHECKS = ImmutableSet.of((Object)"cru_idx_stored_path");
    private static final int MAX_NAME_LEN = 31;
    private static final Pattern SUBCLASS_OPEN_PATTERN = Pattern.compile("<subclass name=\"([^\"]*)\"[^/]*>");
    private static final Pattern SUBCLASS_CLOSE_PATTERN = Pattern.compile("</subclass>");
    private static final Pattern COMPONENT_OPEN_PATTERN = Pattern.compile("<component name=\"([^\"]*)\" class=\"([^\"]*)\"[^/]*>");
    private static final Pattern COMPONENT_CLOSE_PATTERN = Pattern.compile("</component>");
    private static final Pattern COMPOSITE_OPEN_PATTERN = Pattern.compile("<composite-element class=\"([^\"]*)\"[^/]*>");
    private static final Pattern COMPOSITE_CLOSE_PATTERN = Pattern.compile("</composite-element>");
    private static final Pattern CLASS_PATTERN = Pattern.compile("<class.*?</class>", 32);

    public void testMappingLint() throws IOException {
        for (String fileName : Config.HIBERNATE_MAPPING_FILES) {
            this.mappingFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "src/java/" + fileName);
            System.out.println("Checking " + this.mappingFile.getAbsolutePath());
            this.verifyTrue("File not found: " + this.mappingFile.getAbsolutePath(), this.mappingFile.exists());
            String mapping = IOHelper.copyFileToString((Charset)Charsets.UTF_8, (File)this.mappingFile);
            this.checkColumnNames(mapping);
            this.checkTableNames(mapping);
            this.checkIndexNames(mapping);
            this.checkHaveColumn(mapping);
            this.checkForeignKeysHaveNames(mapping);
            Matcher matcher = CLASS_PATTERN.matcher(mapping);
            while (matcher.find()) {
                String classMapping = matcher.group();
                Class c = this.findClass(classMapping);
                this.checkTypeProperties(classMapping, c);
                this.checkUniqueProperties(classMapping, c);
                this.checkUniqueConstraintsAndIndices(classMapping, c);
            }
            this.checkCompIDType(mapping);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private void checkColumnNames(String mapping) {
        this.checkMatches(mapping, COL_NAME_PATTERN, 1, new CheckableString(){

            @Override
            public void check(String name) {
                DbLint.this.checkIdentifier(name);
            }
        });
    }

    private void checkTableNames(String mapping) {
        this.checkMatches(mapping, TABLE_NAME_PATTERN, 1, new CheckableString(){

            @Override
            public void check(String name) {
                DbLint.this.checkIdentifier(name);
                DbLint.this.verifyTrue(name + " must be prefixed with cru_ or cwd_", name.startsWith("cru_") || name.startsWith("cwd_"));
            }
        });
    }

    private void checkIndexNames(String mapping) {
        this.checkMatches(mapping, INDEX_NAME_PATTERN, 1, new CheckableString(){

            @Override
            public void check(String name) {
                DbLint.this.checkIndexName(name);
            }
        });
    }

    private void checkHaveColumn(String mapping) {
        this.checkMatches(mapping, NEED_COL_PATTERN, 0, new CheckableString(){

            @Override
            public void check(String property) {
                String lcProp = property.toLowerCase();
                DbLint.this.verifyTrue(property + " requires a column name", lcProp.contains("column="));
            }
        });
    }

    private void checkUniqueConstraintsAndIndices(String mapping, Class<?> clazz) {
        final Pattern VALID_UNIQUE_KEY_PATTERN = Pattern.compile("unique-key=\"(uk_[a-z_]{1,27}(,uk_[a-z_]{1,27}){0,})\"");
        this.checkMatches(mapping, NEED_COL_PATTERN, 0, new CheckableString(){
            final Pattern ANY_UNIQUE_KEY_PATTERN = Pattern.compile("unique-key=\"");
            final Pattern UNIQUE_TRUE_PATTERN = Pattern.compile("unique=");

            @Override
            public void check(String property) {
                boolean hasUniqueTrue = this.UNIQUE_TRUE_PATTERN.matcher(property).find();
                DbLint.this.verifyTrue(property + " should have an explicit unique constraint name (unique-key instead of just unique='true')", !hasUniqueTrue);
                boolean hasUniqueKey = this.ANY_UNIQUE_KEY_PATTERN.matcher(property).find();
                boolean hasValidUniqueKey = VALID_UNIQUE_KEY_PATTERN.matcher(property).find();
                DbLint.this.verifyTrue(property + " should have unique-key named uk_[lowercaseletters and _], with less than 30 chars total", hasValidUniqueKey || !hasUniqueKey);
            }
        });
        HashMultimap uniqueKeys = HashMultimap.create();
        HashMap uniqueKeysLengths = new HashMap();
        HashMultimap indexes = HashMultimap.create();
        HashMap indexesLengths = new HashMap();
        this.checkMatches(mapping, NEED_COL_PATTERN, 0, new CheckableString((Multimap)uniqueKeys, uniqueKeysLengths, clazz, (Multimap)indexes, indexesLengths){
            final /* synthetic */ Multimap val$uniqueKeys;
            final /* synthetic */ Map val$uniqueKeysLengths;
            final /* synthetic */ Class val$clazz;
            final /* synthetic */ Multimap val$indexes;
            final /* synthetic */ Map val$indexesLengths;
            {
                this.val$uniqueKeys = multimap;
                this.val$uniqueKeysLengths = map;
                this.val$clazz = clazz;
                this.val$indexes = multimap2;
                this.val$indexesLengths = map2;
            }

            @Override
            public void check(String property) {
                Matcher indexNameMatcher;
                Matcher uniqueKeyMatcher = VALID_UNIQUE_KEY_PATTERN.matcher(property);
                boolean hasValidUniqueKey = uniqueKeyMatcher.find();
                String propertyName = DbLint.this.getPropertyName(property);
                if (hasValidUniqueKey) {
                    for (String keyName : uniqueKeyMatcher.group(1).split(",")) {
                        this.val$uniqueKeys.put((Object)keyName, (Object)propertyName);
                        DbLint.this.checkIndexLength(this.val$uniqueKeysLengths, keyName, property, this.val$clazz);
                    }
                }
                if ((indexNameMatcher = INDEX_NAME_PATTERN.matcher(property)).find()) {
                    for (String indexName : indexNameMatcher.group(1).split(",")) {
                        this.val$indexes.put((Object)indexName, (Object)propertyName);
                        DbLint.this.checkIndexLength(this.val$indexesLengths, indexName, property, this.val$clazz);
                    }
                }
            }
        });
        uniqueKeys.asMap().entrySet().forEach(arg_0 -> this.lambda$checkUniqueConstraintsAndIndices$219((Multimap)indexes, clazz, arg_0));
        Stream.concat(uniqueKeysLengths.entrySet().stream(), indexesLengths.entrySet().stream()).filter(entry -> ((CheckIdxLength)entry.getValue()).idxLen >= 3072).forEach(entry -> this.verifyTrue("Total index/unique constraint length must be less than 3072 bytes - currently " + ((CheckIdxLength)entry.getValue()).idxLen + " for " + (String)entry.getKey(), false));
    }

    private void checkIndexLength(Map<String, CheckIdxLength> uniqueKeysLengths, String keyName, String property, Class<?> clazz) {
        CheckIdxLength checkIdxLength = uniqueKeysLengths.get(keyName);
        if (checkIdxLength == null) {
            checkIdxLength = new CheckIdxLength(clazz);
            uniqueKeysLengths.put(keyName, checkIdxLength);
        }
        int lengthBefore = checkIdxLength.idxLen;
        checkIdxLength.check(property);
        int propertyLength = checkIdxLength.idxLen - lengthBefore;
        this.verifyTrue("An index for a single column should be lest then 767 but it is " + propertyLength + " for " + property, propertyLength < 767 || EXCLUDED_FROM_INDEX_LENGTH_CHECKS.contains(keyName));
    }

    private void checkForeignKeysHaveNames(String mapping) {
        this.checkMatches(mapping, NEED_FK_PATTERN, 0, new CheckableString(){
            final Pattern OLD_GENERATED_FOREIGN_KEY_PATTERN = Pattern.compile("foreign-key=\"FK[0-9A-Z]{1,28}\"");
            final Pattern NATURAL_NAME_FOREIGN_KEY_PATTERN = Pattern.compile("foreign-key=\"fk_[a-z_]{1,27}\"");

            @Override
            public void check(String property) {
                DbLint.this.verifyTrue(property + " requires an explicit foreign-key name", this.OLD_GENERATED_FOREIGN_KEY_PATTERN.matcher(property).find() || this.NATURAL_NAME_FOREIGN_KEY_PATTERN.matcher(property).find());
            }
        });
    }

    private String getPropertyName(String property) {
        return property.replaceAll(".*name=\"([^\"]*)[^>]*>", "$1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCompIDType(String mapping) {
        Class<?> c;
        Matcher m = COMPID_CLASS_NAME_PATTERN.matcher(mapping);
        if (!m.find()) return;
        String className = m.group(1);
        if (className == null) return;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.fail("Class " + className + "Not found");
            return;
        }
        this.checkMatches(mapping, KEY_PROPERTY_PATTERN, 0, new StringPropChecker(c));
        CheckIdxLength checker = new CheckIdxLength(c);
        this.checkMatches(mapping, KEY_PROPERTY_PATTERN, 0, checker);
        this.verifyTrue("Total composite id length must be less than 3072 bytes - currently " + checker.idxLen + " for class " + className, checker.idxLen < 3072);
    }

    private boolean isPropertyAsVarchar(String lcprop) {
        return !lcprop.contains("type=\"text\"") && !lcprop.contains(("type=\"" + StringClobType.class.getName() + "\"").toLowerCase());
    }

    private void checkUniqueProperties(String mapping, Class c) {
        this.checkMatches(mapping, UPROPERTIES_PATTERN, 0, new CheckableString(){

            @Override
            public void check(String mapping) {
                DbLint.this.verifyTrue(mapping + " - don't use <properties unique='true', add unique-key on the properties themselves instead", false);
            }
        });
    }

    private boolean isPropertyAString(String propertyName, Class c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().matches("(is|get)" + this.capFirstChar(propertyName))) continue;
            return m.getReturnType().getName().equals("java.lang.String");
        }
        Class clazz = c;
        do {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().matches("(is|get)" + this.capFirstChar(propertyName))) continue;
                return m.getReturnType().getName().equals("java.lang.String");
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        throw new PropertyNotFoundException("Property " + propertyName + " not found");
    }

    private String capFirstChar(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private void checkMatches(String mapping, Pattern pat, int group, CheckableString target) {
        Matcher m = pat.matcher(mapping);
        while (m.find()) {
            String name = m.group(group);
            target.check(name);
        }
    }

    private void checkTypeProperties(String mapping, Class outerClass) {
        StringPropChecker checker = new StringPropChecker(outerClass);
        StringPropChecker subchecker = null;
        Matcher p = PROPERTY_PATTERN.matcher(mapping);
        Matcher subclassOpen = SUBCLASS_OPEN_PATTERN.matcher(mapping);
        Matcher subclassClose = SUBCLASS_CLOSE_PATTERN.matcher(mapping);
        Matcher componentOpen = COMPONENT_OPEN_PATTERN.matcher(mapping);
        Matcher componentClose = COMPONENT_CLOSE_PATTERN.matcher(mapping);
        Matcher compositeOpen = COMPOSITE_OPEN_PATTERN.matcher(mapping);
        Matcher compositeClose = COMPOSITE_CLOSE_PATTERN.matcher(mapping);
        String tail = mapping;
        while (tail.length() > 0) {
            String className;
            int offset = 0;
            if (p.lookingAt()) {
                StringPropChecker currentChecker = subchecker == null ? checker : subchecker;
                currentChecker.check(p.group(0));
                offset = p.end();
            } else if (subclassOpen.lookingAt()) {
                className = subclassOpen.group(1);
                try {
                    subchecker = new StringPropChecker(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    this.fail("Class " + className + " Not found");
                }
                offset = subclassOpen.end();
            } else if (subclassClose.lookingAt()) {
                subchecker = null;
                offset = subclassClose.end();
            } else if (componentOpen.lookingAt()) {
                String name = componentOpen.group(1);
                String className2 = componentOpen.group(2);
                checker.check(name);
                try {
                    subchecker = new StringPropChecker(Class.forName(className2));
                }
                catch (ClassNotFoundException e) {
                    this.fail("Class " + className2 + " Not found");
                }
                offset = componentOpen.end();
            } else if (componentClose.lookingAt()) {
                subchecker = null;
                offset = componentClose.end();
            } else if (compositeOpen.lookingAt()) {
                className = compositeOpen.group(1);
                try {
                    subchecker = new StringPropChecker(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    this.fail("Class " + className + " Not found");
                }
                offset = compositeOpen.end();
            } else if (compositeClose.lookingAt()) {
                subchecker = null;
                offset = compositeClose.end();
            } else {
                ++offset;
            }
            if (offset >= tail.length()) break;
            tail = tail.substring(offset);
            p.reset(tail);
            subclassClose.reset(tail);
            subclassOpen.reset(tail);
            componentClose.reset(tail);
            componentOpen.reset(tail);
            compositeClose.reset(tail);
            compositeOpen.reset(tail);
        }
    }

    private Class findClass(String mapping) {
        String className;
        Class<?> c = null;
        Matcher m = CLASS_NAME_PATTERN.matcher(mapping);
        if (m.find() && (className = m.group(1)) != null) {
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                this.fail("Class " + className + " Not found");
            }
        }
        return c;
    }

    private void checkIdentifier(String name) {
        this.verifyTrue("Identifier is null", name != null);
        if (name != null) {
            this.verifyTrue(name + " must be lower case", name.toLowerCase().equals(name));
            this.verifyTrue(name + " must be less than " + 31 + " chars", name.length() < 31);
        }
    }

    private void checkIndexName(String indexValue) {
        this.verifyTrue("Identifier is null", indexValue != null);
        if (indexValue != null) {
            Arrays.stream(indexValue.split(",")).forEach(name -> this.verifyTrue(name + " must be less than " + 31 + " chars", name.length() < 31));
        }
    }

    private boolean verifyTrue(String message, boolean test) {
        if (!test) {
            this.errors.add("In " + this.mappingFile.getName() + ": " + message);
        }
        return test;
    }

    private void fail(String message) {
        this.verifyTrue(message, false);
    }

    public static void main(String[] args) {
        DbLint dbLint = new DbLint();
        try {
            dbLint.testMappingLint();
            if (dbLint.hasErrors()) {
                System.err.println("Mapping files have " + dbLint.getErrors().size() + " errors");
                for (String message : dbLint.getErrors()) {
                    System.err.println(message);
                }
                System.exit(-1);
            }
        }
        catch (IOException e) {
            System.err.println("DB Lint failed, sorry. Reason: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private /* synthetic */ void lambda$checkUniqueConstraintsAndIndices$219(Multimap indexes, Class clazz, Map.Entry uk) {
        String keyName = (String)uk.getKey();
        Collection keyColumns = (Collection)uk.getValue();
        Optional<String> matchingIndex = indexes.asMap().entrySet().stream().filter(indexEntry -> ((Collection)indexEntry.getValue()).equals(keyColumns)).map(Map.Entry::getKey).findAny();
        if (matchingIndex.isPresent()) {
            this.verifyTrue(clazz + " shouldn't define a unique-key and an index for the same set of columns. " + "UK=" + keyName + ", index=" + matchingIndex.get() + ", columns=" + keyColumns, false);
        }
    }

    private class CheckIdxLength
    extends CheckableString {
        private final Class c;
        private int idxLen;

        private CheckIdxLength(Class c) {
            this.idxLen = 0;
            this.c = c;
        }

        @Override
        public void check(String property) {
            String fieldName = DbLint.this.getPropertyName(property);
            try {
                if (DbLint.this.isPropertyAString(fieldName, this.c)) {
                    String lcprop = property.toLowerCase();
                    if (DbLint.this.isPropertyAsVarchar(lcprop)) {
                        String len = lcprop.replaceAll("[\\s\\S]*length=\"([^\"]*)[^>]*>", "$1");
                        this.idxLen += Integer.parseInt(len) * 3;
                    } else {
                        DbLint.this.fail("Can't use text/clob field as unique key: " + fieldName + " in " + property);
                    }
                } else {
                    this.idxLen += 4;
                }
                System.out.println("checking key property " + fieldName + " in " + property + " length so far " + this.idxLen);
            }
            catch (PropertyNotFoundException e) {
                DbLint.this.fail("No such property " + fieldName + " in " + property + " for class " + this.c);
            }
        }
    }

    private class StringPropChecker
    extends CheckableString {
        final Class c;

        private StringPropChecker(Class c) {
            this.c = c;
        }

        @Override
        public void check(String property) {
            String fieldName = DbLint.this.getPropertyName(property);
            try {
                String lcprop;
                if (DbLint.this.isPropertyAString(fieldName, this.c) && DbLint.this.isPropertyAsVarchar(lcprop = property.toLowerCase())) {
                    DbLint.this.verifyTrue("String property must have a type: " + property, lcprop.contains("type=\"string\""));
                    if (DbLint.this.verifyTrue("String property must have a length: " + property, lcprop.contains("length=")) && lcprop.contains("unique-key=")) {
                        System.out.println("Checking unique string " + property);
                        String len = lcprop.replaceAll(".*length=\"([^\"]*)[^>]*>", "$1");
                        DbLint.this.verifyTrue("unique string property must have a length < 767 bytes: " + property, Integer.parseInt(len) * 3 < 767);
                    }
                }
            }
            catch (PropertyNotFoundException e) {
                DbLint.this.fail("No such property " + fieldName + " for " + this.c + " in " + property);
            }
        }
    }

    private abstract class CheckableString {
        private CheckableString() {
        }

        public abstract void check(String var1);
    }
}

