/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.helpers.ScmHelper;
import com.cenqua.crucible.helpers.TestDbConfigFactory;
import com.cenqua.crucible.helpers.TestDbControlFactory;
import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;

public class CreateUpgradeScripts {
    private DBControl createDB(DBControl dbControl, int ver) throws CruDBException, IOException {
        if (dbControl.getInfo().state().equals((Object)DBInfo.DBState.NO_DB)) {
            throw new IOException("Couldn't connect to " + dbControl.getInfo().type() + " DB Can't create upgrade");
        }
        if (dbControl.getInfo().state().equals((Object)DBInfo.DBState.STOPPED)) {
            dbControl.dropTables();
        }
        System.out.println("Creating " + dbControl.getInfo().type() + " db version " + ver);
        dbControl.start(ver);
        return dbControl;
    }

    private File createUpgradeFile(File dir, int fromVersion) throws IOException {
        File f = new File(dir, "upgrade/upgrade_" + fromVersion + ".sql");
        if (f.exists()) {
            f.delete();
        }
        if (f.createNewFile()) {
            ScmHelper.addFile(f.getCanonicalPath());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeUpgradeScript(File dir, int fromVer, DBControl dbControlFrom, DBControl dbControlTo) throws Exception {
        if (dbControlFrom == null || dbControlTo == null) {
            return;
        }
        Configuration cfg = Config.getConfig((DatabaseConfig)dbControlTo.getConfig(), (String)"upgradePoolNameDoesNotMatterHere");
        cfg.setProperty("hibernate.schema_update.unique_constraint_strategy", UniqueConstraintSchemaUpdateStrategy.RECREATE_QUIETLY.name());
        String dialectClassName = cfg.getProperty("hibernate.dialect");
        System.out.println("** Dialect = " + dialectClassName);
        Class<?> dialectClass = Class.forName(dialectClassName);
        Dialect dialect = (Dialect)dialectClass.newInstance();
        dbControlTo.stop();
        dbControlFrom.stop();
        Connection fromConn = dbControlFrom.getConnection();
        try {
            String[] script = cfg.generateSchemaUpdateScript(dialect, new DatabaseMetadata(fromConn, dialect));
            try (FileWriter upgradeFile = new FileWriter(this.createUpgradeFile(dir, fromVer));){
                for (String line : script) {
                    upgradeFile.write(line + ";\n");
                }
                upgradeFile.write("# Please note there is no need to bump up cru_version in this script anymore,\n");
                upgradeFile.write("# BumpDbVersionUpgradeTask would take care of this.\n");
            }
        }
        finally {
            dbControlFrom.closeConnection(fromConn);
            dbControlFrom.stop();
            dbControlTo.stop();
        }
    }

    public boolean execute(int from) {
        HashMap failedDBs = Maps.newHashMapWithExpectedSize((int)DBType.values().length);
        for (final DBType dbType : DBType.values()) {
            System.out.println("=== Starting processing for " + dbType);
            DBControl db1Control = TestDbControlFactory.getDBController(TestDbConfigFactory.getPrimaryDbName(), dbType);
            DBControl db2Control = (DBControl)dbType.accept((DBType.Visitor)new DBType.VisitorAdapter<DBControl>(){

                public DBControl visitDefault() {
                    return TestDbControlFactory.getDBController(TestDbConfigFactory.getSecondaryDbName(), dbType);
                }

                public DBControl visitOracle() {
                    return TestDbControlFactory.newSecondaryOracleController(TestDbConfigFactory.getPrimaryDbName());
                }
            });
            try {
                DatabaseConfig db1Config = db1Control.getConfig();
                System.out.println("== Creating from DB for " + dbType + ", as " + db1Config.getUsername() + " using " + db1Config.getJdbcURL());
                DBControl fromDb = this.createDB(db1Control, from);
                DatabaseConfig db2Config = db2Control.getConfig();
                System.out.println("== Creating to DB for " + dbType + ", as " + db2Config.getUsername() + " using " + db2Config.getJdbcURL());
                DBControl toDb = this.createDB(db2Control, DbVersion.getDatabaseVersion());
                System.out.println("== Generating upgrade scripts");
                this.makeUpgradeScript(new File(FisheyeTestEnv.WORKSPACE_DIR, TestDbControlFactory.getDBScriptPathFor(dbType)), from, fromDb, toDb);
            }
            catch (Exception e) {
                e.printStackTrace();
                failedDBs.put(dbType, e.getMessage());
            }
            System.out.println("=== Done processing for " + dbType + (failedDBs.containsKey(dbType) ? " with errors." : " with no errors. "));
        }
        boolean success = failedDBs.isEmpty();
        if (!success) {
            System.err.println("Failed to upgrade following databases: " + Joiner.on((String)"\n").withKeyValueSeparator(": ").join((Map)failedDBs));
        }
        return success;
    }

    public static void main(String[] args) {
        CreateUpgradeScripts baseUpgrade = new CreateUpgradeScripts();
        try {
            if (baseUpgrade.execute(DbVersion.getDatabaseVersion() - 1)) {
                System.out.println("Created example upgrade scripts");
            } else {
                System.err.println("Create failed for databases listed above, sorry.");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.err.println("Create failed, sorry, exception caught:");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

