/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.helpers.DbLint;
import com.cenqua.crucible.helpers.MySQLConstraintTransformer;
import com.cenqua.crucible.helpers.ScmHelper;
import com.cenqua.crucible.helpers.TestDbControlFactory;
import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.crucible.hibernate.dialects.FeCruMySQL5InnoDBDialect;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

public class CreateSchemaScripts {
    private static final Logger LOGGER = Logger.getLogger(CreateSchemaScripts.class);
    public static final String CREATE_TABLE_PREFIX = "create table";
    public static final Comparator<String> SCHEMA_SCRIPT_SORTER = (left, right) -> {
        boolean leftIsCreateTable = left.startsWith(CREATE_TABLE_PREFIX);
        boolean rightIsCreateTable = right.startsWith(CREATE_TABLE_PREFIX);
        if (leftIsCreateTable && !rightIsCreateTable) {
            return -1;
        }
        if (rightIsCreateTable && !leftIsCreateTable) {
            return 1;
        }
        return left.compareTo((String)right);
    };

    private static Properties getConfigProperties() {
        return new Properties();
    }

    private static Configuration getConfig(DBType dbType) {
        Configuration cfg = new Configuration();
        Config.addResources((Configuration)cfg);
        cfg.setProperty("hibernate.connection.autocommit", "false");
        cfg.setProperty("hibernate.connection.driver_class", dbType.getDriver());
        cfg.setProperty("hibernate.dialect", dbType.getDialect());
        return cfg;
    }

    private String schemaFilename(String dirName, String prefix) {
        return this.schemaFilename(dirName, prefix, DbVersion.getDatabaseVersion());
    }

    private String schemaFilename(String dirName, String prefix, int version) {
        return dirName + "schema/" + prefix + "_" + String.valueOf(version) + ".sql";
    }

    private File createSchemaFile(String dirName, String prefix) throws IOException {
        return this.createSchemaFile(dirName, prefix, DbVersion.getDatabaseVersion());
    }

    private File createSchemaFile(String dirName, String prefix, int version) throws IOException {
        String oldVersion;
        String filename = this.schemaFilename(dirName, prefix, version);
        File oldFile = new File(filename);
        if (oldFile.exists()) {
            oldFile.delete();
        }
        if (new File(oldVersion = this.schemaFilename(dirName, prefix, version - 1)).exists()) {
            ScmHelper.copyFile(oldVersion, filename);
        }
        return new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSchema(String dirName, Configuration cfg) throws Exception {
        Throwable throwable;
        LOGGER.info((Object)("Creating schema scripts under " + dirName + " for dialect " + cfg.getProperty("hibernate.dialect")));
        Class<?> dialectClass = Class.forName(cfg.getProperty("hibernate.dialect"));
        Dialect dialect = (Dialect)dialectClass.newInstance();
        String[] createScript = cfg.generateSchemaCreationScript(dialect);
        Arrays.sort(createScript, SCHEMA_SCRIPT_SORTER);
        File tablesFile = this.createSchemaFile(dirName, "tables");
        File constraintsFile = this.createSchemaFile(dirName, "constraints");
        Function<String, String> constraintTransform = this.prepareConstraintsTransformer(cfg, dialect);
        try (FileWriter tableWriter = new FileWriter(tablesFile);){
            throwable = null;
            try (FileWriter constraintsWriter = new FileWriter(constraintsFile);){
                boolean constraints = false;
                String[] stringArray = createScript;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String line = stringArray[i];
                    if (!constraints) {
                        if (line.startsWith(CREATE_TABLE_PREFIX)) {
                            tableWriter.write(line + ";\n");
                            continue;
                        }
                        tableWriter.write("insert into cru_version values (1," + DbVersion.getDatabaseVersion() + ");");
                        constraints = true;
                        constraintsWriter.write(line + ";\n");
                        continue;
                    }
                    String transformedLine = constraintTransform.apply(line);
                    if (transformedLine == null) continue;
                    constraintsWriter.write(transformedLine + ";\n");
                }
                LOGGER.info((Object)("Created table and constraints files " + tablesFile + " and " + constraintsFile));
            }
            catch (Throwable constraints) {
                throwable = constraints;
                throw constraints;
            }
        }
        finally {
            ScmHelper.addFile(tablesFile.getPath());
            ScmHelper.addFile(constraintsFile.getPath());
        }
        String[] dropScript = cfg.generateDropSchemaScript(dialect);
        Arrays.sort(dropScript, SCHEMA_SCRIPT_SORTER);
        File dropFile = this.createSchemaFile(dirName, "drop");
        try {
            throwable = null;
            try (FileWriter dropWriter = new FileWriter(dropFile);){
                for (String s : dropScript) {
                    if (Strings.isNullOrEmpty((String)s)) continue;
                    dropWriter.write(s + ";\n");
                }
                LOGGER.info((Object)("Created drop file " + dropFile));
            }
            catch (Throwable constraints) {
                throwable = constraints;
                throw constraints;
            }
        }
        finally {
            ScmHelper.addFile(dropFile.getPath());
        }
        String dataFile = this.schemaFilename(dirName, "data");
        if (!new File(dataFile).exists()) {
            int prev = DbVersion.getDatabaseVersion() - 1;
            String prevDataFile = this.schemaFilename(dirName, "data", prev);
            if (new File(prevDataFile).exists()) {
                ScmHelper.copyFile(prevDataFile, dataFile);
                LOGGER.info((Object)("Copied data file " + dataFile));
            } else {
                LOGGER.error((Object)("There is no data file and the previous version doesn't exist: " + prevDataFile));
            }
        }
    }

    private Function<String, String> prepareConstraintsTransformer(Configuration cfg, Dialect dialect) {
        Function<String, String> constraintTransform = Function.identity();
        if (dialect instanceof FeCruMySQL5InnoDBDialect) {
            constraintTransform = constraintTransform.compose(new MySQLConstraintTransformer(cfg, dialect));
        }
        return constraintTransform;
    }

    public void execute() throws Exception {
        String relativeDir = "../../";
        for (DBType dbType : DBType.values()) {
            this.saveSchema("../../" + TestDbControlFactory.getDBScriptPathFor(dbType), CreateSchemaScripts.getConfig(dbType));
        }
    }

    public boolean test() throws IOException {
        DbLint dbLint = new DbLint();
        dbLint.testMappingLint();
        if (dbLint.hasErrors()) {
            System.err.println("Mapping files have errors");
            for (String message : dbLint.getErrors()) {
                System.err.println(message);
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        CreateSchemaScripts cdbs = new CreateSchemaScripts();
        try {
            if (cdbs.test()) {
                cdbs.execute();
                System.out.println("Created DB schema");
                return;
            }
            System.err.println("Create failed for the reasons above, sorry.");
            System.exit(-1);
        }
        catch (Exception e) {
            System.err.println("Create failed, sorry. Exception caught:");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

