/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible;

import com.cenqua.SystemPropertyBackup;
import com.cenqua.crucible.CrucibleSysProps;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrucibleSysPropsTest {
    private final SystemPropertyBackup REVIEW_CONTENT_SIZE_PROP_BACKUP = new SystemPropertyBackup("crucible.review.content.size.limit");

    @Before
    public void setUp() throws Exception {
        this.REVIEW_CONTENT_SIZE_PROP_BACKUP.backup();
    }

    @After
    public void tearDown() throws Exception {
        this.REVIEW_CONTENT_SIZE_PROP_BACKUP.restore();
    }

    @Test
    public void testReviewFileRevisionsLimit() throws Exception {
        Assert.assertThat((String)"default values should be 800", (Object)CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT, (Matcher)CoreMatchers.is((Object)800));
        System.setProperty("crucible.review.content.size.limit", "thousand");
        CrucibleSysProps.reloadProperties();
        Assert.assertThat((String)"invalid integer property should be ignored, so default value should be used", (Object)CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT, (Matcher)CoreMatchers.is((Object)800));
        System.setProperty("crucible.review.content.size.limit", "12345");
        CrucibleSysProps.reloadProperties();
        Assert.assertThat((String)"valid integer property should be honoured", (Object)CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT, (Matcher)CoreMatchers.is((Object)12345));
    }
}

