/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.util;

import com.atlassian.fisheye.functest.util.WebTesterFactory;
import com.cenqua.fisheye.logging.Logs;
import java.util.Arrays;
import net.sourceforge.jwebunit.junit.WebTester;
import org.apache.log4j.Logger;

public class WebHelper {
    private final WebTester driver;
    private final WebTesterFactory factory;
    private static final Logger LOG = Logs.APP_LOG;

    public WebHelper(WebTesterFactory factory) {
        this.factory = factory;
        this.driver = factory.getTester();
    }

    public WebTester getDriver() {
        return this.driver;
    }

    public void assertAtOneOf(String expectedPageName, String ... pages) {
        String urlPath = this.driver.getTestingEngine().getPageURL().getPath();
        if (!this.factory.getContext().equals("")) {
            urlPath = urlPath.substring(urlPath.indexOf("/", urlPath.indexOf("/") + 1));
        }
        Arrays.sort(pages);
        int index = Arrays.binarySearch(pages, urlPath);
        if (index < 0) {
            LOG.info((Object)("Current Page Text Dump: " + this.driver.getTestingEngine().getPageText()));
            throw new IllegalStateException(String.format("This is not the %s page : [%s]. Must be one of: %s", expectedPageName, urlPath, Arrays.asList(pages)));
        }
    }
}

