/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.util;

import com.atlassian.fisheye.functest.util.Product;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;

public class ProductRunner {
    Process proc;
    LineNumberReader output;
    final Product product;

    public ProductRunner(Product product) {
        this.product = product;
    }

    public int start() throws IOException {
        System.out.println("starting product = " + this.product.getName() + " in dir: " + this.product.getInstallDir());
        String execPath = this.product.getInstallDir().getAbsolutePath() + "/bin/run.sh";
        this.proc = new ProcessBuilder(execPath).redirectErrorStream(true).directory(this.product.getInstallDir()).start();
        this.output = new LineNumberReader(new BufferedReader(new InputStreamReader(this.proc.getInputStream())));
        return -1;
    }

    public void waitUntilStarted() throws IOException {
        if (this.product.isStandalone()) {
            this.startAndBlockUntil("INFO  - Server started on ");
        }
    }

    public void startAndBlockUntil(String textAppears) throws IOException {
        this.start();
        System.out.println("Waiting until text appears = " + textAppears);
        String lineOut = this.readLineOfOutput();
        do {
            System.out.println("SERVER-OUT (" + lineOut.contains(textAppears) + ") " + lineOut);
        } while ((lineOut == null || !lineOut.contains(textAppears)) && (lineOut = this.readLineOfOutput()) != null);
        new Thread(){

            @Override
            public void run() {
                ProductRunner.this.printProcOutputTo(System.out);
            }
        }.start();
    }

    private void printProcOutputTo(PrintStream out) {
        try {
            String line = this.readLineOfOutput();
            do {
                out.println("SERVER-OUT " + line);
            } while ((line = this.readLineOfOutput()) != null);
        }
        catch (IOException e) {
            System.out.println("Process terminated: " + e.getMessage());
        }
    }

    public void stop() throws InterruptedException {
        if (this.proc != null) {
            System.out.println("Trying to kill server");
            this.proc.destroy();
            System.out.println("Waiting for server to die");
            this.proc.waitFor();
            System.out.println("Server seems dead");
        }
    }

    public String readLineOfOutput() throws IOException {
        return this.output.readLine();
    }
}

