/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.pages;

import com.atlassian.fisheye.functest.util.Product;
import com.atlassian.web.setup.pages.BasePage;
import com.atlassian.web.setup.pages.InclusionPage;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.Select;

public class MacPage
extends BasePage {
    private static final By EULA = By.id((String)"eulaConfirm");
    private static final By PRODUCT_KEY = By.id((String)"productKey");

    public MacPage(Product product) {
        super(product);
    }

    public String getUrl() {
        return "https://id.atlassian.com/login?continue=https%3A%2F%2Fmy.atlassian.com&application=mac";
    }

    @Override
    public List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.getUrl());
        urls.add("https://my.atlassian.com/license/evaluation");
        urls.add("https://id.atlassian.com/login");
        return urls;
    }

    public InclusionPage retrieveEvalLicense() {
        if (this.isLoginFormVisible()) {
            this.logIn();
        }
        this.driver.waitUntilElementIsVisible(PRODUCT_KEY);
        new Select(this.driver.findElement(PRODUCT_KEY)).selectByVisibleText(this.product.getName() + " (Server)");
        this.driver.waitUntilElementIsVisible(EULA);
        this.driver.findElement(EULA).click();
        this.driver.findElement(By.cssSelector((String)"[name=\"_action_evaluation\"]")).click();
        this.driver.waitUntilElementIsVisible(By.id((String)"callbackbox"));
        String action = this.driver.executeScript("return $('#callbackform').attr('action');", new Object[0]).toString();
        String name = this.driver.executeScript("return $('#callbackform > textarea').attr('name');", new Object[0]).toString();
        String license = this.driver.executeScript("return $('#callbackform textarea').val();", new Object[0]).toString();
        String url = action + "?" + name + "=" + ExpressionUtil.deprecatedUrlPathEncode((Object)license);
        this.driver.navigate().to(url);
        return (InclusionPage)this.pageBinder.bind(InclusionPage.class, new Object[]{this.product});
    }

    private boolean isLoginFormVisible() {
        return this.driver.elementIsVisible(By.id((String)"username"));
    }

    private void logIn() {
        this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{"fe-cru-func-test-user@atlassian.com"});
        this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{"he3jbyMc9Xdn"});
        this.driver.findElement(By.cssSelector((String)"#login-submit")).click();
    }
}

