/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.pages;

import com.atlassian.fisheye.functest.util.Product;
import com.atlassian.web.setup.pages.BasePage;
import com.atlassian.web.setup.pages.InclusionPage;
import com.atlassian.web.setup.pages.MacPage;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class LicensePage
extends BasePage {
    public LicensePage(Product product) {
        super(product);
    }

    public String getUrl() {
        return "/setup/" + this.product.getName() + "License-view.do";
    }

    @Override
    public List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.getUrl());
        urls.add("/setup/save" + this.product.getName() + "License.do");
        return urls;
    }

    public InclusionPage enterValidLicense(String license) {
        this.setAndSubmitLicense(license);
        return (InclusionPage)this.pageBinder.bind(InclusionPage.class, new Object[]{this.product});
    }

    public MacPage requestEvalLicenseFromMac() {
        this.driver.findElement(By.linkText((String)"Obtain evaluation license")).click();
        return (MacPage)this.pageBinder.bind(MacPage.class, new Object[]{this.product});
    }

    public LicensePage enterInvalidLicense(String invalidLicense) {
        this.setAndSubmitLicense(invalidLicense);
        return (LicensePage)this.pageBinder.bind(LicensePage.class, new Object[]{this.product});
    }

    public String getErrorMessage() {
        return this.driver.findElement(By.cssSelector((String)"span.errorMessage")).getText();
    }

    public String getServerId() {
        return this.driver.findElement(By.id((String)"serverId")).getText();
    }

    public String getText() {
        return this.driver.getPageSource();
    }

    private void setAndSubmitLicense(String license) {
        String name = this.product.getName() + "License";
        if (!this.driver.elementIsVisible(By.name((String)name))) {
            this.driver.findElement(By.linkText((String)"Enter existing license")).click();
            this.driver.waitUntilElementIsVisible(By.name((String)name));
        }
        WebElement textArea = this.driver.findElement(By.name((String)name));
        textArea.clear();
        textArea.sendKeys(new CharSequence[]{license});
        this.driver.findElement(By.id((String)"submit")).click();
    }
}

