/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.pages;

import com.atlassian.fisheye.functest.util.Product;
import com.atlassian.web.setup.pages.BasePage;
import com.atlassian.web.setup.pages.JiraConnectPage;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class InclusionPage
extends BasePage {
    public InclusionPage(Product product) {
        super(product);
    }

    public String getUrl() {
        return "/setup/include" + this.product.getOtherProduct().getName() + "-default.do";
    }

    @Override
    public List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.getUrl());
        urls.add("/setup/include" + this.product.getOtherProduct().getName() + "License.do");
        return urls;
    }

    public JiraConnectPage enterValidLicense(String license) {
        this.setAndSubmitLicense(license);
        return (JiraConnectPage)this.pageBinder.bind(JiraConnectPage.class, new Object[]{this.product});
    }

    public JiraConnectPage skipInclusion() {
        this.driver.findElement(By.cssSelector((String)"#skipStep > a")).click();
        return (JiraConnectPage)this.pageBinder.bind(JiraConnectPage.class, new Object[]{this.product});
    }

    public JiraConnectPage enterIncludeCrucible() {
        this.driver.findElement(By.cssSelector((String)".next > input")).click();
        return (JiraConnectPage)this.pageBinder.bind(JiraConnectPage.class, new Object[]{this.product});
    }

    public JiraConnectPage enterNext() {
        this.driver.findElement(By.cssSelector((String)".next > input")).click();
        return (JiraConnectPage)this.pageBinder.bind(JiraConnectPage.class, new Object[]{this.product});
    }

    private void setAndSubmitLicense(String license) {
        String id = this.product.getOtherProduct().getName() + "License";
        if (!this.driver.elementIsVisible(By.id((String)id))) {
            this.driver.findElement(By.linkText((String)"Enter existing license")).click();
            this.driver.waitUntilElementIsVisible(By.id((String)id));
        }
        WebElement textArea = this.driver.findElement(By.id((String)id));
        textArea.clear();
        textArea.sendKeys(new CharSequence[]{license});
        this.driver.findElement(By.cssSelector((String)".next > input")).click();
    }
}

