/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup.pages;

import com.atlassian.fisheye.functest.util.Product;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class BasePage
implements Page {
    final Product product;
    public static final int DEFAULT_PAGE_TIMEOUT = 20;
    @Inject
    protected AtlassianWebDriver driver;
    @Inject
    protected PageBinder pageBinder;

    protected BasePage(Product product) {
        this.product = product;
    }

    @WaitUntil
    public void doWait() {
        try {
            this.driver.waitUntil((Function)new Function<WebDriver, Boolean>(){

                public Boolean apply(@Nullable WebDriver input) {
                    return BasePage.this.isHere();
                }
            }, 20);
        }
        catch (TimeoutException e) {
            Assert.fail((String)String.format("Page failed to load at expected URL.\n\t\tExpected: %s\n\t\tActual: %s", this.getUrl(), this.driver.getCurrentUrl()));
        }
        this.driver.waitUntilElementIsLocated(By.tagName((String)"html"));
    }

    public boolean isHere() {
        String url;
        String urlWithoutVariables = url.substring(0, (url = this.driver.getCurrentUrl()).contains("?") ? url.indexOf(63) : (url.contains("#") ? url.indexOf("#") : url.length()));
        for (String expected : this.getUrls()) {
            if (!url.endsWith(expected) && !urlWithoutVariables.endsWith(expected)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasElementWithText(By by, String message) {
        try {
            List lis = this.driver.findElements(by);
            for (WebElement li : lis) {
                if (!li.getText().trim().equals(message.trim())) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    protected void pagePop(Runnable runnable) {
        BasePage.waitForPagePop(this.driver, runnable);
    }

    public static void waitForPagePop(AtlassianWebDriver driver, final Function<WebDriver, Boolean> isNewPage) {
        driver.waitUntil((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(@Nullable WebDriver input) {
                try {
                    return (Boolean)isNewPage.apply((Object)input);
                }
                catch (StaleElementReferenceException sere) {
                    return false;
                }
            }
        });
    }

    public static void waitForPagePop(AtlassianWebDriver driver, Runnable runnable) {
        driver.executeScript("window.pagePopExpected = true;", new Object[0]);
        runnable.run();
        driver.waitUntil((Function)new ScriptIsTrueCondition("return window && window.pagePopExpected !== true;", new Object[0]));
    }

    public static void waitUntilNotVisible(AtlassianWebDriver driver, final PageElement element) {
        driver.waitUntil((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver input) {
                try {
                    return !element.isPresent() || !element.isVisible();
                }
                catch (StaleElementReferenceException sere) {
                    return true;
                }
            }
        });
    }

    public List<String> getUrls() {
        return Collections.singletonList(this.getUrl());
    }

    public static class ScriptIsTrueCondition
    implements Function<WebDriver, Boolean> {
        private final String script;
        private final Object[] args;

        public ScriptIsTrueCondition(String script, Object ... args) {
            this.script = script;
            this.args = args;
        }

        public Boolean apply(WebDriver webDriver) {
            try {
                Object result = ((JavascriptExecutor)webDriver).executeScript(this.script, this.args);
                return (Boolean)result;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

