/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.setup;

import com.atlassian.fisheye.functest.util.ConfigHelper;
import com.atlassian.fisheye.functest.util.Product;
import com.atlassian.fisheye.functest.util.ProductFactory;
import com.atlassian.pageobjects.DefaultProductInstance;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.web.setup.pages.AdminLoginPage;
import com.atlassian.web.setup.pages.AdminPasswordPage;
import com.atlassian.web.setup.pages.FinishedPage;
import com.atlassian.web.setup.pages.InclusionPage;
import com.atlassian.web.setup.pages.JiraConnectPage;
import com.atlassian.web.setup.pages.LicensePage;
import com.atlassian.web.setup.pages.MacPage;
import com.atlassian.web.setup.util.ProductRunner;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.FishEyeTestedProduct;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.io.IOHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupFuncTest {
    private static final Logger log = LoggerFactory.getLogger(SetupFuncTest.class);
    ProductRunner runner;
    ConfigHelper confHelper;
    final boolean restartServerPerTest = true;
    private FishEyeTestedProduct fisheyeTestedProduct = (FishEyeTestedProduct)TestedProductFactory.create(FishEyeTestedProduct.class, (ProductInstance)new DefaultProductInstance("http://localhost:6060/", "fecru", 6060, ""), null);
    @Rule
    public MethodRule rule = new TestWatchman(){
        private String destinationFolder;

        public void starting(FrameworkMethod method) {
            System.out.println("STARTING!!!");
            this.destinationFolder = "target/webdriverTests/" + method.getMethod().getDeclaringClass().getName();
            File dir = new File(this.destinationFolder);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }

        public void failed(Throwable e, FrameworkMethod method) {
            System.out.println("FAILED!!!");
            AtlassianWebDriver driver = SetupFuncTest.this.fisheyeTestedProduct.getAtlassianWebDriver();
            String baseFileName = this.destinationFolder + File.separator + method.getName();
            File dumpFile = new File(baseFileName + ".html");
            log.error(e.getMessage(), e);
            log.info("----- Test Failed. " + e.getMessage());
            log.info("----- At page: " + driver.getCurrentUrl());
            log.info("----- Dumping page source to: " + dumpFile.getAbsolutePath());
            driver.dumpSourceTo(dumpFile);
            driver.takeScreenshotTo(new File(baseFileName + ".png"));
        }
    };

    @BeforeClass
    public static void disableForWindows() {
        Assume.assumeTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
    }

    @Before
    public void setUp() throws Exception {
        this.confHelper = new ConfigHelper();
        this.setupProduct(ProductFactory.newFishEyeProduct());
        this.setupProduct(ProductFactory.newCrucibleProduct());
    }

    private void setupProduct(Product product) throws IOException, ConfigException {
        this.tearDownProduct(product);
        this.confHelper.loadAppConfig(product);
        this.confHelper.backupConfigIfNeeded(product);
        AppConfig.getsConfig().getConfig().getWebServer().getHttp().setBind(":6060");
        AppConfig.getsConfig().saveConfig();
    }

    private void tearDownProduct(Product product) {
        File lockFile = new File(product.getInstallDir() + "/var", "fisheye.lck");
        IOHelper.deleteFile((File)lockFile);
    }

    @After
    public void tearDown() throws Exception {
        if (this.runner != null) {
            this.runner.stop();
        }
        this.tearDownProduct(ProductFactory.newCrucibleProduct());
        this.tearDownProduct(ProductFactory.newFishEyeProduct());
    }

    private void startServer(Product prod) throws IOException {
        this.runner = new ProductRunner(prod);
        this.runner.waitUntilStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallFishEyeWithCrucible() throws IOException, ConfigException {
        Product fishEye = ProductFactory.newFishEyeProduct();
        try {
            this.startServer(fishEye);
            this.confHelper.restoreProductConfig(fishEye);
            LicensePage licPage = (LicensePage)this.fisheyeTestedProduct.visit(LicensePage.class, new Object[]{fishEye});
            LicensePage licPageWithError = licPage.enterInvalidLicense("LICENSE IS INVALID");
            Assert.assertEquals((Object)"This license can not be decoded.", (Object)licPage.getErrorMessage());
            licPageWithError = licPageWithError.enterInvalidLicense("");
            Assert.assertEquals((Object)"License is not set.", (Object)licPage.getErrorMessage());
            licPageWithError = licPageWithError.enterInvalidLicense("nOnmmHxExnLDwaOGsEhRGCgjpnxUoUIMGjmqVgVwFvugdh\nmi2K<TZmRgd2lEYIupqfwaOr2KVGyH>C3PXkNYyQM8TXR6\nNmOMUVnNoNPPrnmOQoPutNOpONMrQoPpNRWWTWWtWUvwsv\numRPnnpmUUnnuqtstommmmmUUnnuqtstommmmmUU1qiXpp\nfXkUUnmm");
            Assert.assertEquals((Object)"You've entered a Crucible license. Please enter a FishEye license instead.", (Object)licPage.getErrorMessage());
            RootConfig rootConfig = new RootConfig();
            rootConfig.load(this.confHelper.getProductConfig(fishEye));
            Assert.assertEquals((String)"SID from license page does not match SID from configuration", (Object)rootConfig.getConfig().getLicense().getSID(), (Object)licPage.getServerId());
            InclusionPage includePage = licPageWithError.enterValidLicense("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
            JiraConnectPage jiraConnectPage = includePage.enterValidLicense("AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
            AdminPasswordPage pwdPage = jiraConnectPage.skipThisStep();
            pwdPage = pwdPage.enterInvalidPasswords("short", "short");
            Assert.assertEquals((Object)"Your admin password must be at least 6 characters, and preferably a mixture of numbers and letters", (Object)pwdPage.getErrorMessage());
            FinishedPage finalPage = pwdPage.enterValidPassword("password");
            AdminLoginPage adminLoginPage = finalPage.clickAddRepoButton();
            adminLoginPage.enterAdminPassword("password");
            this.confHelper.loadAppConfig(fishEye);
            Assert.assertTrue((boolean)this.confHelper.isFishEye());
            Assert.assertTrue((boolean)this.confHelper.isCrucible());
            Assert.assertFalse((boolean)this.confHelper.isCrucibleOnly());
            Assert.assertFalse((boolean)this.confHelper.isFishEyeOnly());
            Assert.assertTrue((boolean)this.confHelper.isAdminPasswordSet());
        }
        finally {
            this.confHelper.restoreProductConfig(fishEye);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallFishEyeWithoutCrucible() throws IOException, ConfigException {
        Product fishEye = ProductFactory.newFishEyeProduct();
        try {
            this.startServer(fishEye);
            this.confHelper.restoreProductConfig(fishEye);
            LicensePage licPage = (LicensePage)this.fisheyeTestedProduct.visit(LicensePage.class, new Object[]{fishEye});
            RootConfig rootConfig = new RootConfig();
            rootConfig.load(this.confHelper.getProductConfig(fishEye));
            Assert.assertEquals((String)"SID from license page does not mage SID from configuration", (Object)rootConfig.getConfig().getLicense().getSID(), (Object)licPage.getServerId());
            InclusionPage includePage = licPage.enterValidLicense("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
            JiraConnectPage jiraConnectPage = includePage.skipInclusion();
            AdminPasswordPage pwdPage = jiraConnectPage.skipThisStep();
            FinishedPage finalPage = pwdPage.enterValidPassword("password");
            AdminLoginPage adminLoginPage = finalPage.clickAddRepoButton();
            adminLoginPage.enterAdminPassword("password");
            this.confHelper.loadAppConfig(fishEye);
            Assert.assertTrue((boolean)this.confHelper.isFishEye());
            Assert.assertTrue((boolean)this.confHelper.isFishEyeOnly());
            Assert.assertFalse((boolean)this.confHelper.isCrucible());
            Assert.assertTrue((boolean)this.confHelper.isAdminPasswordSet());
        }
        finally {
            this.confHelper.restoreProductConfig(fishEye);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallEvalFishEyeWithCrucible() throws IOException, ConfigException {
        Product fishEye = ProductFactory.newFishEyeProduct();
        try {
            this.startServer(fishEye);
            this.confHelper.restoreProductConfig(fishEye);
            LicensePage licPage = (LicensePage)this.fisheyeTestedProduct.visit(LicensePage.class, new Object[]{fishEye});
            MacPage macPage = licPage.requestEvalLicenseFromMac();
            InclusionPage includePage = macPage.retrieveEvalLicense();
            JiraConnectPage jiraConnectPage = includePage.enterIncludeCrucible();
            AdminPasswordPage pwdPage = jiraConnectPage.skipThisStep();
            FinishedPage finalPage = pwdPage.enterValidPassword("password");
            AdminLoginPage adminLoginPage = finalPage.clickAddRepoButton();
            adminLoginPage.enterAdminPassword("password");
            this.confHelper.loadAppConfig(fishEye);
            Assert.assertTrue((boolean)this.confHelper.isFishEye());
            Assert.assertFalse((boolean)this.confHelper.isFishEyeOnly());
            Assert.assertTrue((boolean)this.confHelper.isCrucible());
            Assert.assertTrue((boolean)this.confHelper.isAdminPasswordSet());
        }
        finally {
            this.confHelper.restoreProductConfig(fishEye);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallEvalCrucibleWithFishEye() throws IOException, ConfigException {
        Product crucible = ProductFactory.newCrucibleProduct();
        try {
            this.startServer(crucible);
            this.confHelper.restoreProductConfig(crucible);
            LicensePage licPage = (LicensePage)this.fisheyeTestedProduct.visit(LicensePage.class, new Object[]{crucible});
            MacPage macPage = licPage.requestEvalLicenseFromMac();
            InclusionPage includePage = macPage.retrieveEvalLicense();
            JiraConnectPage jiraConnectPage = includePage.enterNext();
            AdminPasswordPage pwdPage = jiraConnectPage.skipThisStep();
            FinishedPage finalPage = pwdPage.enterValidPassword("password");
            AdminLoginPage adminLoginPage = finalPage.clickAddRepoButton();
            adminLoginPage.enterAdminPassword("password");
            this.confHelper.loadAppConfig(crucible);
            Assert.assertTrue((boolean)this.confHelper.isFishEye());
            Assert.assertFalse((boolean)this.confHelper.isFishEyeOnly());
            Assert.assertTrue((boolean)this.confHelper.isCrucible());
            Assert.assertTrue((boolean)this.confHelper.isAdminPasswordSet());
        }
        finally {
            this.confHelper.restoreProductConfig(crucible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstallCrucibleWithFishEye() throws IOException, ConfigException {
        Product crucible = ProductFactory.newCrucibleProduct();
        try {
            this.startServer(crucible);
            this.confHelper.restoreProductConfig(crucible);
            LicensePage licPage = (LicensePage)this.fisheyeTestedProduct.visit(LicensePage.class, new Object[]{crucible});
            InclusionPage includePage = licPage.enterValidLicense("AAABkA0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyotp1akBAHYotXMRW4EiHtumBojc2G4kU+HDqf1/GD9QNmvPuzHw7+64KCLOwgWwM6WQ6Gk1HKdQVgyy9GpNl6Bq05WPt0Lr8KiXMaC+kX4oOc9EYa57dk/okfCucU0In0nTkLli5FQ4L4TF/saHpNc3G5FZJ1A6rfY8HPSsXC75i89ntecR/98ruD7qgW9Upj+tzJF8I1b6ZeY92h3Ze5Dd8wumo+J7RD+XXCf3y/uM1kTZI1bSYXBBcpv9v/ppwMBgsy4p+Llf0blUWNavm5ZLW9zwOcmYxMq+h2YPfIpxsgGtp1miht+YXSg8/tt73D9PhcGOSf/CH7VFB8aj4mUBhQBsPa+W8VU3wGJ2VA29ABudNF/+RkFiJ9qiFlpfVZWl2rjzCsRWfVbygN99eSN/q74QcC6z1kzbPmpR2I7Rywiuj89l5+W9X8SVqh7m3Acnh/rj3+uMFOmlVf7BgJ+HDFJjpIr9UoiV8J9pwzHgUrUPyB37u3yEwLAIUR/jwO+7JuGUuC0m+noQv2AQ8nScCFBqhmxM/enSI22QiZSrT8F3qbyggX02jb");
            JiraConnectPage jiraConnectPage = includePage.enterValidLicense("AAABkw0ODAoPeNp1kUtv2zAQhO/8FQv0ZoCyrMR1akBAHIkpXMRW4EiHtMmBptc2E4kU+HCqf1/GD8ANkiuXs9/M7LfSI0z8BpIhxKPx5WAcx1CVGSTxYEjW0m6xw+hOClQWy67FNCtmM7bIppM7MvfNEk2xriwamw5ikmnluHBz3mDKl9roN/sqr7mrubWSq0johtx7I7bcYs4dpu8UGl/RZEjOGHv9Gec4Yn9babq9zqtaNtLh6oRkMy7rL5mf5PjIeECzQzPN0xs2YvQy/53Q78WvEf158eOK9Hq9eVHS22JB7xdFXmXltJjT6oGFQZoZDJZWsOzAbRGODGBK6BUaaI1+QeHgz9a59mnc72909J+7fn1QUDwoniPINSjtYCWtM3LpHYbN0oLTILx1ugl1RyQkVg4VV+K8mSROTo0Gc9mCTUqW05vHd6df1XO0HMJX6lXpN0UKs+FKWu6kVunk9Jnso4anj7c79RsOIXeYOuOR5GiFke1+w22Ysw6fxpDpJrgXkteE7XjtD4Q1ry2Sf/fM3YowLQIUVv9q4uFYR6m3CfQkgP2hGg5HRtgCFQCT/yGXA8mPLzsy+9U54BdMKG/zvg==X02jj");
            AdminPasswordPage pwdPage = jiraConnectPage.skipThisStep();
            FinishedPage finalPage = pwdPage.enterValidPassword("password");
            AdminLoginPage adminLoginPage = finalPage.clickAddRepoButton();
            adminLoginPage.enterAdminPassword("password");
            this.confHelper.loadAppConfig(crucible);
            Assert.assertTrue((boolean)this.confHelper.isFishEye());
            Assert.assertFalse((boolean)this.confHelper.isFishEyeOnly());
            Assert.assertTrue((boolean)this.confHelper.isCrucible());
            Assert.assertTrue((boolean)this.confHelper.isAdminPasswordSet());
        }
        finally {
            this.confHelper.restoreProductConfig(crucible);
        }
    }
}

