/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.xwork;

import com.atlassian.xwork.XsrfTokenGenerator;
import com.cenqua.fisheye.web.util.XsrfCheckInterceptor;
import com.cenqua.fisheye.web.util.XsrfGenerateInterceptor;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorMapping;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.interceptor.ParametersInterceptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;

public class WebWorkConfigTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ConfigurationManager.setConfiguration(null);
        ConfigurationManager.clearConfigurationProviders();
        ObjectFactory.setObjectFactory((ObjectFactory)this.createObjectFactory());
    }

    public void testWebworkConfig() {
        Configuration cfg = ConfigurationManager.getConfiguration();
        this.assertSane(cfg);
        for (Object key : cfg.getPackageConfigNames()) {
            String name = (String)key;
            PackageConfig pkgCfg = cfg.getPackageConfig(name);
            this.assertSafe(pkgCfg);
        }
    }

    private void assertSane(Configuration cfg) {
        TreeSet<String> expectedPackages = new TreeSet<String>(Arrays.asList("webwork-default", "feDefault", "crucible", "profile", "fe", "fecru", "action", "login", "fecruDefault", "admin", "setup"));
        WebWorkConfigTest.assertEquals(expectedPackages, new TreeSet(cfg.getPackageConfigNames()));
    }

    private void assertSafe(PackageConfig pkgCfg) {
        Collection interceptorConfigs = pkgCfg.getAllInterceptorConfigs().values();
        for (Object icfg : interceptorConfigs) {
            InterceptorConfig cfg;
            if (icfg instanceof InterceptorConfig) {
                cfg = (InterceptorConfig)icfg;
                this.assertSafe(cfg);
                continue;
            }
            cfg = (InterceptorStackConfig)icfg;
            this.assertSafe((InterceptorStackConfig)cfg);
        }
        Map actions = pkgCfg.getAllActionConfigs();
        Iterator iterator = actions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            ActionConfig acfg = (ActionConfig)entry.getValue();
            List interceptors = acfg.getInterceptors();
            for (InterceptorMapping interceptor : interceptors) {
                this.assertSafe(interceptor);
            }
        }
    }

    private void assertSafe(InterceptorStackConfig cfg) {
        Collection mappings = cfg.getInterceptors();
        for (InterceptorMapping mapping : mappings) {
            this.assertSafe(mapping);
        }
    }

    private void assertSafe(InterceptorMapping mapping) {
        WebWorkConfigTest.assertFalse((boolean)(mapping.getInterceptor() instanceof ParametersInterceptor));
    }

    private void assertSafe(InterceptorConfig cfg) {
        String unwanted = ParametersInterceptor.class.getName();
        WebWorkConfigTest.assertFalse((boolean)unwanted.equals(cfg.getClassName()));
    }

    private ObjectFactory createObjectFactory() {
        final XsrfTokenGenerator tokenGenerator = new XsrfTokenGenerator(){

            public String getToken(HttpServletRequest request, boolean create) {
                return null;
            }

            public String generateToken(HttpServletRequest request) {
                return null;
            }

            public String getXsrfTokenName() {
                return null;
            }

            public boolean validateToken(HttpServletRequest request, String token) {
                return false;
            }
        };
        return new ObjectFactory(){

            public Object buildBean(Class clazz, Map extraContext) throws Exception {
                if (clazz == XsrfGenerateInterceptor.class) {
                    return new XsrfGenerateInterceptor(tokenGenerator);
                }
                if (clazz == XsrfCheckInterceptor.class) {
                    return new XsrfCheckInterceptor(tokenGenerator);
                }
                return super.buildBean(clazz, extraContext);
            }
        };
    }
}

