/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.cenqua.fisheye.web.filters.TotalityFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class WebTestUtil {
    public static HttpServletRequest mockRequestUrl(String stringUrl, String path) throws MalformedURLException {
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        URL url = new URL(stringUrl);
        Mockito.when((Object)requestMock.getScheme()).thenReturn((Object)url.getProtocol());
        Mockito.when((Object)requestMock.getServerName()).thenReturn((Object)url.getHost());
        Mockito.when((Object)requestMock.getServerPort()).thenReturn((Object)url.getPort());
        Mockito.when((Object)requestMock.getContextPath()).thenReturn((Object)url.getPath());
        Mockito.when((Object)requestMock.getRequestURI()).thenReturn((Object)(url.getPath() + path));
        return requestMock;
    }

    public static void runInRequestScope(HttpServletRequest request, Runnable r) throws IOException, ServletException {
        AtomicBoolean called = new AtomicBoolean(false);
        new TotalityFilter(null, null, null, null, null){

            protected boolean requiresSetup() {
                return false;
            }

            protected boolean missingLicenseOrGracePeriodExpired() {
                return false;
            }
        }.doFilter((ServletRequest)request, (ServletResponse)Mockito.mock(HttpServletResponse.class), (request1, response) -> {
            r.run();
            called.set(true);
        });
        Assert.assertThat((String)"test run inside request scope", (Object)called.get(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
    }
}

