/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.fisheye.web.SimpleSiteUrlBuilder;
import com.atlassian.fisheye.web.WebTestUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SimpleSiteUrlBuilderTest {
    private SimpleSiteUrlBuilder simpleSiteUrlBuilder;
    private RootConfig orgRootConfig;
    private RootConfig rootConfigMock;

    @Before
    public void setUp() throws Exception {
        this.simpleSiteUrlBuilder = new SimpleSiteUrlBuilder();
        this.orgRootConfig = AppConfig.getsConfig();
        this.rootConfigMock = (RootConfig)Mockito.mock(RootConfig.class);
        AppConfig.resetConfig((RootConfig)this.rootConfigMock);
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.resetConfig((RootConfig)this.orgRootConfig);
    }

    @Test
    public void testGetSiteUrl() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getSiteURL()).thenReturn((Object)"http://my.site.com/ctx");
        Assert.assertThat((String)"when called outside request scope, expect configured site URL", (Object)this.simpleSiteUrlBuilder.getSiteUrl(null), (Matcher)CoreMatchers.equalTo((Object)"http://my.site.com/ctx"));
        HttpServletRequest requestMock = WebTestUtil.mockRequestUrl("http://myLocalName/myCtx", "/static/file.txt");
        WebTestUtil.runInRequestScope(requestMock, () -> Assert.assertThat((String)"when called inside request scope, expect absolute path to request context path", (Object)this.simpleSiteUrlBuilder.getSiteUrl(null), (Matcher)CoreMatchers.equalTo((Object)"http://myLocalName/myCtx")));
        requestMock = WebTestUtil.mockRequestUrl("https://otherName/", "");
        Assert.assertThat((String)"called with request argument", (Object)this.simpleSiteUrlBuilder.getSiteUrl(requestMock), (Matcher)CoreMatchers.equalTo((Object)"https://otherName/"));
        requestMock = WebTestUtil.mockRequestUrl("https://otherName/CTX", "/dashboard");
        Assert.assertThat((String)"called with another request argument", (Object)this.simpleSiteUrlBuilder.getSiteUrl(requestMock), (Matcher)CoreMatchers.equalTo((Object)"https://otherName/CTX"));
    }

    @Test
    public void testGetConfiguredSiteURL() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getSiteURL()).thenReturn((Object)"http://my.site.com/ctx");
        Assert.assertThat((Object)this.simpleSiteUrlBuilder.getConfiguredSiteURL(), (Matcher)CoreMatchers.equalTo((Object)"http://my.site.com/ctx"));
    }

    @Test
    public void testGetSiteContextPath() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getContextPath()).thenReturn((Object)"/configured/context/path");
        HttpServletRequest requestMock = WebTestUtil.mockRequestUrl("http://server/requestContextPath", "/static/script.js");
        Assert.assertThat((String)"when requesting configured context path, you get it", (Object)this.simpleSiteUrlBuilder.getSiteContextPath(false), (Matcher)CoreMatchers.equalTo((Object)"/configured/context/path"));
        Assert.assertThat((String)"when called outside of request scope, get configured context path", (Object)this.simpleSiteUrlBuilder.getSiteContextPath(true), (Matcher)CoreMatchers.equalTo((Object)"/configured/context/path"));
        WebTestUtil.runInRequestScope(requestMock, () -> Assert.assertThat((String)"when called inside a request scope, get configured context path", (Object)this.simpleSiteUrlBuilder.getSiteContextPath(true), (Matcher)CoreMatchers.equalTo((Object)"/requestContextPath")));
    }

    @Test
    public void testGetSiteContextPathOrUrl() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getSiteURL()).thenReturn((Object)"http://my.site.com/ctx");
        HttpServletRequest requestMock = WebTestUtil.mockRequestUrl("http://server/request/context/path", "/static/style.css");
        Assert.assertThat((String)"when called outside of request scope, get absolute URL", (Object)this.simpleSiteUrlBuilder.getSiteContextPathOrUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.site.com/ctx"));
        WebTestUtil.runInRequestScope(requestMock, () -> Assert.assertThat((String)"when called inside of request scope, get relative URL, with the context of the request", (Object)this.simpleSiteUrlBuilder.getSiteContextPathOrUrl(), (Matcher)CoreMatchers.equalTo((Object)"/request/context/path")));
    }
}

